/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.world.draw.DrawBlock;

public class DrawShape
extends DrawBlock {
    public Color color = Pal.accent.cpy();
    public int sides = 4;
    public float radius = 2.0f;
    public float timeScl = 1.0f;
    public float layer = -1.0f;
    public float x;
    public float y;
    public boolean useWarmupRadius = false;

    @Override
    public void draw(Building build) {
        float pz = Draw.z();
        if (this.layer > 0.0f) {
            Draw.z(this.layer);
        }
        Draw.color(this.color);
        Fill.poly(build.x + this.x, build.y + this.y, this.sides, this.useWarmupRadius ? this.radius * build.warmup() : this.radius, build.totalProgress() * this.timeScl);
        Draw.reset();
        Draw.z(pz);
    }
}

