/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.util.Time;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.world.draw.DrawBlock;

public class DrawPulseShape
extends DrawBlock {
    public Color color = Pal.accent.cpy();
    public float stroke = 2.0f;
    public float timeScl = 100.0f;
    public float minStroke = 0.2f;
    public float radiusScl = 1.0f;
    public float layer = -1.0f;
    public boolean square = true;

    public DrawPulseShape(boolean square) {
        this.square = square;
    }

    public DrawPulseShape() {
    }

    @Override
    public void draw(Building build) {
        float pz = Draw.z();
        if (this.layer > 0.0f) {
            Draw.z(this.layer);
        }
        float f = 1.0f - Time.time / this.timeScl % 1.0f;
        float rad = (float)(build.block.size * 8) / 2.0f * this.radiusScl;
        Draw.color(this.color);
        Lines.stroke((this.stroke * f + this.minStroke) * build.warmup());
        if (this.square) {
            Lines.square(build.x, build.y, Math.min(1.0f + (1.0f - f) * rad, rad));
        } else {
            float r = Math.max(0.0f, Mathf.clamp(2.0f - f * 2.0f) * rad - f - 0.2f);
            float w = Mathf.clamp(0.5f - f) * rad * 2.0f;
            Lines.beginLine();
            for (int i = 0; i < 4; ++i) {
                Lines.linePoint(build.x + (float)Geometry.d4((int)i).x * r + (float)Geometry.d4((int)i).y * w, build.y + (float)Geometry.d4((int)i).y * r - (float)Geometry.d4((int)i).x * w);
                if (!(f < 0.5f)) continue;
                Lines.linePoint(build.x + (float)Geometry.d4((int)i).x * r - (float)Geometry.d4((int)i).y * w, build.y + (float)Geometry.d4((int)i).y * r + (float)Geometry.d4((int)i).x * w);
            }
            Lines.endLine(true);
        }
        Draw.reset();
        Draw.z(pz);
    }
}

