/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.environment;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.geom.Geometry;
import arc.scene.ui.Button;
import arc.scene.ui.layout.Table;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Tex;
import mindustry.gen.Unit;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.ColorPicker;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.TileBitmask;
import mindustry.world.blocks.environment.Floor;

public class ColoredFloor
extends Floor {
    public static final int flagIgnoreDifferentColor = 1;
    public static final int flagSmoothBlend = 2;
    private static final float[] verts = new float[20];
    public Color defaultColor = Color.white;
    protected int defaultColorRgba;

    public ColoredFloor(String name) {
        super(name);
        this.saveData = true;
        this.editorConfigurable = true;
        this.saveConfig = true;
    }

    @Override
    public void init() {
        super.init();
        this.defaultColorRgba = this.defaultColor.rgba();
        this.lastConfig = this.defaultColorRgba;
    }

    @Override
    public void buildEditorConfig(Table table) {
        ColoredFloor.showColorEdit(table, this);
    }

    public static void showColorEdit(Table t, Block block) {
        t.button(b -> {
            b.margin(4.0f);
            b.left();
            b.table(Tex.pane, in -> in.image(Tex.whiteui).update(i -> {
                Object patt1611$temp = block.lastConfig;
                if (patt1611$temp instanceof Integer) {
                    Integer col = (Integer)patt1611$temp;
                    i.color.set((int)(col | 0xFF));
                }
            }).grow()).margin(4.0f).size(50.0f).padRight(10.0f);
            b.add("@color");
        }, (Button.ButtonStyle)Styles.cleart, () -> {
            Color color;
            ColorPicker colorPicker = Vars.ui.picker;
            Object patt1905$temp = block.lastConfig;
            if (patt1905$temp instanceof Integer) {
                Integer col2 = (Integer)patt1905$temp;
                color = new Color((int)(col2 | 0xFF));
            } else {
                color = new Color(Color.white);
            }
            colorPicker.show(color, false, col -> {
                block.lastConfig = col.rgba8888();
            });
        }).left().width(250.0f).pad(3.0f).row();
    }

    @Override
    public Object getConfig(Tile tile) {
        return tile.extraData;
    }

    @Override
    public void drawBase(Tile tile) {
        Draw.color(tile.extraData | 0xFF);
        if ((tile.extraData & 0xFF) == 2 && this.autotile) {
            int bits = 0;
            for (int i = 0; i < 8; ++i) {
                Tile other = tile.nearby(Geometry.d8[i]);
                if (other == null || other.floor().blendGroup != this.blendGroup) continue;
                bits |= 1 << i;
            }
            TextureRegion region = this.autotileRegions[TileBitmask.values[bits]];
            float s = 4.0f;
            float x = tile.worldx();
            float y = tile.worldy();
            ColoredFloor.verts[0] = x - s;
            ColoredFloor.verts[1] = y - s;
            ColoredFloor.verts[2] = ColoredFloor.sample(this, tile.x, tile.y, tile.x - 1, tile.y - 1, tile.x, tile.y - 1, tile.x - 1, tile.y);
            ColoredFloor.verts[3] = region.u;
            ColoredFloor.verts[4] = region.v2;
            ColoredFloor.verts[5] = x + s;
            ColoredFloor.verts[6] = y - s;
            ColoredFloor.verts[7] = ColoredFloor.sample(this, tile.x, tile.y, tile.x, tile.y - 1, tile.x + 1, tile.y - 1, tile.x + 1, tile.y);
            ColoredFloor.verts[8] = region.u2;
            ColoredFloor.verts[9] = region.v2;
            ColoredFloor.verts[10] = x + s;
            ColoredFloor.verts[11] = y + s;
            ColoredFloor.verts[12] = ColoredFloor.sample(this, tile.x, tile.y, tile.x + 1, tile.y + 1, tile.x, tile.y + 1, tile.x + 1, tile.y);
            ColoredFloor.verts[13] = region.u2;
            ColoredFloor.verts[14] = region.v;
            ColoredFloor.verts[15] = x - s;
            ColoredFloor.verts[16] = y + s;
            ColoredFloor.verts[17] = ColoredFloor.sample(this, tile.x, tile.y, tile.x - 1, tile.y + 1, tile.x, tile.y + 1, tile.x - 1, tile.y);
            ColoredFloor.verts[18] = region.u;
            ColoredFloor.verts[19] = region.v;
            Draw.vert(region.texture, verts, 0, verts.length);
        } else {
            super.drawBase(tile);
        }
        Draw.color();
    }

    static float sample(Block target, int tx1, int ty1, int tx2, int ty2, int tx3, int ty3, int tx4, int ty4) {
        int total = 0;
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        Tile t1 = Vars.world.tile(tx1, ty1);
        Tile t2 = Vars.world.tile(tx2, ty2);
        Tile t3 = Vars.world.tile(tx3, ty3);
        Tile t4 = Vars.world.tile(tx4, ty4);
        if (t1 != null && t1.floor() == target) {
            ++total;
            r += (float)Color.ri(t1.extraData);
            g += (float)Color.gi(t1.extraData);
            b += (float)Color.bi(t1.extraData);
        }
        if (t2 != null && t2.floor() == target) {
            ++total;
            r += (float)Color.ri(t2.extraData);
            g += (float)Color.gi(t2.extraData);
            b += (float)Color.bi(t2.extraData);
        }
        if (t3 != null && t3.floor() == target) {
            ++total;
            r += (float)Color.ri(t3.extraData);
            g += (float)Color.gi(t3.extraData);
            b += (float)Color.bi(t3.extraData);
        }
        if (t4 != null && t4.floor() == target) {
            ++total;
            r += (float)Color.ri(t4.extraData);
            g += (float)Color.gi(t4.extraData);
            b += (float)Color.bi(t4.extraData);
        }
        return Color.toFloatBits((int)(r / (float)total), (int)(g / (float)total), (int)(b / (float)total), 255);
    }

    @Override
    public void drawOverlay(Tile tile) {
        Draw.color();
        super.drawOverlay(tile);
    }

    @Override
    public void floorChanged(Tile tile) {
        if (tile.extraData == 0) {
            tile.extraData = this.defaultColorRgba;
        }
    }

    @Override
    public void placeEnded(Tile tile, @Nullable Unit builder, int rotation, @Nullable Object config) {
        if (config instanceof Integer) {
            Integer i = (Integer)config;
            tile.extraData = i;
        }
    }

    @Override
    public void editorPicked(Tile tile) {
        this.lastConfig = tile.extraData;
    }

    @Override
    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Object object = plan.config;
        if (object instanceof Integer) {
            Integer i = (Integer)object;
            Draw.tint(Tmp.c1.set((int)(i | 0xFF)));
        }
        this.drawDefaultPlanRegion(plan, list);
    }

    @Override
    public boolean checkAutotileSame(Tile tile, @Nullable Tile other) {
        return other != null && (this == tile.floor() ? other.floor() : other.overlay()).blendGroup == this.blendGroup && ((tile.extraData & 0xFF) == 1 || tile.extraData == other.extraData);
    }

    @Override
    public int minimapColor(Tile tile) {
        return tile.extraData | 0xFF;
    }
}

