/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense.turrets;

import arc.struct.ObjectMap;
import mindustry.content.Fx;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Building;
import mindustry.gen.Sounds;
import mindustry.logic.LAccess;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.world.blocks.defense.turrets.ContinuousTurret;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.consumers.ConsumeLiquidFilter;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatValues;
import mindustry.world.meta.Stats;

public class ContinuousLiquidTurret
extends ContinuousTurret {
    public ObjectMap<Liquid, BulletType> ammoTypes = new ObjectMap();
    public float liquidConsumed = 0.016666668f;

    public ContinuousLiquidTurret(String name) {
        super(name);
        this.hasLiquids = true;
        this.loopSound = Sounds.minebeam;
        this.shootSound = Sounds.none;
        this.smokeEffect = Fx.none;
        this.shootEffect = Fx.none;
    }

    public void ammo(Object ... objects) {
        this.ammoTypes = ObjectMap.of(objects);
    }

    @Override
    public void setStats() {
        super.setStats();
        this.ammoTypes.each((l, b) -> {
            b.statLiquidConsumed = this.liquidConsumed;
        });
        this.stats.replace(Stat.ammo, StatValues.ammo(this.ammoTypes));
    }

    @Override
    public void init() {
        this.consume(new ConsumeLiquidFilter(i -> this.ammoTypes.containsKey((Liquid)i), this.liquidConsumed){
            {
                this.multiplier = b -> {
                    BulletType ammo = ContinuousLiquidTurret.this.ammoTypes.get(b.liquids.current());
                    return ammo == null ? 1.0f : 1.0f / ammo.ammoMultiplier;
                };
            }

            @Override
            public void display(Stats stats) {
            }
        });
        this.ammoTypes.each((item, type) -> {
            this.placeOverlapRange = Math.max(this.placeOverlapRange, this.range + type.rangeChange + this.placeOverlapMargin);
        });
        super.init();
    }

    public class ContinuousLiquidTurretBuild
    extends ContinuousTurret.ContinuousTurretBuild {
        public ContinuousLiquidTurretBuild() {
            super(ContinuousLiquidTurret.this);
        }

        @Override
        public boolean shouldActiveSound() {
            return this.wasShooting && this.enabled;
        }

        @Override
        public void updateTile() {
            super.updateTile();
            this.unit.ammo((float)this.unit.type().ammoCapacity * this.liquids.currentAmount() / ContinuousLiquidTurret.this.liquidCapacity);
        }

        @Override
        public Object senseObject(LAccess sensor) {
            Object object;
            switch (sensor) {
                case currentAmmoType: {
                    object = this.liquids.current();
                    break;
                }
                default: {
                    object = super.senseObject(sensor);
                }
            }
            return object;
        }

        @Override
        public boolean canConsume() {
            return this.hasCorrectAmmo() && super.canConsume();
        }

        @Override
        public BulletType useAmmo() {
            return this.peekAmmo();
        }

        @Override
        public BulletType peekAmmo() {
            return ContinuousLiquidTurret.this.ammoTypes.get(this.liquids.current());
        }

        @Override
        public boolean hasAmmo() {
            return this.hasCorrectAmmo() && ContinuousLiquidTurret.this.ammoTypes.get(this.liquids.current()) != null && this.liquids.currentAmount() > 0.0f;
        }

        public boolean hasCorrectAmmo() {
            return !this.bullets.any() || ((Turret.BulletEntry)this.bullets.first()).bullet.type == this.peekAmmo();
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return false;
        }

        @Override
        public boolean acceptLiquid(Building source, Liquid liquid) {
            return ContinuousLiquidTurret.this.ammoTypes.get(liquid) != null && (this.liquids.current() == liquid || !ContinuousLiquidTurret.this.ammoTypes.containsKey(this.liquids.current()) || this.liquids.get(this.liquids.current()) <= 1.0f / ContinuousLiquidTurret.this.ammoTypes.get((Liquid)this.liquids.current()).ammoMultiplier + 0.001f);
        }
    }
}

