/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense;

import arc.Events;
import arc.audio.Sound;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.struct.Seq;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.game.EventType;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Groups;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.world.Block;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class ShockwaveTower
extends Block {
    public int timerCheck;
    public float range;
    public float reload;
    public float bulletDamage;
    public float falloffCount;
    public float shake;
    public float checkInterval;
    public Sound shootSound;
    public Color waveColor;
    public Color heatColor;
    public Color shapeColor;
    public float cooldownMultiplier;
    public Effect hitEffect;
    public Effect waveEffect;
    public float shapeRotateSpeed;
    public float shapeRadius;
    public int shapeSides;
    public TextureRegion heatRegion;

    public ShockwaveTower(String name) {
        super(name);
        this.timerCheck = this.timers++;
        this.range = 110.0f;
        this.reload = 90.0f;
        this.bulletDamage = 160.0f;
        this.falloffCount = 20.0f;
        this.shake = 2.0f;
        this.checkInterval = 8.0f;
        this.shootSound = Sounds.bang;
        this.waveColor = Pal.accent;
        this.heatColor = Pal.turretHeat;
        this.shapeColor = Color.valueOf("f29c83");
        this.cooldownMultiplier = 1.0f;
        this.hitEffect = Fx.hitSquaresColor;
        this.waveEffect = Fx.pointShockwave;
        this.shapeRotateSpeed = 1.0f;
        this.shapeRadius = 6.0f;
        this.shapeSides = 4;
        this.update = true;
        this.solid = true;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.damage, this.bulletDamage, StatUnit.none);
        this.stats.add(Stat.range, this.range / 8.0f, StatUnit.blocks);
        this.stats.add(Stat.reload, 60.0f / this.reload, StatUnit.perSecond);
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.range, this.waveColor);
    }

    public class ShockwaveTowerBuild
    extends Building {
        public float reloadCounter;
        public float heat;
        public Seq<Bullet> targets;

        public ShockwaveTowerBuild() {
            this.reloadCounter = Mathf.random(ShockwaveTower.this.reload);
            this.heat = 0.0f;
            this.targets = new Seq();
        }

        @Override
        public void updateTile() {
            if (this.potentialEfficiency > 0.0f) {
                float f;
                this.reloadCounter += this.edelta();
                if (f >= ShockwaveTower.this.reload && this.timer(ShockwaveTower.this.timerCheck, ShockwaveTower.this.checkInterval)) {
                    this.targets.clear();
                    Groups.bullet.intersect(this.x - ShockwaveTower.this.range, this.y - ShockwaveTower.this.range, ShockwaveTower.this.range * 2.0f, ShockwaveTower.this.range * 2.0f, b -> {
                        if (b.team != this.team && b.type.hittable) {
                            this.targets.add((Bullet)b);
                        }
                    });
                    if (this.targets.size > 0) {
                        this.heat = 1.0f;
                        this.reloadCounter = 0.0f;
                        ShockwaveTower.this.waveEffect.at(this.x, this.y, ShockwaveTower.this.range, ShockwaveTower.this.waveColor);
                        ShockwaveTower.this.shootSound.at(this);
                        Effect.shake(ShockwaveTower.this.shake, ShockwaveTower.this.shake, this);
                        float waveDamage = Math.min(ShockwaveTower.this.bulletDamage, ShockwaveTower.this.bulletDamage * ShockwaveTower.this.falloffCount / (float)this.targets.size);
                        for (Bullet target : this.targets) {
                            if (target.damage > waveDamage) {
                                target.damage -= waveDamage;
                            } else {
                                target.remove();
                            }
                            ShockwaveTower.this.hitEffect.at(target.x, target.y, ShockwaveTower.this.waveColor);
                        }
                        if (this.team == Vars.state.rules.defaultTeam) {
                            Events.fire(EventType.Trigger.shockwaveTowerUse);
                        }
                    }
                }
            }
            this.heat = Mathf.clamp(this.heat - Time.delta / ShockwaveTower.this.reload * ShockwaveTower.this.cooldownMultiplier);
        }

        @Override
        public double sense(LAccess sensor) {
            if (sensor == LAccess.progress) {
                return this.reloadCounter / ShockwaveTower.this.reload;
            }
            return super.sense(sensor);
        }

        @Override
        public float warmup() {
            return this.heat;
        }

        @Override
        public boolean shouldConsume() {
            return this.reloadCounter < ShockwaveTower.this.reload;
        }

        @Override
        public void draw() {
            super.draw();
            Drawf.additive(ShockwaveTower.this.heatRegion, ShockwaveTower.this.heatColor, this.heat, this.x, this.y, 0.0f, 31.0f);
            Draw.z(110.0f);
            Draw.color(ShockwaveTower.this.shapeColor, ShockwaveTower.this.waveColor, Mathf.pow(this.heat, 2.0f));
            Fill.poly(this.x, this.y, ShockwaveTower.this.shapeSides, ShockwaveTower.this.shapeRadius * this.potentialEfficiency, Time.time * ShockwaveTower.this.shapeRotateSpeed);
            Draw.color();
        }

        @Override
        public void drawSelect() {
            Drawf.dashCircle(this.x, this.y, ShockwaveTower.this.range, ShockwaveTower.this.waveColor);
        }
    }
}

