/*
 * Decompiled with CFR 0.152.
 */
package mindustry.server;

import arc.ApplicationListener;
import arc.Core;
import arc.Events;
import arc.files.Fi;
import arc.func.Cons;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.ColorCodes;
import arc.util.CommandHandler;
import arc.util.Interval;
import arc.util.Log;
import arc.util.OS;
import arc.util.Strings;
import arc.util.Structs;
import arc.util.Time;
import arc.util.Timer;
import arc.util.serialization.JsonReader;
import arc.util.serialization.JsonValue;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Scanner;
import mindustry.Vars;
import mindustry.core.GameState;
import mindustry.core.Version;
import mindustry.game.EventType;
import mindustry.game.Gamemode;
import mindustry.game.Team;
import mindustry.gen.Call;
import mindustry.gen.Groups;
import mindustry.gen.Player;
import mindustry.io.JsonIO;
import mindustry.io.SaveIO;
import mindustry.maps.Map;
import mindustry.maps.MapException;
import mindustry.maps.Maps;
import mindustry.mod.Mods;
import mindustry.net.Administration;
import mindustry.net.Packets;
import mindustry.net.WorldReloader;
import mindustry.type.Item;

public class ServerControl
implements ApplicationListener {
    protected static String[] tags = new String[]{"&lc&fb[D]&fr", "&lb&fb[I]&fr", "&ly&fb[W]&fr", "&lr&fb[E]", ""};
    protected static DateTimeFormatter dateTime = DateTimeFormatter.ofPattern("MM-dd-yyyy HH:mm:ss");
    protected static DateTimeFormatter autosaveDate = DateTimeFormatter.ofPattern("MM-dd-yyyy_HH-mm-ss");
    public static ServerControl instance;
    public final CommandHandler handler = new CommandHandler("");
    public final Fi logFolder = Core.settings.getDataDirectory().child("logs/");
    private final Interval autosaveCount = new Interval();
    public Runnable serverInput = () -> {
        Scanner scan = new Scanner(System.in);
        while (scan.hasNext()) {
            String line = scan.nextLine();
            Core.app.post(() -> this.handleCommandString(line));
        }
    };
    public Fi currentLogFile;
    public boolean inGameOverWait;
    public Gamemode lastMode;
    private Timer.Task lastTask;
    private Thread socketThread;
    private ServerSocket serverSocket;
    private PrintWriter socketOutput;
    private String suggested;
    private boolean autoPaused = false;
    public Cons<EventType.GameOverEvent> gameOverListener = event -> {
        if (Vars.state.rules.waves) {
            Log.info("Game over! Reached wave @ with @ players online on map @.", Vars.state.wave, Groups.player.size(), Strings.capitalize(Vars.state.map.plainName()));
        } else {
            Log.info("Game over! Team @ is victorious with @ players online on map @.", event.winner.name, Groups.player.size(), Strings.capitalize(Vars.state.map.plainName()));
        }
        Map map = Vars.maps.getNextMap(this.lastMode, Vars.state.map);
        if (map != null) {
            Call.infoMessage((Vars.state.rules.pvp ? "[accent]The " + event.winner.coloredName() + " team is victorious![]\n" : "[scarlet]Game over![]\n") + "\nNext selected map: [accent]" + map.name() + "[white]" + (map.hasTag("author") ? " by[accent] " + map.author() + "[white]" : "") + ".\nNew game begins in " + Administration.Config.roundExtraTime.num() + " seconds.");
            Vars.state.gameOver = true;
            Call.updateGameOver(event.winner);
            Log.info("Selected next map to be @.", map.plainName());
            this.play(() -> Vars.world.loadMap(map, map.applyRules(this.lastMode)));
        } else {
            Vars.netServer.kickAll(Packets.KickReason.gameover);
            Vars.state.set(GameState.State.menu);
            Vars.net.closeServer();
        }
    };

    public ServerControl(String[] args) {
        this.setup(args);
        instance = this;
    }

    protected void setup(String[] args) {
        int unsupported;
        Core.settings.defaults("bans", "", "admins", "", "shufflemode", "custom", "globalrules", "{reactorExplosions: false, logicUnitBuild: false}");
        Administration.Config.debug.set(Administration.Config.debug.bool());
        try {
            this.lastMode = Gamemode.valueOf(Core.settings.getString("lastServerMode", "survival"));
        }
        catch (Exception e2) {
            this.lastMode = Gamemode.survival;
        }
        Log.logger = (level1, text) -> {
            if (level1 == Log.LogLevel.err) {
                text = text.replace(ColorCodes.reset, ColorCodes.lightRed + ColorCodes.bold);
            }
            String result = ColorCodes.bold + ColorCodes.lightBlack + "[" + dateTime.format(LocalDateTime.now()) + "] " + ColorCodes.reset + Log.format(tags[level1.ordinal()] + " " + text + "&fr", new Object[0]);
            System.out.println(result);
            if (Administration.Config.logging.bool()) {
                this.logToFile("[" + dateTime.format(LocalDateTime.now()) + "] " + Log.formatColors(tags[level1.ordinal()] + " " + text + "&fr", false, new Object[0]));
            }
            if (this.socketOutput != null) {
                try {
                    this.socketOutput.println(Log.formatColors(text + "&fr", false, new Object[0]));
                }
                catch (Throwable e1) {
                    Log.err("Error occurred logging to socket: @", e1.getClass().getSimpleName());
                }
            }
        };
        Log.formatter = (text, useColors, arg) -> {
            text = Strings.format(text.replace("@", "&fb&lb@&fr"), arg);
            return useColors ? Log.addColors(text) : Log.removeColors(text);
        };
        Time.setDeltaProvider(() -> Math.min(Core.graphics.getDeltaTime() * 60.0f, Vars.maxDeltaServer));
        this.registerCommands();
        Core.app.post(() -> {
            Fi fi;
            if (Administration.Config.autoUpdate.bool() && (fi = Vars.saveDirectory.child("autosavebe.msav")).exists()) {
                try {
                    SaveIO.load(fi);
                    Log.info("Auto-save loaded.");
                    Vars.state.set(GameState.State.playing);
                    Vars.netServer.openServer();
                }
                catch (Throwable e) {
                    Log.err(e);
                }
            }
            Seq<String> commands = new Seq<String>();
            if (args.length > 0) {
                commands.addAll(Strings.join(" ", args).split(","));
                Log.info("Found @ command-line arguments to parse.", commands.size);
            }
            if (!Administration.Config.startCommands.string().isEmpty()) {
                String[] startup = Strings.join(" ", Administration.Config.startCommands.string()).split(",");
                Log.info("Found @ startup commands.", startup.length);
                commands.addAll(startup);
            }
            for (String s : commands) {
                CommandHandler.CommandResponse response = this.handler.handleMessage(s);
                if (response.type == CommandHandler.ResponseType.valid) continue;
                Log.err("Invalid command argument sent: '@': @", s, response.type.name());
                Log.err("Argument usage: &lb<command-1> <command1-args...>,<command-2> <command-2-args2...>", new Object[0]);
            }
        });
        Vars.customMapDirectory.mkdirs();
        if (Version.build == -1) {
            Log.warn("&lyYour server is running a custom build, which means that client checking is disabled.", new Object[0]);
            Log.warn("&lyIt is highly advised to specify which version you're using by building with gradle args &lb&fb-Pbuildversion=&lr<build>", new Object[0]);
        }
        try {
            Vars.maps.setShuffleMode(Maps.ShuffleMode.valueOf(Core.settings.getString("shufflemode")));
        }
        catch (Exception e3) {
            Vars.maps.setShuffleMode(Maps.ShuffleMode.all);
        }
        Events.on(EventType.GameOverEvent.class, event -> {
            if (!this.inGameOverWait && this.gameOverListener != null) {
                this.gameOverListener.get((EventType.GameOverEvent)event);
            }
        });
        Events.on(EventType.WorldLoadEvent.class, e -> this.autosaveCount.reset(0, Administration.Config.autosaveSpacing.num() * 60));
        Events.run((Object)EventType.Trigger.update, () -> {
            if (Vars.state.isPlaying() && Administration.Config.autosave.bool() && this.autosaveCount.get(Administration.Config.autosaveSpacing.num() * 60)) {
                int max = Administration.Config.autosaveAmount.num();
                String mapName = (Vars.state.map.file == null ? "unknown" : Vars.state.map.file.nameWithoutExtension()).replace(" ", "_");
                String date = autosaveDate.format(LocalDateTime.now());
                Seq<Fi> autosaves = Vars.saveDirectory.findAll(f -> f.name().startsWith("auto_"));
                autosaves.sort(f -> -f.lastModified());
                if (autosaves.size >= max) {
                    for (int i = max - 1; i < autosaves.size; ++i) {
                        autosaves.get(i).delete();
                    }
                }
                String fileName = "auto_" + mapName + "_" + date + "." + "msav";
                Fi file = Vars.saveDirectory.child(fileName);
                Log.info("Autosaving...");
                try {
                    SaveIO.save(file);
                    Log.info("Autosave completed.");
                }
                catch (Throwable e) {
                    Log.err("Autosave failed.", e);
                }
            }
            if (Vars.state.isGame()) {
                if (Administration.Config.autoPause.bool()) {
                    if (Groups.player.isEmpty()) {
                        this.autoPaused = true;
                        Vars.state.set(GameState.State.paused);
                    } else if (this.autoPaused) {
                        this.autoPaused = false;
                        Vars.state.set(GameState.State.playing);
                    }
                } else if (this.autoPaused && Vars.state.isPaused()) {
                    Vars.state.set(GameState.State.playing);
                    this.autoPaused = false;
                }
            }
        });
        Events.run((Object)EventType.Trigger.socketConfigChanged, () -> {
            this.toggleSocket(false);
            this.toggleSocket(Administration.Config.socketInput.bool());
        });
        Events.on(EventType.ResetEvent.class, e -> {
            this.autoPaused = false;
        });
        Events.on(EventType.PlayEvent.class, e -> {
            try {
                JsonValue value = (JsonValue)JsonIO.json.fromJson(null, Core.settings.getString("globalrules"));
                JsonIO.json.readFields(Vars.state.rules, value);
            }
            catch (Throwable t) {
                Log.err("Error applying custom rules, proceeding without them.", t);
            }
        });
        float saveInterval = 60.0f;
        Timer.schedule(() -> {
            Vars.netServer.admins.forceSave();
            Core.settings.forceSave();
        }, saveInterval, saveInterval);
        if (!Vars.mods.orderedMods().isEmpty()) {
            Log.info("@ mods loaded.", Vars.mods.orderedMods().size);
        }
        if ((unsupported = Vars.mods.list().count(l -> !l.enabled())) > 0) {
            Log.err("There were errors loading @ mod(s):", unsupported);
            for (Mods.LoadedMod mod : Vars.mods.list().select(l -> !l.enabled())) {
                Log.err("- @ &ly(" + (Object)((Object)mod.state) + ")", mod.meta.name);
            }
        }
        this.toggleSocket(Administration.Config.socketInput.bool());
        Events.on(EventType.ServerLoadEvent.class, e -> {
            if (this.serverInput != null) {
                Thread thread = new Thread(this.serverInput, "Server Controls");
                thread.setDaemon(true);
                thread.start();
            }
            Log.info("Server loaded. Type @ for help.", "'help'");
        });
    }

    protected void registerCommands() {
        this.handler.register("help", "[command]", "Display the command list, or get help for a specific command.", arg -> {
            if (((String[])arg).length > 0) {
                CommandHandler.Command command = this.handler.getCommandList().find(c -> c.text.equalsIgnoreCase(arg[0]));
                if (command == null) {
                    Log.err("Command " + arg[0] + " not found!", new Object[0]);
                } else {
                    Log.info(command.text + ":");
                    Log.info("  &b&lb " + command.text + (command.paramText.isEmpty() ? "" : " &lc&fi") + command.paramText + "&fr - &lw" + command.description);
                }
            } else {
                Log.info("Commands:");
                for (CommandHandler.Command command : this.handler.getCommandList()) {
                    Log.info("  &b&lb " + command.text + (command.paramText.isEmpty() ? "" : " &lc&fi") + command.paramText + "&fr - &lw" + command.description);
                }
            }
        });
        this.handler.register("version", "Displays server version info.", arg -> {
            Log.info("Version: Mindustry @-@ @ / build @", Version.number, Version.modifier, Version.type, Version.build + (Version.revision == 0 ? "" : "." + Version.revision));
            Log.info("Java Version: @", OS.javaVersion);
        });
        this.handler.register("exit", "Exit the server application.", arg -> {
            Log.info("Shutting down server.");
            Vars.net.dispose();
            Core.app.exit();
        });
        this.handler.register("stop", "Stop hosting the server.", arg -> {
            Vars.net.closeServer();
            this.cancelPlayTask();
            Vars.state.set(GameState.State.menu);
            Log.info("Stopped server.");
        });
        this.handler.register("host", "[mapname] [mode]", "Open the server. Will default to survival and a random map if not specified.", arg -> {
            Map result;
            if (Vars.state.isGame()) {
                Log.err("Already hosting. Type 'stop' to stop hosting first.", new Object[0]);
                return;
            }
            this.cancelPlayTask();
            Gamemode preset = Gamemode.survival;
            if (((String[])arg).length > 1) {
                try {
                    preset = Gamemode.valueOf(arg[1]);
                }
                catch (IllegalArgumentException e) {
                    Log.err("No gamemode '@' found.", arg[1]);
                    return;
                }
            }
            if (((String[])arg).length > 0) {
                result = Vars.maps.all().find(map -> map.plainName().replace('_', ' ').equalsIgnoreCase(Strings.stripColors(arg[0]).replace('_', ' ')));
                if (result == null) {
                    Log.err("No map with name '@' found.", arg[0]);
                    return;
                }
            } else {
                result = Vars.maps.getShuffleMode().next(preset, Vars.state.map);
                if (result != null) {
                    Log.info("Randomized next map to be @.", result.plainName());
                }
            }
            Log.info("Loading map...");
            Vars.logic.reset();
            if (result != null) {
                this.lastMode = preset;
                Core.settings.put("lastServerMode", this.lastMode.name());
                try {
                    Vars.world.loadMap(result, result.applyRules(this.lastMode));
                    Vars.state.rules = result.applyRules(preset);
                    Vars.logic.play();
                    Log.info("Map loaded.");
                    Vars.netServer.openServer();
                }
                catch (MapException e) {
                    Log.err("@: @", e.map.plainName(), e.getMessage());
                }
            }
        });
        this.handler.register("maps", "[all/custom/default]", "Display available maps. Displays only custom maps by default.", arg -> {
            boolean def;
            boolean custom = ((String[])arg).length == 0 || arg[0].equals("custom") || arg[0].equals("all");
            boolean bl = def = ((String[])arg).length > 0 && (arg[0].equals("default") || arg[0].equals("all"));
            if (!Vars.maps.all().isEmpty()) {
                Seq<Map> all = new Seq<Map>();
                if (custom) {
                    all.addAll(Vars.maps.customMaps());
                }
                if (def) {
                    all.addAll(Vars.maps.defaultMaps());
                }
                if (all.isEmpty()) {
                    Log.info("No custom maps loaded. &fiTo display built-in maps, use the \"@\" argument.", "all");
                } else {
                    Log.info("Maps:");
                    for (Map map : all) {
                        String mapName = map.plainName().replace(' ', '_');
                        if (map.custom) {
                            Log.info("  @ (@): &fiCustom / @x@", mapName, map.file.name(), map.width, map.height);
                            continue;
                        }
                        Log.info("  @: &fiDefault / @x@", mapName, map.width, map.height);
                    }
                }
            } else {
                Log.info("No maps found.");
            }
            Log.info("Map directory: &fi@", Vars.customMapDirectory.file().getAbsoluteFile().toString());
        });
        this.handler.register("reloadmaps", "Reload all maps from disk.", arg -> {
            int beforeMaps = Vars.maps.all().size;
            Vars.maps.reload();
            if (Vars.maps.all().size > beforeMaps) {
                Log.info("@ new map(s) found and reloaded.", Vars.maps.all().size - beforeMaps);
            } else if (Vars.maps.all().size < beforeMaps) {
                Log.info("@ old map(s) deleted.", beforeMaps - Vars.maps.all().size);
            } else {
                Log.info("Maps reloaded.");
            }
        });
        this.handler.register("status", "Display server status.", arg -> {
            if (Vars.state.isMenu()) {
                Log.info("Status: &rserver closed");
            } else {
                Log.info("Status:");
                Log.info("  Playing on map &fi@ / Wave @", Strings.capitalize(Vars.state.map.plainName()), Vars.state.wave);
                if (Vars.state.rules.waves) {
                    Log.info("  @ seconds until next wave.", (int)(Vars.state.wavetime / 60.0f));
                }
                Log.info("  @ units / @ enemies", Groups.unit.size(), Vars.state.enemies);
                Log.info("  @ FPS, @ MB used.", Core.graphics.getFramesPerSecond(), Core.app.getJavaHeap() / 1024L / 1024L);
                if (Groups.player.size() > 0) {
                    Log.info("  Players: @", Groups.player.size());
                    for (Player p : Groups.player) {
                        Log.info("    @ @ / @", p.admin() ? "&r[A]&c" : "&b[P]&c", p.plainName(), p.uuid());
                    }
                } else {
                    Log.info("  No players connected.");
                }
            }
        });
        this.handler.register("mods", "Display all loaded mods.", arg -> {
            if (!Vars.mods.list().isEmpty()) {
                Log.info("Mods:");
                for (Mods.LoadedMod mod : Vars.mods.list()) {
                    Log.info("  @ &fi@ " + (mod.enabled() ? "" : " &lr(" + (Object)((Object)mod.state) + ")"), mod.meta.displayName, mod.meta.version);
                }
            } else {
                Log.info("No mods found.");
            }
            Log.info("Mod directory: &fi@", Vars.modDirectory.file().getAbsoluteFile().toString());
        });
        this.handler.register("mod", "<name...>", "Display information about a loaded plugin.", arg -> {
            Mods.LoadedMod mod = Vars.mods.list().find(p -> p.meta.name.equalsIgnoreCase(arg[0]));
            if (mod != null) {
                Log.info("Name: @", mod.meta.displayName);
                Log.info("Internal Name: @", mod.name);
                Log.info("Version: @", mod.meta.version);
                Log.info("Author: @", mod.meta.author);
                Log.info("Path: @", mod.file.path());
                Log.info("Description: @", mod.meta.description);
            } else {
                Log.info("No mod with name '@' found.", arg[0]);
            }
        });
        this.handler.register("js", "<script...>", "Run arbitrary Javascript.", arg -> Log.info("&fi&lw&fb" + Vars.mods.getScripts().runConsole(arg[0])));
        this.handler.register("say", "<message...>", "Send a message to all players.", arg -> {
            if (!Vars.state.isGame()) {
                Log.err("Not hosting. Host a game first.", new Object[0]);
                return;
            }
            Call.sendMessage("[scarlet][[Server]:[] " + arg[0]);
            Log.info("&fi&lcServer: &fr@", "&lw" + arg[0]);
        });
        this.handler.register("pause", "<on/off>", "Pause or unpause the game.", arg -> {
            if (Vars.state.isMenu()) {
                Log.err("Cannot pause without a game running.", new Object[0]);
                return;
            }
            boolean pause = arg[0].equals("on");
            this.autoPaused = false;
            Vars.state.set(pause ? GameState.State.paused : GameState.State.playing);
            Log.info(pause ? "Game paused." : "Game unpaused.");
        });
        this.handler.register("rules", "[remove/add] [name] [value...]", "List, remove or add global rules. These will apply regardless of map.", arg -> {
            String rules = Core.settings.getString("globalrules");
            JsonValue base = (JsonValue)JsonIO.json.fromJson(null, rules);
            if (((String[])arg).length == 0) {
                Log.info("Rules:\n@", JsonIO.print(rules));
                return;
            }
            if (((String[])arg).length == 1) {
                Log.err("Invalid usage. Specify which rule to remove or add.", new Object[0]);
                return;
            }
            if (!arg[0].equals("remove") && !arg[0].equals("add")) {
                Log.err("Invalid usage. Either add or remove rules.", new Object[0]);
                return;
            }
            boolean remove = arg[0].equals("remove");
            if (remove) {
                if (!base.has(arg[1])) {
                    Log.err("Rule not defined, so not removed.", new Object[0]);
                    return;
                }
                Log.info("Rule '@' removed.", arg[1]);
                base.remove(arg[1]);
            } else {
                if (((String[])arg).length < 3) {
                    Log.err("Missing last argument. Specify which value to set the rule to.", new Object[0]);
                    return;
                }
                try {
                    JsonValue value = new JsonReader().parse(arg[2]);
                    value.name = arg[1];
                    JsonValue parent = new JsonValue(JsonValue.ValueType.object);
                    parent.addChild(value);
                    JsonIO.json.readField(Vars.state.rules, value.name, parent);
                    if (base.has(value.name)) {
                        base.remove(value.name);
                    }
                    base.addChild(arg[1], value);
                    Log.info("Changed rule: @", value.toString().replace("\n", " "));
                }
                catch (Throwable e) {
                    Log.err("Error parsing rule JSON: @", e.getMessage());
                }
            }
            Core.settings.put("globalrules", base.toString());
            Call.setRules(Vars.state.rules);
        });
        this.handler.register("fillitems", "[team]", "Fill the core with items.", arg -> {
            Team team;
            if (!Vars.state.isGame()) {
                Log.err("Not playing. Host first.", new Object[0]);
                return;
            }
            Team team2 = team = ((String[])arg).length == 0 ? Team.sharded : Structs.find(Team.all, t -> t.name.equals(arg[0]));
            if (team == null) {
                Log.err("No team with that name found.", new Object[0]);
                return;
            }
            if (Vars.state.teams.cores(team).isEmpty()) {
                Log.err("That team has no cores.", new Object[0]);
                return;
            }
            for (Item item : Vars.content.items()) {
                Vars.state.teams.cores((Team)team).first().items.set(item, Vars.state.teams.cores((Team)team).first().storageCapacity);
            }
            Log.info("Core filled.");
        });
        this.handler.register("playerlimit", "[off/somenumber]", "Set the server player limit.", arg -> {
            if (((String[])arg).length == 0) {
                Log.info("Player limit is currently @.", Vars.netServer.admins.getPlayerLimit() == 0 ? "off" : Integer.valueOf(Vars.netServer.admins.getPlayerLimit()));
                return;
            }
            if (arg[0].equals("off")) {
                Vars.netServer.admins.setPlayerLimit(0);
                Log.info("Player limit disabled.");
                return;
            }
            if (Strings.canParsePositiveInt(arg[0]) && Strings.parseInt(arg[0]) > 0) {
                int lim = Strings.parseInt(arg[0]);
                Vars.netServer.admins.setPlayerLimit(lim);
                Log.info("Player limit is now &lc@.", lim);
            } else {
                Log.err("Limit must be a number above 0.", new Object[0]);
            }
        });
        this.handler.register("config", "[name] [value...]", "Configure server settings.", arg -> {
            if (((String[])arg).length == 0) {
                Log.info("All config values:");
                for (Administration.Config c : Administration.Config.all) {
                    Log.info("&lk| @: @", c.name, "&lc&fi" + c.get());
                    Log.info("&lk| | &lw" + c.description);
                    Log.info("&lk|");
                }
                return;
            }
            Administration.Config c = Administration.Config.all.find(conf -> conf.name.equalsIgnoreCase(arg[0]));
            if (c != null) {
                if (((String[])arg).length == 1) {
                    Log.info("'@' is currently @.", c.name, c.get());
                } else {
                    if (arg[1].equals("default")) {
                        c.set(c.defaultValue);
                    } else if (c.isBool()) {
                        c.set(arg[1].equals("on") || arg[1].equals("true"));
                    } else if (c.isNum()) {
                        try {
                            c.set(Integer.parseInt(arg[1]));
                        }
                        catch (NumberFormatException e) {
                            Log.err("Not a valid number: @", arg[1]);
                            return;
                        }
                    } else if (c.isString()) {
                        c.set(arg[1].replace("\\n", "\n"));
                    }
                    Log.info("@ set to @.", c.name, c.get());
                    Core.settings.forceSave();
                }
            } else {
                Log.err("Unknown config: '@'. Run the command with no arguments to get a list of valid configs.", arg[0]);
            }
        });
        this.handler.register("subnet-ban", "[add/remove] [address]", "Ban a subnet. This simply rejects all connections with IPs starting with some string.", arg -> {
            if (((String[])arg).length == 0) {
                Log.info("Subnets banned: @", Vars.netServer.admins.getSubnetBans().isEmpty() ? "<none>" : "");
                for (String subnet : Vars.netServer.admins.getSubnetBans()) {
                    Log.info("&lw\t" + subnet);
                }
            } else if (((String[])arg).length == 1) {
                Log.err("You must provide a subnet to add or remove.", new Object[0]);
            } else if (arg[0].equals("add")) {
                if (Vars.netServer.admins.getSubnetBans().contains(arg[1])) {
                    Log.err("That subnet is already banned.", new Object[0]);
                    return;
                }
                Vars.netServer.admins.addSubnetBan(arg[1]);
                Log.info("Banned @**", arg[1]);
            } else if (arg[0].equals("remove")) {
                if (!Vars.netServer.admins.getSubnetBans().contains(arg[1])) {
                    Log.err("That subnet isn't banned.", new Object[0]);
                    return;
                }
                Vars.netServer.admins.removeSubnetBan(arg[1]);
                Log.info("Unbanned @**", arg[1]);
            } else {
                Log.err("Incorrect usage. Provide add/remove as the second argument.", new Object[0]);
            }
        });
        this.handler.register("whitelist", "[add/remove] [ID]", "Add/remove players from the whitelist using their ID.", arg -> {
            if (((String[])arg).length == 0) {
                Seq<Administration.PlayerInfo> whitelist = Vars.netServer.admins.getWhitelisted();
                if (whitelist.isEmpty()) {
                    Log.info("No whitelisted players found.");
                } else {
                    Log.info("Whitelist:");
                    whitelist.each(p -> Log.info("- Name: @ / UUID: @", p.plainLastName(), p.id));
                }
            } else if (((String[])arg).length == 2) {
                Administration.PlayerInfo info = Vars.netServer.admins.getInfoOptional(arg[1]);
                if (info == null) {
                    Log.err("Player ID not found. You must use the ID displayed when a player joins a server.", new Object[0]);
                } else if (arg[0].equals("add")) {
                    Vars.netServer.admins.whitelist(arg[1]);
                    Log.info("Player '@' has been whitelisted.", info.plainLastName());
                } else if (arg[0].equals("remove")) {
                    Vars.netServer.admins.unwhitelist(arg[1]);
                    Log.info("Player '@' has been un-whitelisted.", info.plainLastName());
                } else {
                    Log.err("Incorrect usage. Provide add/remove as the second argument.", new Object[0]);
                }
            } else {
                Log.err("Incorrect usage. Provide an ID to add or remove.", new Object[0]);
            }
        });
        this.handler.register("shuffle", "[none/all/custom/builtin]", "Set map shuffling mode.", arg -> {
            if (((String[])arg).length == 0) {
                Log.info("Shuffle mode current set to '@'.", Vars.maps.getShuffleMode());
            } else {
                try {
                    Maps.ShuffleMode mode = Maps.ShuffleMode.valueOf(arg[0]);
                    Core.settings.put("shufflemode", mode.name());
                    Vars.maps.setShuffleMode(mode);
                    Log.info("Shuffle mode set to '@'.", arg[0]);
                }
                catch (Exception e) {
                    Log.err("Invalid shuffle mode.", new Object[0]);
                }
            }
        });
        this.handler.register("nextmap", "<mapname...>", "Set the next map to be played after a game-over. Overrides shuffling.", arg -> {
            Map res = Vars.maps.all().find(map -> map.plainName().replace('_', ' ').equalsIgnoreCase(Strings.stripColors(arg[0]).replace('_', ' ')));
            if (res != null) {
                Vars.maps.setNextMapOverride(res);
                Log.info("Next map set to '@'.", res.plainName());
            } else {
                Log.err("No map '@' found.", arg[0]);
            }
        });
        this.handler.register("kick", "<username...>", "Kick a person by name.", arg -> {
            if (!Vars.state.isGame()) {
                Log.err("Not hosting a game yet. Calm down.", new Object[0]);
                return;
            }
            Player target = Groups.player.find(p -> p.name().equals(arg[0]));
            if (target != null) {
                Call.sendMessage("[scarlet]" + target.name() + "[scarlet] has been kicked by the server.");
                target.kick(Packets.KickReason.kick);
                Log.info("It is done.");
            } else {
                Log.info("Nobody with that name could be found...");
            }
        });
        this.handler.register("ban", "<type-id/name/ip> <username/IP/ID...>", "Ban a person.", arg -> {
            if (arg[0].equals("id")) {
                Vars.netServer.admins.banPlayerID(arg[1]);
                Log.info("Banned.");
            } else if (arg[0].equals("name")) {
                Player target = Groups.player.find(p -> p.name().equalsIgnoreCase(arg[1]));
                if (target != null) {
                    Vars.netServer.admins.banPlayer(target.uuid());
                    Log.info("Banned.");
                } else {
                    Log.err("No matches found.", new Object[0]);
                }
            } else if (arg[0].equals("ip")) {
                Vars.netServer.admins.banPlayerIP(arg[1]);
                Log.info("Banned.");
            } else {
                Log.err("Invalid type.", new Object[0]);
            }
            for (Player player : Groups.player) {
                if (!Vars.netServer.admins.isIDBanned(player.uuid())) continue;
                Call.sendMessage("[scarlet]" + player.name + " has been banned.");
                player.con.kick(Packets.KickReason.banned);
            }
        });
        this.handler.register("bans", "List all banned IPs and IDs.", arg -> {
            Seq<Administration.PlayerInfo> bans = Vars.netServer.admins.getBanned();
            if (bans.size == 0) {
                Log.info("No ID-banned players have been found.");
            } else {
                Log.info("Banned players [ID]:");
                for (Administration.PlayerInfo info : bans) {
                    Log.info(" @ / Last known name: '@'", info.id, info.plainLastName());
                }
            }
            Seq<String> ipbans = Vars.netServer.admins.getBannedIPs();
            if (ipbans.size == 0) {
                Log.info("No IP-banned players have been found.");
            } else {
                Log.info("Banned players [IP]:");
                for (String string : ipbans) {
                    Administration.PlayerInfo info = Vars.netServer.admins.findByIP(string);
                    if (info != null) {
                        Log.info("  '@' / Last known name: '@' / ID: '@'", string, info.plainLastName(), info.id);
                        continue;
                    }
                    Log.info("  '@' (No known name or info)", string);
                }
            }
        });
        this.handler.register("unban", "<ip/ID>", "Completely unban a person by IP or ID.", arg -> {
            if (Vars.netServer.admins.unbanPlayerIP(arg[0]) || Vars.netServer.admins.unbanPlayerID(arg[0])) {
                Log.info("Unbanned player: @", arg[0]);
            } else {
                Log.err("That IP/ID is not banned!", new Object[0]);
            }
        });
        this.handler.register("pardon", "<ID>", "Pardons a votekicked player by ID and allows them to join again.", arg -> {
            Administration.PlayerInfo info = Vars.netServer.admins.getInfoOptional(arg[0]);
            if (info != null) {
                info.lastKicked = 0L;
                Vars.netServer.admins.kickedIPs.remove(info.lastIP);
                Log.info("Pardoned player: @", info.plainLastName());
            } else {
                Log.err("That ID can't be found.", new Object[0]);
            }
        });
        this.handler.register("admin", "<add/remove> <username/ID...>", "Make an online user admin", arg -> {
            Administration.PlayerInfo target;
            if (!Vars.state.isGame()) {
                Log.err("Open the server first.", new Object[0]);
                return;
            }
            if (!arg[0].equals("add") && !arg[0].equals("remove")) {
                Log.err("Second parameter must be either 'add' or 'remove'.", new Object[0]);
                return;
            }
            boolean add = arg[0].equals("add");
            Player playert = Groups.player.find(p -> p.plainName().equalsIgnoreCase(Strings.stripColors(arg[1])));
            if (playert != null) {
                target = playert.getInfo();
            } else {
                target = Vars.netServer.admins.getInfoOptional(arg[1]);
                playert = Groups.player.find(p -> p.getInfo() == target);
            }
            if (target != null) {
                if (add) {
                    Vars.netServer.admins.adminPlayer(target.id, playert == null ? target.adminUsid : playert.usid());
                } else {
                    Vars.netServer.admins.unAdminPlayer(target.id);
                }
                if (playert != null) {
                    playert.admin = add;
                }
                Log.info("Changed admin status of player: @", target.plainLastName());
            } else {
                Log.err("Nobody with that name or ID could be found. If adding an admin by name, make sure they're online; otherwise, use their UUID.", new Object[0]);
            }
        });
        this.handler.register("admins", "List all admins.", arg -> {
            Seq<Administration.PlayerInfo> admins = Vars.netServer.admins.getAdmins();
            if (admins.size == 0) {
                Log.info("No admins have been found.");
            } else {
                Log.info("Admins:");
                for (Administration.PlayerInfo info : admins) {
                    Log.info(" &lm @ /  ID: '@' / IP: '@'", info.plainLastName(), info.id, info.lastIP);
                }
            }
        });
        this.handler.register("players", "List all players currently in game.", arg -> {
            if (Groups.player.size() == 0) {
                Log.info("No players are currently in the server.");
            } else {
                Log.info("Players: @", Groups.player.size());
                for (Player user : Groups.player) {
                    Log.info(" @&lm @ / ID: @ / IP: @", user.admin ? "&r[A]&c" : "&b[P]&c", user.plainName(), user.uuid(), user.ip());
                }
            }
        });
        this.handler.register("runwave", "Trigger the next wave.", arg -> {
            if (!Vars.state.isGame()) {
                Log.err("Not hosting. Host a game first.", new Object[0]);
            } else {
                Vars.logic.runWave();
                Log.info("Wave spawned.");
            }
        });
        this.handler.register("loadautosave", "Loads the last auto-save.", arg -> {
            if (Vars.state.isGame()) {
                Log.err("Already hosting. Type 'stop' to stop hosting first.", new Object[0]);
                return;
            }
            Fi newestSave = Vars.saveDirectory.findAll(f -> f.name().startsWith("auto_")).min(Fi::lastModified);
            if (newestSave == null) {
                Log.err("No auto-saves found! Type `config autosave true` to enable auto-saves.", new Object[0]);
                return;
            }
            if (!SaveIO.isSaveValid(newestSave)) {
                Log.err("No (valid) save data found for slot.", new Object[0]);
                return;
            }
            Core.app.post(() -> {
                try {
                    SaveIO.load(newestSave);
                    Vars.state.rules.sector = null;
                    Log.info("Save loaded.");
                    Vars.state.set(GameState.State.playing);
                    Vars.netServer.openServer();
                }
                catch (Throwable t) {
                    Log.err("Failed to load save. Outdated or corrupt file.", new Object[0]);
                }
            });
        });
        this.handler.register("load", "<slot>", "Load a save from a slot.", arg -> {
            if (Vars.state.isGame()) {
                Log.err("Already hosting. Type 'stop' to stop hosting first.", new Object[0]);
                return;
            }
            Fi file = Vars.saveDirectory.child(arg[0] + "." + "msav");
            if (!SaveIO.isSaveValid(file)) {
                Log.err("No (valid) save data found for slot.", new Object[0]);
                return;
            }
            Core.app.post(() -> {
                try {
                    SaveIO.load(file);
                    Vars.state.rules.sector = null;
                    Log.info("Save loaded.");
                    Vars.state.set(GameState.State.playing);
                    Vars.netServer.openServer();
                }
                catch (Throwable t) {
                    Log.err("Failed to load save. Outdated or corrupt file.", new Object[0]);
                }
            });
        });
        this.handler.register("save", "<slot>", "Save game state to a slot.", arg -> {
            if (!Vars.state.isGame()) {
                Log.err("Not hosting. Host a game first.", new Object[0]);
                return;
            }
            Fi file = Vars.saveDirectory.child(arg[0] + "." + "msav");
            Core.app.post(() -> {
                SaveIO.save(file);
                Log.info("Saved to @.", file);
            });
        });
        this.handler.register("saves", "List all saves in the save directory.", arg -> {
            Log.info("Save files: ");
            for (Fi file : Vars.saveDirectory.list()) {
                if (!file.extension().equals("msav")) continue;
                Log.info("| @", file.nameWithoutExtension());
            }
        });
        this.handler.register("gameover", "Force a game over.", arg -> {
            if (Vars.state.isMenu()) {
                Log.err("Not playing a map.", new Object[0]);
                return;
            }
            Log.info("Core destroyed.");
            this.inGameOverWait = false;
            Events.fire(new EventType.GameOverEvent(Vars.state.rules.waveTeam));
        });
        this.handler.register("info", "<IP/UUID/name...>", "Find player info(s). Can optionally check for all names or IPs a player has had.", arg -> {
            ObjectSet<Administration.PlayerInfo> infos = Vars.netServer.admins.findByName(arg[0]);
            if (infos.size > 0) {
                Log.info("Players found: @", infos.size);
                int i = 0;
                for (Administration.PlayerInfo info : infos) {
                    Log.info("[@] Trace info for player '@' / UUID @ / RAW @", i++, info.plainLastName(), info.id, info.lastName);
                    Log.info("  all names used: @", info.names);
                    Log.info("  IP: @", info.lastIP);
                    Log.info("  all IPs used: @", info.ips);
                    Log.info("  times joined: @", info.timesJoined);
                    Log.info("  times kicked: @", info.timesKicked);
                }
            } else {
                Log.info("Nobody with that name could be found.");
            }
        });
        this.handler.register("search", "<name...>", "Search players who have used part of a name.", arg -> {
            ObjectSet<Administration.PlayerInfo> infos = Vars.netServer.admins.searchNames(arg[0]);
            if (infos.size > 0) {
                Log.info("Players found: @", infos.size);
                int i = 0;
                for (Administration.PlayerInfo info : infos) {
                    Log.info("- [@] '@' / @", i++, info.plainLastName(), info.id);
                }
            } else {
                Log.info("Nobody with that name could be found.");
            }
        });
        this.handler.register("gc", "Trigger a garbage collection. Testing only.", arg -> {
            int pre = (int)(Core.app.getJavaHeap() / 1024L / 1024L);
            System.gc();
            int post = (int)(Core.app.getJavaHeap() / 1024L / 1024L);
            Log.info("@ MB collected. Memory usage now at @ MB.", pre - post, post);
        });
        this.handler.register("yes", "Run the last suggested incorrect command.", arg -> {
            if (this.suggested == null) {
                Log.err("There is nothing to say yes to.", new Object[0]);
            } else {
                this.handleCommandString(this.suggested);
            }
        });
        this.handler.register("dos-ban", "[add/remove] [ip]", "Add or remove a DOS ban.", arg -> {
            if (((String[])arg).length == 0) {
                Log.info("DOS bans: @", Vars.netServer.admins.dosBlacklist.isEmpty() ? "<none>" : "");
                Vars.netServer.admins.dosBlacklist.forEach(address -> Log.info("&lw\t" + address));
                return;
            }
            if (((String[])arg).length == 1) {
                Log.err("Expected either zero or two parameters, but only got one parameter.", new Object[0]);
                return;
            }
            String action = arg[0].toLowerCase();
            String ip = arg[1];
            if (action.equals("add")) {
                Vars.netServer.admins.blacklistDos(ip);
                Log.info("Dos banned: @", ip);
                return;
            }
            if (action.equals("remove")) {
                Vars.netServer.admins.unBlacklistDos(ip);
                Log.info("Removed dos ban: @", ip);
                return;
            }
            Log.err("Unrecognized action: @", action);
        });
        Vars.mods.eachClass(p -> p.registerServerCommands(this.handler));
    }

    public void handleCommandString(String line) {
        CommandHandler.CommandResponse response = this.handler.handleMessage(line);
        if (response.type == CommandHandler.ResponseType.unknownCommand) {
            int minDst = 0;
            CommandHandler.Command closest = null;
            for (CommandHandler.Command command : this.handler.getCommandList()) {
                int dst = Strings.levenshtein(command.text, response.runCommand);
                if (dst >= 3 || closest != null && dst >= minDst) continue;
                minDst = dst;
                closest = command;
            }
            if (closest != null && !closest.text.equals("yes")) {
                Log.err("Command not found. Did you mean \"" + closest.text + "\"?", new Object[0]);
                this.suggested = line.replace(response.runCommand, closest.text);
            } else {
                Log.err("Invalid command. Type 'help' for help.", new Object[0]);
            }
        } else if (response.type == CommandHandler.ResponseType.fewArguments) {
            Log.err("Too few command arguments. Usage: " + response.command.text + " " + response.command.paramText, new Object[0]);
        } else if (response.type == CommandHandler.ResponseType.manyArguments) {
            Log.err("Too many command arguments. Usage: " + response.command.text + " " + response.command.paramText, new Object[0]);
        } else if (response.type == CommandHandler.ResponseType.valid) {
            this.suggested = null;
        }
    }

    public void cancelPlayTask() {
        if (this.lastTask != null) {
            this.lastTask.cancel();
        }
    }

    public void play(Runnable run) {
        this.play(true, run);
    }

    public void play(boolean wait, Runnable run) {
        this.inGameOverWait = true;
        this.cancelPlayTask();
        Runnable reload = () -> {
            try {
                WorldReloader reloader = new WorldReloader();
                reloader.begin();
                run.run();
                Vars.state.rules = Vars.state.map.applyRules(this.lastMode);
                Vars.logic.play();
                reloader.end();
                this.inGameOverWait = false;
            }
            catch (MapException e) {
                Log.err("@: @", e.map.plainName(), e.getMessage());
                Vars.net.closeServer();
            }
        };
        if (wait) {
            this.lastTask = Timer.schedule(reload, (float)Administration.Config.roundExtraTime.num());
        } else {
            reload.run();
        }
    }

    public void logToFile(String text) {
        if (this.currentLogFile != null && this.currentLogFile.length() > (long)Administration.Config.maxLogLength.num()) {
            this.currentLogFile.writeString("[End of log file. Date: " + dateTime.format(LocalDateTime.now()) + "]\n", true);
            this.currentLogFile = null;
        }
        for (String value : ColorCodes.values) {
            text = text.replace(value, "");
        }
        if (this.currentLogFile == null) {
            int i = 0;
            while (this.logFolder.child("log-" + i + ".txt").length() >= (long)Administration.Config.maxLogLength.num()) {
                ++i;
            }
            this.currentLogFile = this.logFolder.child("log-" + i + ".txt");
        }
        this.currentLogFile.writeString(text + "\n", true);
    }

    public void toggleSocket(boolean on) {
        if (on && this.socketThread == null) {
            this.socketThread = new Thread(() -> {
                block5: {
                    try {
                        this.serverSocket = new ServerSocket();
                        this.serverSocket.bind(new InetSocketAddress(Administration.Config.socketInputAddress.string(), Administration.Config.socketInputPort.num()));
                        while (true) {
                            String line;
                            Socket client = this.serverSocket.accept();
                            Log.info("&lkReceived command socket connection: &fi@", this.serverSocket.getLocalSocketAddress());
                            BufferedReader in = new BufferedReader(new InputStreamReader(client.getInputStream()));
                            this.socketOutput = new PrintWriter(client.getOutputStream(), true);
                            while (client.isConnected() && (line = in.readLine()) != null) {
                                String result = line;
                                Core.app.post(() -> this.handleCommandString(result));
                            }
                            Log.info("&lkLost command socket connection: &fi@", this.serverSocket.getLocalSocketAddress());
                            this.socketOutput = null;
                        }
                    }
                    catch (BindException b) {
                        Log.err("Command input socket already in use. Is another instance of the server running?", new Object[0]);
                    }
                    catch (IOException e) {
                        if (e.getMessage().equals("Socket closed") || e.getMessage().equals("Connection reset")) break block5;
                        Log.err("Terminating socket server.", new Object[0]);
                        Log.err(e);
                    }
                }
            });
            this.socketThread.setDaemon(true);
            this.socketThread.start();
        } else if (this.socketThread != null) {
            this.socketThread.interrupt();
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                Log.err(e);
            }
            this.socketThread = null;
            this.socketOutput = null;
        }
    }
}

