/*
 * Decompiled with CFR 0.152.
 */
package mindustry.net;

import arc.Core;
import arc.files.Fi;
import arc.func.Cons;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.OS;
import arc.util.Strings;
import arc.util.io.PropertiesUtils;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import mindustry.Vars;
import mindustry.core.Version;
import mindustry.mod.Mods;

public class CrashHandler {
    public static String createReport(Throwable exception) {
        String report;
        String error = CrashHandler.writeException(exception);
        Mods.LoadedMod cause = CrashHandler.getModCause(exception);
        String string = report = cause == null ? "Mindustry has crashed. How unfortunate.\n" : "The mod '" + cause.meta.displayName + "' (" + cause.name + ") has caused Mindustry to crash.\n";
        if (Vars.mods != null && Vars.mods.list().size == 0 && Version.build != -1) {
            report = report + "Report this at https://github.com/Anuken/Mindustry/issues/new?labels=bug&template=bug_report.md\n\n";
        }
        Seq<Mods.LoadedMod> enabledMods = Vars.mods == null ? null : Vars.mods.list().select(m -> m.shouldBeEnabled() && m.isSupported());
        return report + "Version: " + Version.combined() + (Version.buildDate.equals("unknown") ? "" : " (Built " + Version.buildDate + ")") + (Vars.headless ? " (Server)" : "") + "\nDate: " + new SimpleDateFormat("MMMM d, yyyy HH:mm:ss a", Locale.getDefault()).format(new Date()) + "\nOS: " + OS.osName + (OS.osArchBits != null ? " x" + OS.osArchBits : "") + " (" + OS.osArch + ")\n" + (Core.graphics == null || Core.graphics.getGLVersion() == null ? "" : "GL Version: " + Core.graphics.getGLVersion() + "\n") + ((OS.isAndroid || OS.isIos) && Core.app != null ? "Android API level: " + Core.app.getVersion() + "\n" : "") + "Java Version: " + OS.javaVersion + "\nRuntime Available Memory: " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + "mb\nCores: " + OS.cores + "\n" + (cause == null ? "" : "Likely Cause: " + cause.meta.displayName + " (" + cause.name + " v" + cause.meta.version + ")\n") + (enabledMods == null ? "<no mod init>" : "Mods: " + (enabledMods.isEmpty() ? "none (vanilla)" : enabledMods.toString(", ", mod -> mod.name + ":" + mod.meta.version))) + "\n\n" + error;
    }

    public static void log(Throwable exception) {
        try {
            Core.settings.getDataDirectory().child("crashes").child("crash_" + System.currentTimeMillis() + ".txt").writeString(CrashHandler.createReport(exception));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void handle(Throwable exception, Cons<File> writeListener) {
        try {
            try {
                Log.err(exception);
            }
            catch (Throwable no) {
                exception.printStackTrace();
            }
            try {
                Core.settings.manualSave();
            }
            catch (Throwable no) {
                // empty catch block
            }
            if (OS.username.equals("anuke") && !"steam".equals(Version.modifier)) {
                System.exit(1);
            }
            if (Version.number == 0) {
                try {
                    ObjectMap<String, String> map = new ObjectMap<String, String>();
                    PropertiesUtils.load(map, new InputStreamReader(CrashHandler.class.getResourceAsStream("/version.properties")));
                    Version.type = map.get("type");
                    Version.number = Integer.parseInt(map.get("number"));
                    Version.modifier = map.get("modifier");
                    if (map.get("build").contains(".")) {
                        String[] split = map.get("build").split("\\.");
                        Version.build = Integer.parseInt(split[0]);
                        Version.revision = Integer.parseInt(split[1]);
                    } else {
                        Version.build = Strings.canParseInt(map.get("build")) ? Integer.parseInt(map.get("build")) : -1;
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    Log.err("Failed to parse version.", new Object[0]);
                }
            }
            try {
                File file = new File(OS.getAppDataDirectoryString("Mindustry"), "crashes/crash-report-" + new SimpleDateFormat("MM_dd_yyyy_HH_mm_ss").format(new Date()) + ".txt");
                new Fi(OS.getAppDataDirectoryString("Mindustry")).child("crashes").mkdirs();
                new Fi(file).writeString(CrashHandler.createReport(exception));
                writeListener.get(file);
            }
            catch (Throwable e) {
                Log.err("Failed to save local crash report.", e);
            }
            try {
                Vars.net.dispose();
            }
            catch (Throwable e) {}
        }
        catch (Throwable death) {
            death.printStackTrace();
        }
        System.exit(1);
    }

    @Nullable
    public static Mods.LoadedMod getModCause(Throwable e) {
        if (Vars.mods == null) {
            return null;
        }
        try {
            for (StackTraceElement element : e.getStackTrace()) {
                String name = element.getClassName();
                if (name.matches("(mindustry|arc|java|javax|sun|jdk)\\..*")) continue;
                for (Mods.LoadedMod mod : Vars.mods.list()) {
                    if (mod.meta.main != null && CrashHandler.getMatches(mod.meta.main, name) > 0) {
                        return mod;
                    }
                    if (element.getFileName() == null || !element.getFileName().endsWith(".js") || !element.getFileName().startsWith(mod.name + "/")) continue;
                    return mod;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static int getMatches(String name1, String name2) {
        String[] arr1 = name1.split("\\.");
        String[] arr2 = name2.split("\\.");
        int matches = 0;
        for (int i = 0; i < Math.min(arr1.length, arr2.length); ++i) {
            if (!arr1[i].equals(arr2[i])) {
                return i;
            }
            if (arr1[i].matches("net|org|com|io")) continue;
            ++matches;
        }
        return matches;
    }

    private static String writeException(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }
}

