/*
 * Decompiled with CFR 0.152.
 */
package mindustry.logic;

import arc.util.Nullable;
import mindustry.game.Team;
import mindustry.gen.Building;

public class LVar {
    public final String name;
    public int id;
    public boolean isobj;
    public boolean constant;
    public Object objval;
    public double numval;
    public long syncTime;

    public LVar(String name) {
        this(name, -1);
    }

    public LVar(String name, int id) {
        this(name, id, false);
    }

    public LVar(String name, int id, boolean constant) {
        this.name = name;
        this.id = id;
        this.constant = constant;
    }

    @Nullable
    public Building building() {
        Building building;
        Object object;
        return this.isobj && (object = this.objval) instanceof Building ? (building = (Building)object) : null;
    }

    @Nullable
    public Object obj() {
        return this.isobj ? this.objval : null;
    }

    @Nullable
    public Team team() {
        if (this.isobj) {
            Team t;
            Object object = this.objval;
            return object instanceof Team ? (t = (Team)object) : null;
        }
        int t = (int)this.numval;
        if (t < 0 || t >= Team.all.length) {
            return null;
        }
        return Team.all[t];
    }

    public boolean bool() {
        return this.isobj ? this.objval != null : Math.abs(this.numval) >= 1.0E-5;
    }

    public double num() {
        return this.isobj ? (this.objval != null ? 1.0 : 0.0) : (LVar.invalid(this.numval) ? 0.0 : this.numval);
    }

    public double numOrNan() {
        return this.isobj ? (this.objval != null ? 1.0 : Double.NaN) : (LVar.invalid(this.numval) ? 0.0 : this.numval);
    }

    public float numf() {
        return this.isobj ? (this.objval != null ? 1.0f : 0.0f) : (LVar.invalid(this.numval) ? 0.0f : (float)this.numval);
    }

    public float numfOrNan() {
        return this.isobj ? (this.objval != null ? 1.0f : Float.NaN) : (LVar.invalid(this.numval) ? 0.0f : (float)this.numval);
    }

    public int numi() {
        return (int)this.num();
    }

    public void setbool(boolean value) {
        this.setnum(value ? 1.0 : 0.0);
    }

    public void setnum(double value) {
        if (this.constant) {
            return;
        }
        if (LVar.invalid(value)) {
            this.objval = null;
            this.isobj = true;
        } else {
            this.numval = value;
            this.objval = null;
            this.isobj = false;
        }
    }

    public void setobj(Object value) {
        if (this.constant) {
            return;
        }
        this.objval = value;
        this.isobj = true;
    }

    public void setconst(Object value) {
        this.objval = value;
        this.isobj = true;
    }

    public void set(LVar other) {
        this.isobj = other.isobj;
        if (this.isobj) {
            this.objval = other.objval;
        } else {
            this.numval = LVar.invalid(other.numval) ? 0.0 : other.numval;
        }
    }

    public static boolean invalid(double d) {
        return Double.isNaN(d) || Double.isInfinite(d);
    }

    public String toString() {
        return this.name + ": " + (this.isobj ? this.objval : Double.valueOf(this.numval)) + (this.constant ? " [const]" : "");
    }
}

