/*
 * Decompiled with CFR 0.152.
 */
package mindustry.logic;

import arc.func.Func;
import arc.graphics.Color;
import arc.graphics.Colors;
import arc.struct.ObjectMap;
import arc.struct.OrderedMap;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Strings;
import mindustry.Vars;
import mindustry.logic.LExecutor;
import mindustry.logic.LParser;
import mindustry.logic.LStatement;
import mindustry.logic.LVar;

public class LAssembler {
    public static ObjectMap<String, Func<String[], LStatement>> customParsers = new ObjectMap();
    private static final long invalidNumNegative = Long.MIN_VALUE;
    private static final long invalidNumPositive = Long.MAX_VALUE;
    private boolean privileged;
    public OrderedMap<String, LVar> vars = new OrderedMap();
    public LExecutor.LInstruction[] instructions;

    public LAssembler() {
        this.putVar((String)"@counter").isobj = false;
        this.putConst("@unit", null);
        this.putConst("@this", null);
    }

    public static LAssembler assemble(String data, boolean privileged) {
        LAssembler asm = new LAssembler();
        Seq<LStatement> st = LAssembler.read(data, privileged);
        asm.privileged = privileged;
        asm.instructions = (LExecutor.LInstruction[])st.map(l -> l.build(asm)).retainAll(l -> l != null).toArray(LExecutor.LInstruction.class);
        return asm;
    }

    public static String write(Seq<LStatement> statements) {
        StringBuilder out = new StringBuilder();
        for (LStatement s : statements) {
            s.write(out);
            out.append("\n");
        }
        return out.toString();
    }

    public static Seq<LStatement> read(String text, boolean privileged) {
        if (text == null || text.isEmpty()) {
            return new Seq<LStatement>();
        }
        return new LParser(text, privileged).parse();
    }

    public LVar var(String symbol) {
        LVar constVar = Vars.logicVars.get(symbol, this.privileged);
        if (constVar != null) {
            return constVar;
        }
        if (!(symbol = symbol.trim()).isEmpty() && symbol.charAt(0) == '\"' && symbol.charAt(symbol.length() - 1) == '\"') {
            return this.putConst("___" + symbol, symbol.substring(1, symbol.length() - 1).replace("\\n", "\n"));
        }
        double value = this.parseDouble(symbol = symbol.replace(' ', '_'));
        if (Double.isNaN(value)) {
            return this.putVar(symbol);
        }
        if (Double.isInfinite(value)) {
            value = 0.0;
        }
        return this.putConst("___" + value, value);
    }

    double parseDouble(String symbol) {
        if (symbol.startsWith("0b")) {
            return this.parseLong(false, symbol, 2, 2, symbol.length());
        }
        if (symbol.startsWith("+0b")) {
            return this.parseLong(false, symbol, 2, 3, symbol.length());
        }
        if (symbol.startsWith("-0b")) {
            return this.parseLong(true, symbol, 2, 3, symbol.length());
        }
        if (symbol.startsWith("0x")) {
            return this.parseLong(false, symbol, 16, 2, symbol.length());
        }
        if (symbol.startsWith("+0x")) {
            return this.parseLong(false, symbol, 16, 3, symbol.length());
        }
        if (symbol.startsWith("-0x")) {
            return this.parseLong(true, symbol, 16, 3, symbol.length());
        }
        if (symbol.startsWith("%[") && symbol.endsWith("]") && symbol.length() > 3) {
            return this.parseNamedColor(symbol);
        }
        if (symbol.startsWith("%") && (symbol.length() == 7 || symbol.length() == 9)) {
            return this.parseColor(symbol);
        }
        return Strings.parseDouble(symbol, Double.NaN);
    }

    double parseLong(boolean negative, String s, int radix, int start, int end) {
        long usedInvalidNum = negative ? Long.MAX_VALUE : Long.MIN_VALUE;
        long l = Strings.parseLong(s, radix, start, end, usedInvalidNum);
        return l == usedInvalidNum ? Double.NaN : (negative ? (double)(-l) : (double)l);
    }

    double parseColor(String symbol) {
        int r = Strings.parseInt(symbol, 16, 0, 1, 3);
        int g = Strings.parseInt(symbol, 16, 0, 3, 5);
        int b = Strings.parseInt(symbol, 16, 0, 5, 7);
        int a = symbol.length() == 9 ? Strings.parseInt(symbol, 16, 0, 7, 9) : 255;
        return Color.toDoubleBits(r, g, b, a);
    }

    double parseNamedColor(String symbol) {
        Color color = Colors.get(symbol.substring(2, symbol.length() - 1));
        return color == null ? Double.NaN : color.toDoubleBits();
    }

    public LVar putConst(String name, Object value) {
        LVar var = this.putVar(name);
        if (value instanceof Number) {
            Number number = (Number)value;
            var.isobj = false;
            var.numval = number.doubleValue();
            var.objval = null;
        } else {
            var.isobj = true;
            var.objval = value;
        }
        var.constant = true;
        return var;
    }

    public LVar putVar(String name) {
        if (this.vars.containsKey(name)) {
            return (LVar)this.vars.get(name);
        }
        LVar var = new LVar(name);
        var.isobj = true;
        this.vars.put(name, var);
        return var;
    }

    @Nullable
    public LVar getVar(String name) {
        return (LVar)this.vars.get(name);
    }
}

