/*
 * Decompiled with CFR 0.152.
 */
package mindustry.logic;

import arc.Core;
import arc.audio.Sound;
import arc.files.Fi;
import arc.graphics.Color;
import arc.graphics.Colors;
import arc.math.Rand;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Strings;
import java.io.DataInputStream;
import java.io.IOException;
import mindustry.Vars;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.game.Team;
import mindustry.gen.Sounds;
import mindustry.logic.LAccess;
import mindustry.logic.LStatement;
import mindustry.logic.LVar;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.type.UnitType;
import mindustry.type.Weather;
import mindustry.world.Block;
import mindustry.world.blocks.legacy.LegacyBlock;

public class GlobalVars {
    public static final int ctrlProcessor = 1;
    public static final int ctrlPlayer = 2;
    public static final int ctrlCommand = 3;
    public static final ContentType[] lookableContent = new ContentType[]{ContentType.block, ContentType.unit, ContentType.item, ContentType.liquid, ContentType.team};
    public static final ContentType[] writableLookableContent = new ContentType[]{ContentType.block, ContentType.unit, ContentType.item, ContentType.liquid};
    public static final Rand rand = new Rand();
    private static LVar varTime;
    private static LVar varTick;
    private static LVar varSecond;
    private static LVar varMinute;
    private static LVar varWave;
    private static LVar varWaveTime;
    private static LVar varMapW;
    private static LVar varMapH;
    private static LVar varWait;
    private static LVar varServer;
    private static LVar varClient;
    private static LVar varClientLocale;
    private static LVar varClientUnit;
    private static LVar varClientName;
    private static LVar varClientTeam;
    private static LVar varClientMobile;
    private ObjectMap<String, LVar> vars = new ObjectMap();
    private Seq<VarEntry> varEntries = new Seq();
    private ObjectSet<String> privilegedNames = new ObjectSet();
    private UnlockableContent[][] logicIdToContent;
    private int[][] contentIdToLogicId;
    public static final Seq<String> soundNames;

    public void init() {
        this.putEntryOnly("sectionProcessor");
        this.putEntryOnly("@this");
        this.putEntryOnly("@thisx");
        this.putEntryOnly("@thisy");
        this.putEntryOnly("@links");
        this.putEntryOnly("@ipt");
        this.putEntryOnly("sectionGeneral");
        this.put("the end", null, false, true);
        this.putEntry("false", 0);
        this.putEntry("true", 1);
        this.put("null", null, false, true);
        this.putEntry("@pi", Float.valueOf((float)Math.PI));
        this.put("\u03c0", Float.valueOf((float)Math.PI), false, true);
        this.putEntry("@e", Float.valueOf((float)Math.E));
        this.putEntry("@degToRad", Float.valueOf((float)Math.PI / 180));
        this.putEntry("@radToDeg", Float.valueOf(57.295776f));
        this.putEntryOnly("sectionMap");
        varTime = this.putEntry("@time", 0);
        varTick = this.putEntry("@tick", 0);
        varSecond = this.putEntry("@second", 0);
        varMinute = this.putEntry("@minute", 0);
        varWave = this.putEntry("@waveNumber", 0);
        varWaveTime = this.putEntry("@waveTime", 0);
        varMapW = this.putEntry("@mapw", 0);
        varMapH = this.putEntry("@maph", 0);
        varWait = this.put("@wait", null, true, true);
        this.putEntryOnly("sectionNetwork");
        varServer = this.putEntry("@server", 0, true);
        varClient = this.putEntry("@client", 0, true);
        varClientLocale = this.putEntry("@clientLocale", null, true);
        varClientUnit = this.putEntry("@clientUnit", null, true);
        varClientName = this.putEntry("@clientName", null, true);
        varClientTeam = this.putEntry("@clientTeam", 0, true);
        varClientMobile = this.putEntry("@clientMobile", 0, true);
        this.put("@ctrlProcessor", 1);
        this.put("@ctrlPlayer", 2);
        this.put("@ctrlCommand", 3);
        if (Core.assets != null) {
            for (Sound sound : Core.assets.getAll(Sound.class, new Seq(Sound.class))) {
                if (sound == Sounds.none || sound == Sounds.swish || sound.file == null) continue;
                String name2 = sound.file.nameWithoutExtension();
                soundNames.add(name2);
                this.put("@sfx-" + name2, Sounds.getSoundId(sound));
            }
        }
        for (Team team : Team.baseTeams) {
            this.put("@" + team.name, team);
        }
        for (Item item : Vars.content.items()) {
            this.put("@" + item.name, item);
        }
        for (Liquid liquid : Vars.content.liquids()) {
            this.put("@" + liquid.name, liquid);
        }
        for (Block block : Vars.content.blocks()) {
            if (!(Vars.content.item(block.name) == null & !(block instanceof LegacyBlock))) continue;
            this.put("@" + block.name, block);
        }
        for (ObjectMap.Entry entry : Colors.getColors().entries()) {
            if (Character.isUpperCase(((String)entry.key).charAt(0))) continue;
            this.put("@color" + Strings.capitalize((String)entry.key), ((Color)entry.value).toDoubleBits());
        }
        for (UnitType unitType : Vars.content.units()) {
            if (unitType.internal) continue;
            this.put("@" + unitType.name, unitType);
        }
        for (Weather weather : Vars.content.weathers()) {
            this.put("@" + weather.name, weather);
        }
        for (LAccess sensor : LAccess.all) {
            this.put("@" + sensor.name(), (Object)sensor);
        }
        LStatement.nameToAlign.each((name, align) -> this.put("@" + name, align));
        this.logicIdToContent = new UnlockableContent[ContentType.all.length][];
        this.contentIdToLogicId = new int[ContentType.all.length][];
        this.putEntryOnly("sectionLookup");
        Fi ids = Core.files.internal("logicids.dat");
        if (ids.exists()) {
            try (DataInputStream dataInputStream = new DataInputStream(ids.readByteStream());){
                for (ContentType ctype : writableLookableContent) {
                    int amount = dataInputStream.readShort();
                    this.logicIdToContent[ctype.ordinal()] = new UnlockableContent[amount];
                    this.contentIdToLogicId[ctype.ordinal()] = new int[Vars.content.getBy((ContentType)ctype).size];
                    this.putEntry("@" + ctype.name() + "Count", (short)amount);
                    for (int i = 0; i < amount; ++i) {
                        String name3 = dataInputStream.readUTF();
                        UnlockableContent fetched = (UnlockableContent)Vars.content.getByName(ctype, name3);
                        if (fetched == null) continue;
                        this.logicIdToContent[ctype.ordinal()][i] = fetched;
                        this.contentIdToLogicId[ctype.ordinal()][fetched.id] = i;
                    }
                }
            }
            catch (IOException iOException) {
                Log.err("Error reading logic ID mapping", iOException);
            }
        }
    }

    public void update() {
        GlobalVars.varTime.numval = Vars.state.tick / 60.0 * 1000.0;
        GlobalVars.varTick.numval = Vars.state.tick;
        GlobalVars.varSecond.numval = Vars.state.tick / 60.0;
        GlobalVars.varMinute.numval = Vars.state.tick / 60.0 / 60.0;
        GlobalVars.varWave.numval = Vars.state.wave;
        GlobalVars.varWaveTime.numval = Vars.state.wavetime / 60.0f;
        GlobalVars.varMapW.numval = Vars.world.width();
        GlobalVars.varMapH.numval = Vars.world.height();
        GlobalVars.varServer.numval = Vars.net.server() || !Vars.net.active() ? 1.0 : 0.0;
        double d = GlobalVars.varClient.numval = Vars.net.client() ? 1.0 : 0.0;
        if (Vars.player != null) {
            GlobalVars.varClientLocale.objval = Vars.player.locale();
            GlobalVars.varClientUnit.objval = Vars.player.unit();
            GlobalVars.varClientName.objval = Vars.player.name();
            GlobalVars.varClientTeam.numval = Vars.player.team().id;
            GlobalVars.varClientMobile.numval = Vars.mobile ? 1.0 : 0.0;
        }
    }

    public LVar waitVar() {
        return varWait;
    }

    public Seq<VarEntry> getEntries() {
        return this.varEntries;
    }

    @Nullable
    public Object lookupContent(ContentType type, int id) {
        if (type == ContentType.team) {
            return id >= 0 && id < 256 ? Team.all[id] : null;
        }
        UnlockableContent[] arr = this.logicIdToContent[type.ordinal()];
        return arr != null && id >= 0 && id < arr.length ? arr[id] : null;
    }

    public int lookupLogicId(UnlockableContent content) {
        int[] arr = this.contentIdToLogicId[content.getContentType().ordinal()];
        return arr != null && content.id >= 0 && content.id < arr.length ? arr[content.id] : -1;
    }

    public LVar get(String name) {
        return this.vars.get(name);
    }

    public LVar get(String name, boolean privileged) {
        if (!privileged && this.privilegedNames.contains(name)) {
            return this.vars.get("null");
        }
        return this.vars.get(name);
    }

    public void set(String name, double value) {
        this.get((String)name, (boolean)true).numval = value;
    }

    public LVar put(String name, Object value, boolean privileged) {
        return this.put(name, value, privileged, true);
    }

    public LVar put(String name, Object value, boolean privileged, boolean hidden) {
        LVar existingVar = this.vars.get(name);
        if (existingVar != null) {
            Log.debug("Failed to add global logic variable '@', as it already exists.", name);
            return existingVar;
        }
        LVar var = new LVar(name);
        var.constant = true;
        if (value instanceof Number) {
            Number num = (Number)value;
            var.isobj = false;
            var.numval = num.doubleValue();
        } else {
            var.isobj = true;
            var.objval = value;
        }
        this.vars.put(name, var);
        if (privileged) {
            this.privilegedNames.add(name);
        }
        if (!hidden) {
            this.varEntries.add(new VarEntry(name, "", "", privileged));
        }
        return var;
    }

    public LVar put(String name, Object value) {
        return this.put(name, value, false);
    }

    public LVar putEntry(String name, Object value) {
        return this.put(name, value, false, false);
    }

    public LVar putEntry(String name, Object value, boolean privileged) {
        return this.put(name, value, privileged, false);
    }

    public void putEntryOnly(String name) {
        this.varEntries.add(new VarEntry(name, "", "", false));
    }

    static {
        soundNames = new Seq();
    }

    public static class VarEntry {
        public String name;
        public String description;
        public String icon;
        public boolean privileged;

        public VarEntry(String name, String description, String icon, boolean privileged) {
            this.name = name;
            this.description = description;
            this.icon = icon;
            this.privileged = privileged;
        }

        public VarEntry() {
        }
    }
}

