/*
 * Decompiled with CFR 0.152.
 */
package mindustry.io.versions;

import arc.func.Prov;
import arc.util.io.Reads;
import java.io.DataInput;
import java.io.IOException;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.entities.EntityGroup;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.io.SaveVersion;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.WorldContext;

public class ShortChunkSaveVersion
extends SaveVersion {
    public ShortChunkSaveVersion(int version) {
        super(version);
    }

    @Override
    public void readWorldEntities(DataInput stream, Prov[] mapping) throws IOException {
        int amount = stream.readInt();
        for (int j = 0; j < amount; ++j) {
            this.readLegacyShortChunk(stream, (in, len) -> {
                int typeid = in.ub();
                if (mapping[typeid] == null) {
                    in.skip(len - 1);
                    return;
                }
                int id = in.i();
                Entityc entity = (Entityc)mapping[typeid].get();
                EntityGroup.checkNextId(id);
                entity.id(id);
                entity.read((Reads)in);
                entity.add();
            });
        }
        Groups.all.each(Entityc::afterReadAll);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readMap(DataInput stream, WorldContext context) throws IOException {
        int width = stream.readUnsignedShort();
        int height = stream.readUnsignedShort();
        boolean generating = context.isGenerating();
        if (!generating) {
            context.begin();
        }
        try {
            int i;
            context.resize(width, height);
            for (i = 0; i < width * height; ++i) {
                int x = i % width;
                int y = i / width;
                short floorid = stream.readShort();
                short oreid = stream.readShort();
                int consecutives = stream.readUnsignedByte();
                if (Vars.content.block(floorid) == Blocks.air) {
                    floorid = Blocks.stone.id;
                }
                context.create(x, y, floorid, oreid, 0);
                for (int j = i + 1; j < i + 1 + consecutives; ++j) {
                    int newx = j % width;
                    int newy = j / width;
                    context.create(newx, newy, floorid, oreid, 0);
                }
                i += consecutives;
            }
            for (i = 0; i < width * height; ++i) {
                Block block = Vars.content.block(stream.readShort());
                Tile tile = context.tile(i);
                if (block == null) {
                    block = Blocks.air;
                }
                boolean isCenter = true;
                byte packedCheck = stream.readByte();
                boolean hadEntity = (packedCheck & 1) != 0;
                boolean hadDataOld = (packedCheck & 2) != 0;
                boolean hadDataNew = (packedCheck & 4) != 0;
                byte data = 0;
                byte floorData = 0;
                byte overlayData = 0;
                int extraData = 0;
                if (hadDataNew) {
                    data = stream.readByte();
                    floorData = stream.readByte();
                    overlayData = stream.readByte();
                    extraData = stream.readInt();
                }
                if (hadEntity) {
                    isCenter = stream.readBoolean();
                }
                if (isCenter) {
                    tile.setBlock(block);
                }
                if (hadDataNew) {
                    tile.data = data;
                    tile.floorData = floorData;
                    tile.overlayData = overlayData;
                    tile.extraData = extraData;
                    context.onReadTileData();
                }
                if (hadEntity) {
                    if (!isCenter) continue;
                    if (block.hasBuilding()) {
                        try {
                            this.readLegacyShortChunk(stream, (in, len) -> {
                                byte revision = in.b();
                                tile.build.readAll((Reads)in, revision);
                            });
                        }
                        catch (Throwable e) {
                            throw new IOException("Failed to read tile entity of block: " + block, e);
                        }
                    } else {
                        this.skipLegacyShortChunk(stream);
                    }
                    context.onReadBuilding();
                    continue;
                }
                if (hadDataOld || hadDataNew) {
                    if (!hadDataOld) continue;
                    tile.setBlock(block);
                    tile.data = stream.readByte();
                    continue;
                }
                int consecutives = stream.readUnsignedByte();
                for (int j = i + 1; j < i + 1 + consecutives; ++j) {
                    context.tile(j).setBlock(block);
                }
                i += consecutives;
            }
        }
        finally {
            if (!generating) {
                context.end();
            }
        }
    }
}

