/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Player;
import mindustry.input.InputHandler;
import mindustry.io.TypeIO;
import mindustry.net.NetConnection;
import mindustry.net.Packet;
import mindustry.type.Item;

public class RequestItemCallPacket
extends Packet {
    private byte[] DATA = NODATA;
    public Player player;
    public Building build;
    public Item item;
    public int amount;

    @Override
    public void write(Writes WRITE) {
        if (Vars.net.server()) {
            TypeIO.writeEntity(WRITE, this.player);
        }
        TypeIO.writeBuilding(WRITE, this.build);
        TypeIO.writeItem(WRITE, this.item);
        WRITE.i(this.amount);
    }

    @Override
    public void read(Reads READ, int LENGTH) {
        this.DATA = READ.b(LENGTH);
    }

    @Override
    public void handled() {
        BAIS.setBytes(this.DATA);
        if (Vars.net.client()) {
            this.player = (Player)TypeIO.readEntity(READ);
        }
        this.build = TypeIO.readBuilding(READ);
        this.item = TypeIO.readItem(READ);
        this.amount = READ.i();
    }

    @Override
    public void handleServer(NetConnection con) {
        if (con.player == null || con.kicked) {
            return;
        }
        Player player = con.player;
        InputHandler.requestItem(player, this.build, this.item, this.amount);
        Call.requestItem__forward(con, player, this.build, this.item, this.amount);
    }

    @Override
    public void handleClient() {
        InputHandler.requestItem(this.player, this.build, this.item, this.amount);
    }
}

