/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.bullet;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import mindustry.content.Fx;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.gen.Bullet;
import mindustry.graphics.Pal;

public class LaserBoltBulletType
extends BasicBulletType {
    public float width = 2.0f;
    public float height = 7.0f;

    public LaserBoltBulletType(float speed, float damage) {
        super(speed, damage);
        this.smokeEffect = Fx.hitLaser;
        this.hitEffect = Fx.hitLaser;
        this.despawnEffect = Fx.hitLaser;
        this.hittable = false;
        this.reflectable = false;
        this.lightColor = Pal.heal;
        this.lightOpacity = 0.6f;
    }

    public LaserBoltBulletType() {
        this(1.0f, 1.0f);
    }

    @Override
    public void draw(Bullet b) {
        super.draw(b);
        Draw.color(this.backColor);
        Lines.stroke(this.width);
        Lines.lineAngleCenter(b.x, b.y, b.rotation(), this.height);
        Draw.color(this.frontColor);
        Lines.lineAngleCenter(b.x, b.y, b.rotation(), this.height / 2.0f);
        Draw.reset();
    }
}

