/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.bullet;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Mathf;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.Fires;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Bullet;
import mindustry.graphics.Pal;

public class FireBulletType
extends BulletType {
    public Color colorFrom = Pal.lightFlame;
    public Color colorMid = Pal.darkFlame;
    public Color colorTo = Color.gray;
    public float radius = 3.0f;
    public float velMin = 0.6f;
    public float velMax = 2.6f;
    public float fireTrailChance = 0.04f;
    public Effect trailEffect2 = Fx.ballfire;
    public float fireEffectChance = 0.1f;
    public float fireEffectChance2 = 0.1f;

    public FireBulletType(float speed, float damage) {
        super(speed, damage);
        this.pierce = true;
        this.collidesTiles = false;
        this.collides = false;
        this.drag = 0.03f;
        this.hitEffect = this.despawnEffect = Fx.none;
        this.trailEffect = Fx.fireballsmoke;
    }

    public FireBulletType() {
        this.pierce = true;
        this.collidesTiles = false;
        this.collides = false;
        this.drag = 0.03f;
        this.hitEffect = this.despawnEffect = Fx.none;
        this.trailEffect = Fx.fireballsmoke;
    }

    @Override
    public void init(Bullet b) {
        super.init(b);
        b.vel.setLength(Mathf.random(this.velMin, this.velMax));
    }

    @Override
    public void draw(Bullet b) {
        Draw.color(this.colorFrom, this.colorMid, this.colorTo, b.fin());
        Fill.circle(b.x, b.y, this.radius * b.fout());
        Draw.reset();
    }

    @Override
    public void update(Bullet b) {
        super.update(b);
        if (Mathf.chanceDelta(this.fireTrailChance)) {
            Fires.create(b.tileOn());
        }
        if (Mathf.chanceDelta(this.fireEffectChance)) {
            this.trailEffect.at(b.x, b.y);
        }
        if (Mathf.chanceDelta(this.fireEffectChance2)) {
            this.trailEffect2.at(b.x, b.y);
        }
    }
}

