/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.bullet;

import arc.math.geom.Position;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.gen.Building;
import mindustry.gen.Bullet;

public class EmpBulletType
extends BasicBulletType {
    public float radius = 100.0f;
    public float timeIncrease = 2.5f;
    public float timeDuration = 600.0f;
    public float powerDamageScl = 2.0f;
    public float powerSclDecrease = 0.2f;
    public Effect hitPowerEffect = Fx.hitEmpSpark;
    public Effect chainEffect = Fx.chainEmp;
    public Effect applyEffect = Fx.heal;
    public boolean hitUnits = true;
    public float unitDamageScl = 0.7f;

    @Override
    public void hit(Bullet b, float x, float y) {
        super.hit(b, x, y);
        if (!b.absorbed) {
            Vars.indexer.allBuildings(x, y, this.radius, other -> {
                if (other.team == b.team) {
                    if (other.block.hasPower && other.block.canOverdrive && other.timeScale() < this.timeIncrease) {
                        other.applyBoost(this.timeIncrease, this.timeDuration);
                        this.chainEffect.at(x, y, 0.0f, this.hitColor, other);
                        this.applyEffect.at((Position)other, (float)other.block.size * 7.0f);
                    }
                    if (other.block.hasPower && other.damaged()) {
                        other.heal(this.healPercent / 100.0f * other.maxHealth() + this.healAmount);
                        Fx.healBlockFull.at(other.x, other.y, other.block.size, this.hitColor, other.block);
                        this.applyEffect.at((Position)other, (float)other.block.size * 7.0f);
                    }
                } else if (other.power != null) {
                    Building absorber = Damage.findAbsorber(b.team, x, y, other.x, other.y);
                    if (absorber != null) {
                        other = absorber;
                    }
                    if (other.power != null && other.power.graph.getLastPowerProduced() > 0.0f) {
                        other.applySlowdown(this.powerSclDecrease, this.timeDuration);
                        other.damage(this.damage * this.powerDamageScl);
                        this.hitPowerEffect.at(other.x, other.y, b.angleTo((Position)other), this.hitColor);
                        this.chainEffect.at(x, y, 0.0f, this.hitColor, other);
                    }
                }
            });
            if (this.hitUnits) {
                Units.nearbyEnemies(b.team, x, y, this.radius, other -> {
                    if (other.team != b.team && other.hittable()) {
                        Building absorber = Damage.findAbsorber(b.team, x, y, other.x, other.y);
                        if (absorber != null) {
                            return;
                        }
                        this.hitPowerEffect.at(other.x, other.y, b.angleTo((Position)other), this.hitColor);
                        this.chainEffect.at(x, y, 0.0f, this.hitColor, other);
                        other.damage(this.damage * this.unitDamageScl);
                        other.apply(this.status, this.statusDuration);
                    }
                });
            }
        }
    }
}

