/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.abilities;

import arc.math.Mathf;
import arc.scene.ui.layout.Table;
import arc.util.noise.Simplex;
import mindustry.Vars;
import mindustry.content.Liquids;
import mindustry.entities.Puddles;
import mindustry.entities.abilities.Ability;
import mindustry.gen.Unit;
import mindustry.type.Liquid;
import mindustry.world.Tile;

public class LiquidExplodeAbility
extends Ability {
    public Liquid liquid = Liquids.water;
    public float amount = 120.0f;
    public float radAmountScale = 5.0f;
    public float radScale = 1.0f;
    public float noiseMag = 6.5f;
    public float noiseScl = 5.0f;

    @Override
    public void addStats(Table t) {
        super.addStats(t);
        t.add((this.liquid.hasEmoji() ? this.liquid.emoji() : "") + "[stat]" + this.liquid.localizedName);
    }

    @Override
    public void death(Unit unit) {
        int tx = unit.tileX();
        int ty = unit.tileY();
        int rad = Math.max((int)(unit.hitSize / 8.0f * this.radScale), 1);
        float realNoise = unit.hitSize / this.noiseMag;
        for (int x = -rad; x <= rad; ++x) {
            for (int y = -rad; y <= rad; ++y) {
                if (!((float)(x * x + y * y) <= (float)(rad * rad) - Simplex.noise2d(0, 2.0, 0.5, 1.0f / this.noiseScl, x + tx, y + ty) * realNoise * realNoise)) continue;
                float scaling = (1.0f - Mathf.dst(x, y) / (float)rad) * this.radAmountScale;
                Tile tile = Vars.world.tile(tx + x, ty + y);
                if (tile == null) continue;
                Puddles.deposit(tile, this.liquid, this.amount * scaling);
            }
        }
    }
}

