/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities;

import arc.math.Mathf;
import arc.util.Nullable;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.Bullets;
import mindustry.content.Fx;
import mindustry.entities.Fires;
import mindustry.game.Team;
import mindustry.gen.Puddle;
import mindustry.type.Liquid;
import mindustry.world.Tile;

public class Puddles {
    public static final float maxLiquid = 70.0f;

    public static void deposit(Tile tile, Tile source, Liquid liquid, float amount) {
        Puddles.deposit(tile, source, liquid, amount, true);
    }

    public static void deposit(Tile tile, Liquid liquid, float amount) {
        Puddles.deposit(tile, tile, liquid, amount, true);
    }

    @Nullable
    public static Puddle get(Tile tile) {
        return tile == null ? null : Vars.world.tiles.getPuddle(tile.array());
    }

    public static void deposit(Tile tile, Tile source, Liquid liquid, float amount, boolean initial) {
        Puddles.deposit(tile, source, liquid, amount, initial, false);
    }

    public static void deposit(Tile tile, Tile source, Liquid liquid, float amount, boolean initial, boolean cap) {
        if (tile == null) {
            return;
        }
        float ax = (tile.worldx() + source.worldx()) / 2.0f;
        float ay = (tile.worldy() + source.worldy()) / 2.0f;
        if (liquid.willBoil()) {
            if (Mathf.chanceDelta(0.16f)) {
                liquid.vaporEffect.at(ax, ay, liquid.gasColor);
            }
            return;
        }
        if (Vars.state.rules.hasEnv(2)) {
            if (Mathf.chanceDelta(0.11f) && tile != source) {
                Bullets.spaceLiquid.create(null, source.team(), ax, ay, source.angleTo(tile) + Mathf.range(50.0f), -1.0f, Mathf.random(0.0f, 0.2f), Mathf.random(0.6f, 1.0f), liquid);
            }
            return;
        }
        if (tile.floor().isLiquid && !Puddles.canStayOn(liquid, tile.floor().liquidDrop)) {
            Puddles.reactPuddle(tile.floor().liquidDrop, liquid, amount, tile, ax, ay);
            Puddle p = Puddles.get(tile);
            if (initial && p != null && p.lastRipple <= Time.time - 40.0f) {
                Fx.ripple.at(ax, ay, 1.0f, tile.floor().liquidDrop.color);
                p.lastRipple = Time.time;
            }
            return;
        }
        if (tile.floor().solid) {
            return;
        }
        Puddle p = Puddles.get(tile);
        if (p == null || p.liquid == null) {
            if (!Vars.net.client()) {
                Puddle puddle = Puddle.create();
                puddle.tile = tile;
                puddle.liquid = liquid;
                puddle.amount = Math.min(amount, 70.0f);
                puddle.set(ax, ay);
                Puddles.register(puddle);
                puddle.add();
            }
        } else if (p.liquid == liquid) {
            p.accepting = Math.max(amount, p.accepting);
            if (initial && p.lastRipple <= Time.time - 40.0f && p.amount >= 35.0f) {
                Fx.ripple.at(ax, ay, 1.0f, p.liquid.color);
                p.lastRipple = Time.time;
            }
        } else {
            float added = Puddles.reactPuddle(p.liquid, liquid, amount, p.tile, (p.x + source.worldx()) / 2.0f, (p.y + source.worldy()) / 2.0f);
            if (cap) {
                added = Mathf.clamp(70.0f - p.amount, 0.0f, added);
            }
            p.amount += added;
        }
    }

    public static boolean hasLiquid(Tile tile, Liquid liquid) {
        if (tile == null) {
            return false;
        }
        Puddle p = Puddles.get(tile);
        return p != null && p.liquid == liquid && p.amount >= 0.5f;
    }

    public static void remove(Tile tile) {
        if (tile == null) {
            return;
        }
        Vars.world.tiles.setPuddle(tile.array(), null);
    }

    public static void register(Puddle puddle) {
        Vars.world.tiles.setPuddle(puddle.tile.array(), puddle);
    }

    private static float reactPuddle(Liquid dest, Liquid liquid, float amount, Tile tile, float x, float y) {
        if (dest == null) {
            return 0.0f;
        }
        if (dest.flammability > 0.3f && liquid.temperature > 0.7f || liquid.flammability > 0.3f && dest.temperature > 0.7f) {
            Fires.create(tile);
            if (Mathf.chance(0.006 * (double)amount)) {
                Bullets.fireball.createNet(Team.derelict, x, y, Mathf.random(360.0f), -1.0f, 1.0f, 1.0f);
            }
        } else {
            if (dest.temperature > 0.7f && liquid.temperature < 0.55f) {
                if (Mathf.chance(0.5f * amount)) {
                    Fx.steam.at(x, y);
                }
                return -0.1f * amount;
            }
            if (liquid.temperature > 0.7f && dest.temperature < 0.55f) {
                if (Mathf.chance(0.8f * amount)) {
                    Fx.steam.at(x, y);
                }
                return -0.7f * amount;
            }
        }
        return dest.react(liquid, amount, tile, x, y);
    }

    private static boolean canStayOn(Liquid liquid, Liquid other) {
        return liquid.canStayOn.contains(other);
    }
}

