/*
 * Decompiled with CFR 0.152.
 */
package mindustry.core;

import arc.ApplicationListener;
import arc.Core;
import arc.Events;
import arc.func.Boolf;
import arc.func.Cons2;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.Colors;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.struct.IntSeq;
import arc.struct.IntSet;
import arc.struct.ObjectIntMap;
import arc.struct.ObjectMap;
import arc.struct.Queue;
import arc.struct.Seq;
import arc.util.CommandHandler;
import arc.util.Interval;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Timekeeper;
import arc.util.Timer;
import arc.util.io.FastDeflaterOutputStream;
import arc.util.io.ReusableByteOutStream;
import arc.util.io.Writes;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.BindException;
import java.nio.FloatBuffer;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.core.GameState;
import mindustry.core.NetClient;
import mindustry.core.Version;
import mindustry.entities.units.BuildPlan;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Groups;
import mindustry.gen.Mechc;
import mindustry.gen.Player;
import mindustry.gen.Syncc;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.logic.GlobalVars;
import mindustry.net.Administration;
import mindustry.net.NetConnection;
import mindustry.net.NetworkIO;
import mindustry.net.Packets;
import mindustry.world.Tile;
import mindustry.world.meta.BlockFlag;

public class NetServer
implements ApplicationListener {
    private static final int maxSnapshotSize = 800;
    private static final int timerBlockSync = 0;
    private static final int timerHealthSync = 1;
    private static final float blockSyncTime = 360.0f;
    private static final float healthSyncTime = 30.0f;
    private static final FloatBuffer fbuffer = FloatBuffer.allocate(20);
    private static final Writes dataWrites = new Writes(null);
    private static final IntSeq hiddenIds = new IntSeq();
    private static final IntSeq healthSeq = new IntSeq(201);
    private static final Vec2 vector = new Vec2();
    private static final float correctDist = 112.0f;
    public Administration admins = new Administration();
    public CommandHandler clientCommands = new CommandHandler("/");
    public TeamAssigner assigner = (player, players) -> {
        if (Vars.state.rules.pvp) {
            Teams.TeamData re = Vars.state.teams.getActive().min(data -> {
                if (Vars.state.rules.waveTeam == data.team && Vars.state.rules.waves || !data.hasCore() || data.team == Team.derelict) {
                    return 2.1474836E9f;
                }
                int count = 0;
                for (Player other : players) {
                    if (other.team() != data.team || other == player) continue;
                    ++count;
                }
                return (float)count + Mathf.random(-0.1f, 0.1f);
            });
            return re == null ? null : re.team;
        }
        return Vars.state.rules.defaultTeam;
    };
    public ChatFormatter chatFormatter = (player, message) -> player == null ? message : "[coral][[" + player.coloredName() + "[coral]]:[white] " + message;
    public InvalidCommandHandler invalidHandler = (player, response) -> {
        if (response.type == CommandHandler.ResponseType.manyArguments) {
            return "[scarlet]Too many arguments. Usage:[lightgray] " + response.command.text + "[gray] " + response.command.paramText;
        }
        if (response.type == CommandHandler.ResponseType.fewArguments) {
            return "[scarlet]Too few arguments. Usage:[lightgray] " + response.command.text + "[gray] " + response.command.paramText;
        }
        int minDst = 0;
        CommandHandler.Command closest = null;
        for (CommandHandler.Command command : Vars.netServer.clientCommands.getCommandList()) {
            int dst = Strings.levenshtein(command.text, response.runCommand);
            if (dst >= 3 || closest != null && dst >= minDst) continue;
            minDst = dst;
            closest = command;
        }
        if (closest != null) {
            return "[scarlet]Unknown command. Did you mean \"[lightgray]" + closest.text + "[]\"?";
        }
        return "[scarlet]Unknown command. Check [lightgray]/help[scarlet].";
    };
    private boolean closing = false;
    private boolean pvpAutoPaused = true;
    private Interval timer = new Interval(10);
    private IntSet buildHealthChanged = new IntSet();
    @Nullable
    public VoteSession currentlyKicking = null;
    public static int kickDuration = 3600;
    public static float voteDuration = 30.0f;
    public static int voteCooldown = 300;
    private ReusableByteOutStream writeBuffer = new ReusableByteOutStream(127);
    private Writes outputBuffer = new Writes(new DataOutputStream(this.writeBuffer));
    private ReusableByteOutStream syncStream = new ReusableByteOutStream();
    private DataOutputStream dataStream = new DataOutputStream(this.syncStream);
    private Writes dataStreamWrites = new Writes(this.dataStream);
    private ObjectMap<String, Seq<Cons2<Player, String>>> customPacketHandlers = new ObjectMap();
    private ObjectMap<String, Seq<Cons2<Player, byte[]>>> customBinaryPacketHandlers = new ObjectMap();
    private ObjectMap<String, Seq<Cons2<Player, Object>>> logicClientDataHandlers = new ObjectMap();

    public NetServer() {
        Vars.net.handleServer(Packets.Connect.class, (con, connect) -> {
            Events.fire(new EventType.ConnectionEvent((NetConnection)con));
            if (this.admins.isIPBanned(connect.addressTCP) || this.admins.isSubnetBanned(connect.addressTCP)) {
                con.kick(Packets.KickReason.banned);
            }
        });
        Vars.net.handleServer(Packets.Disconnect.class, (con, packet) -> {
            if (con.player != null) {
                NetServer.onDisconnect(con.player, packet.reason);
            }
        });
        Vars.net.handleServer(Packets.ConnectPacket.class, (con, packet) -> {
            boolean preventDuplicates;
            if (con.kicked) {
                return;
            }
            if (con.address.startsWith("steam:")) {
                packet.uuid = con.address.substring("steam:".length());
            }
            Events.fire(new EventType.ConnectPacketEvent((NetConnection)con, (Packets.ConnectPacket)packet));
            con.connectTime = Time.millis();
            String uuid = packet.uuid;
            if (this.admins.isIPBanned(con.address) || this.admins.isSubnetBanned(con.address) || con.kicked || !con.isConnected()) {
                return;
            }
            if (con.hasBegunConnecting) {
                con.kick(Packets.KickReason.idInUse);
                return;
            }
            Administration.PlayerInfo info = this.admins.getInfo(uuid);
            con.hasBegunConnecting = true;
            con.mobile = packet.mobile;
            if (packet.uuid == null || packet.usid == null) {
                con.kick(Packets.KickReason.idInUse);
                return;
            }
            if (this.admins.isIDBanned(uuid)) {
                con.kick(Packets.KickReason.banned);
                return;
            }
            if (Time.millis() < this.admins.getKickTime(uuid, con.address)) {
                con.kick(Packets.KickReason.recentKick);
                return;
            }
            if (this.admins.getPlayerLimit() > 0 && Groups.player.size() >= this.admins.getPlayerLimit() && !Vars.netServer.admins.isAdmin(uuid, packet.usid)) {
                con.kick(Packets.KickReason.playerLimit);
                return;
            }
            Seq<String> extraMods = packet.mods.copy();
            Seq<String> missingMods = Vars.mods.getIncompatibility(extraMods);
            if (!extraMods.isEmpty() || !missingMods.isEmpty()) {
                StringBuilder result = new StringBuilder("[accent]Incompatible mods![]\n\n");
                if (!missingMods.isEmpty()) {
                    result.append("Missing:[lightgray]\n").append("> ").append(missingMods.toString("\n> "));
                    result.append("[]\n");
                }
                if (!extraMods.isEmpty()) {
                    result.append("Unnecessary mods:[lightgray]\n").append("> ").append(extraMods.toString("\n> "));
                }
                con.kick(result.toString(), 0L);
                return;
            }
            if (!this.admins.isWhitelisted(packet.uuid, packet.usid)) {
                info.adminUsid = packet.usid;
                info.lastName = packet.name;
                info.id = packet.uuid;
                this.admins.save();
                Call.infoMessage(con, "You are not whitelisted here.");
                Log.info("&lcDo &lywhitelist add @&lc to whitelist the player &lb'@'", packet.uuid, packet.name);
                con.kick(Packets.KickReason.whitelist);
                return;
            }
            if (packet.versionType == null || (packet.version == -1 || !packet.versionType.equals(Version.type)) && Version.build != -1 && !this.admins.allowsCustomClients()) {
                con.kick(!Version.type.equals(packet.versionType) ? Packets.KickReason.typeMismatch : Packets.KickReason.customClient);
                return;
            }
            boolean bl = preventDuplicates = Vars.headless && Vars.netServer.admins.isStrict();
            if (preventDuplicates) {
                if (Groups.player.contains(p -> Strings.stripColors(p.name).trim().equalsIgnoreCase(Strings.stripColors(packet.name).trim()))) {
                    con.kick(Packets.KickReason.nameInUse);
                    return;
                }
                if (Groups.player.contains(player -> player.uuid().equals(packet.uuid) || player.usid().equals(packet.usid))) {
                    con.uuid = packet.uuid;
                    con.kick(Packets.KickReason.idInUse);
                    return;
                }
                for (NetConnection otherCon : Vars.net.getConnections()) {
                    if (otherCon == con || !uuid.equals(otherCon.uuid)) continue;
                    con.uuid = packet.uuid;
                    con.kick(Packets.KickReason.idInUse);
                    return;
                }
            }
            packet.name = this.fixName(packet.name);
            if (packet.name.trim().length() <= 0) {
                con.kick(Packets.KickReason.nameEmpty);
                return;
            }
            if (packet.locale == null) {
                packet.locale = "en";
            }
            String ip = con.address;
            this.admins.updatePlayerJoined(uuid, ip, packet.name);
            if (packet.version != Version.build && Version.build != -1 && packet.version != -1) {
                con.kick(packet.version > Version.build ? Packets.KickReason.serverOutdated : Packets.KickReason.clientOutdated);
                return;
            }
            if (packet.version == -1) {
                con.modclient = true;
            }
            Player player2 = Player.create();
            player2.admin = this.admins.isAdmin(uuid, packet.usid);
            player2.con = con;
            player2.con.usid = packet.usid;
            player2.con.uuid = uuid;
            player2.con.mobile = packet.mobile;
            player2.name = packet.name;
            player2.locale = packet.locale;
            player2.color.set(packet.color).a(1.0f);
            if (!player2.admin && !info.admin) {
                info.adminUsid = packet.usid;
            }
            try {
                this.writeBuffer.reset();
                player2.write(this.outputBuffer);
            }
            catch (Throwable t) {
                con.kick(Packets.KickReason.nameEmpty);
                Log.err(t);
                return;
            }
            con.player = player2;
            player2.team(this.assignTeam(player2));
            this.sendWorldData(player2);
            Vars.platform.updateRPC();
            Events.fire(new EventType.PlayerConnect(player2));
        });
        this.registerCommands();
    }

    @Override
    public void init() {
        Vars.mods.eachClass(mod -> mod.registerClientCommands(this.clientCommands));
    }

    private void registerCommands() {
        this.clientCommands.register("help", "[page]", "Lists all commands.", (args, player) -> {
            if (args.length > 0 && !Strings.canParseInt(args[0])) {
                player.sendMessage("[scarlet]'page' must be a number.");
                return;
            }
            int commandsPerPage = 6;
            int page = args.length > 0 ? Strings.parseInt(args[0]) : 1;
            int pages = Mathf.ceil((float)this.clientCommands.getCommandList().size / (float)commandsPerPage);
            if (--page >= pages || page < 0) {
                player.sendMessage("[scarlet]'page' must be a number between[orange] 1[] and[orange] " + pages + "[scarlet].");
                return;
            }
            StringBuilder result = new StringBuilder();
            result.append(Strings.format("[orange]-- Commands Page[lightgray] @[gray]/[lightgray]@[orange] --\n\n", page + 1, pages));
            for (int i = commandsPerPage * page; i < Math.min(commandsPerPage * (page + 1), this.clientCommands.getCommandList().size); ++i) {
                CommandHandler.Command command = this.clientCommands.getCommandList().get(i);
                result.append("[orange] /").append(command.text).append("[white] ").append(command.paramText).append("[lightgray] - ").append(command.description).append("\n");
            }
            player.sendMessage(result.toString());
        });
        this.clientCommands.register("t", "<message...>", "Send a message only to your teammates.", (args, player) -> {
            String message = this.admins.filterMessage((Player)player, args[0]);
            if (message != null) {
                String raw = "[#" + player.team().color.toString() + "]<T> " + this.chatFormatter.format((Player)player, message);
                Groups.player.each(p -> p.team() == player.team(), o -> o.sendMessage(raw, (Player)player, message));
            }
        });
        this.clientCommands.register("a", "<message...>", "Send a message only to admins.", (args, player) -> {
            if (!player.admin) {
                player.sendMessage("[scarlet]You must be an admin to use this command.");
                return;
            }
            String raw = "[#" + Pal.adminChat.toString() + "]<A> " + this.chatFormatter.format((Player)player, args[0]);
            Groups.player.each(Player::admin, a -> a.sendMessage(raw, (Player)player, args[0]));
        });
        ObjectMap cooldowns = new ObjectMap();
        this.clientCommands.register("votekick", "[player] [reason...]", "Vote to kick a player with a valid reason.", (args, player) -> {
            if (!Administration.Config.enableVotekick.bool()) {
                player.sendMessage("[scarlet]Vote-kick is disabled on this server.");
                return;
            }
            if (Groups.player.size() < 3) {
                player.sendMessage("[scarlet]At least 3 players are needed to start a votekick.");
                return;
            }
            if (player.isLocal()) {
                player.sendMessage("[scarlet]Just kick them yourself if you're the host.");
                return;
            }
            if (this.currentlyKicking != null) {
                player.sendMessage("[scarlet]A vote is already in progress.");
                return;
            }
            if (args.length == 0) {
                StringBuilder builder = new StringBuilder();
                builder.append("[orange]Players to kick: \n");
                Groups.player.each(p -> !p.admin && p.con != null && p != player, p -> builder.append("[lightgray] ").append(p.name).append("[accent] (#").append(p.id()).append(")\n"));
                player.sendMessage(builder.toString());
            } else if (args.length == 1) {
                player.sendMessage("[orange]You need a valid reason to kick the player. Add a reason after the player name.");
            } else {
                Player found;
                if (args[0].length() > 1 && args[0].startsWith("#") && Strings.canParseInt(args[0].substring(1))) {
                    int id = Strings.parseInt(args[0].substring(1));
                    found = Groups.player.find(p -> p.id() == id);
                } else {
                    found = Groups.player.find(p -> p.name.equalsIgnoreCase(args[0]));
                }
                if (found != null) {
                    if (found == player) {
                        player.sendMessage("[scarlet]You can't vote to kick yourself.");
                    } else if (found.admin) {
                        player.sendMessage("[scarlet]Did you really expect to be able to kick an admin?");
                    } else if (found.isLocal()) {
                        player.sendMessage("[scarlet]Local players cannot be kicked.");
                    } else if (found.team() != player.team()) {
                        player.sendMessage("[scarlet]Only players on your team can be kicked.");
                    } else {
                        Timekeeper vtime = (Timekeeper)((Object)cooldowns.get(player.uuid(), () -> new Timekeeper(voteCooldown)));
                        if (!vtime.get()) {
                            player.sendMessage("[scarlet]You must wait " + voteCooldown / 60 + " minutes between votekicks.");
                            return;
                        }
                        VoteSession session = new VoteSession(found);
                        session.vote((Player)player, 1);
                        Call.sendMessage(Strings.format("[lightgray]Reason:[orange] @[lightgray].", args[1]));
                        vtime.reset();
                        this.currentlyKicking = session;
                    }
                } else {
                    player.sendMessage("[scarlet]No player [orange]'" + args[0] + "'[scarlet] found.");
                }
            }
        });
        this.clientCommands.register("vote", "<y/n/c>", "Vote to kick the current player. Admins can cancel the voting with 'c'.", (arg, player) -> {
            if (this.currentlyKicking == null) {
                player.sendMessage("[scarlet]Nobody is being voted on.");
            } else {
                int sign;
                if (player.admin && arg[0].equalsIgnoreCase("c")) {
                    Call.sendMessage(Strings.format("[lightgray]Vote canceled by admin[orange] @[lightgray].", player.name));
                    this.currentlyKicking.task.cancel();
                    this.currentlyKicking = null;
                    return;
                }
                if (player.isLocal()) {
                    player.sendMessage("[scarlet]Local players can't vote. Kick the player yourself instead.");
                    return;
                }
                switch (arg[0].toLowerCase()) {
                    case "y": 
                    case "yes": {
                        int n = 1;
                        break;
                    }
                    case "n": 
                    case "no": {
                        int n = -1;
                        break;
                    }
                    default: {
                        int n = sign = 0;
                    }
                }
                if (this.currentlyKicking.voted.get(player.uuid(), 2) == sign || this.currentlyKicking.voted.get(this.admins.getInfo((String)player.uuid()).lastIP, 2) == sign) {
                    player.sendMessage(Strings.format("[scarlet]You've already voted @. Sit down.", arg[0].toLowerCase()));
                    return;
                }
                if (this.currentlyKicking.target == player) {
                    player.sendMessage("[scarlet]You can't vote on your own trial.");
                    return;
                }
                if (this.currentlyKicking.target.team() != player.team()) {
                    player.sendMessage("[scarlet]You can't vote for other teams.");
                    return;
                }
                if (sign == 0) {
                    player.sendMessage("[scarlet]Vote either 'y' (yes) or 'n' (no).");
                    return;
                }
                this.currentlyKicking.vote((Player)player, sign);
            }
        });
        this.clientCommands.register("sync", "Re-synchronize world state.", (args, player) -> {
            if (player.isLocal()) {
                player.sendMessage("[scarlet]Re-synchronizing as the host is pointless.");
            } else {
                if (Time.timeSinceMillis(player.getInfo().lastSyncTime) < 5000L) {
                    player.sendMessage("[scarlet]You may only /sync every 5 seconds.");
                    return;
                }
                player.getInfo().lastSyncTime = Time.millis();
                Call.worldDataBegin(player.con);
                Vars.netServer.sendWorldData((Player)player);
            }
        });
    }

    public int votesRequired() {
        return 2 + (Groups.player.size() > 4 ? 1 : 0);
    }

    public Team assignTeam(Player current) {
        return this.assigner.assign(current, Groups.player);
    }

    public Team assignTeam(Player current, Iterable<Player> players) {
        return this.assigner.assign(current, players);
    }

    public void sendWorldData(Player player) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        FastDeflaterOutputStream def = new FastDeflaterOutputStream(stream);
        NetworkIO.writeWorld(player, def);
        Packets.WorldStream data = new Packets.WorldStream();
        data.stream = new ByteArrayInputStream(stream.toByteArray());
        player.con.sendStream(data);
        Log.debug("Packed @ bytes of world data to @ (@ / @)", stream.size(), player.name, player.con.address, player.uuid());
    }

    public void addPacketHandler(String type, Cons2<Player, String> handler) {
        ((Seq)((Object)this.customPacketHandlers.get(type, (Seq<Cons2<Player, String>>)((Object)((Prov<Seq>)Seq::new))))).add(handler);
    }

    public Seq<Cons2<Player, String>> getPacketHandlers(String type) {
        return (Seq)((Object)this.customPacketHandlers.get(type, (Seq<Cons2<Player, String>>)((Object)((Prov<Seq>)Seq::new))));
    }

    public void addBinaryPacketHandler(String type, Cons2<Player, byte[]> handler) {
        ((Seq)((Object)this.customBinaryPacketHandlers.get(type, (Seq<Cons2<Player, byte[]>>)((Object)((Prov<Seq>)Seq::new))))).add(handler);
    }

    public Seq<Cons2<Player, byte[]>> getBinaryPacketHandlers(String type) {
        return (Seq)((Object)this.customBinaryPacketHandlers.get(type, (Seq<Cons2<Player, byte[]>>)((Object)((Prov<Seq>)Seq::new))));
    }

    public void addLogicDataHandler(String type, Cons2<Player, Object> handler) {
        ((Seq)((Object)this.logicClientDataHandlers.get(type, (Seq<Cons2<Player, Object>>)((Object)((Prov<Seq>)Seq::new))))).add(handler);
    }

    public static void onDisconnect(Player player, String reason) {
        if (player.con == null) {
            player.remove();
            return;
        }
        if (!player.con.hasDisconnected) {
            if (player.con.hasConnected) {
                Events.fire(new EventType.PlayerLeave(player));
                if (Administration.Config.showConnectMessages.bool()) {
                    Call.sendMessage("[accent]" + player.name + "[accent] has disconnected.");
                }
                Call.playerDisconnect(player.id());
            }
            String message = Strings.format("&lb@&fi&lk has disconnected. [&lb@&fi&lk] (@)", player.plainName(), player.uuid(), reason);
            if (Administration.Config.showConnectMessages.bool()) {
                Log.info(message);
            }
        }
        player.remove();
        player.con.hasDisconnected = true;
    }

    public static void requestDebugStatus(Player player) {
        int flags = (player.con.hasDisconnected ? 1 : 0) | (player.con.hasConnected ? 2 : 0) | (player.isAdded() ? 4 : 0) | (player.con.hasBegunConnecting ? 8 : 0);
        Call.debugStatusClient(player.con, flags, player.con.lastReceivedClientSnapshot, player.con.snapshotsSent);
        Call.debugStatusClientUnreliable(player.con, flags, player.con.lastReceivedClientSnapshot, player.con.snapshotsSent);
    }

    public static void debugStatusClient(int value, int lastClientSnapshot, int snapshotsSent) {
        NetServer.logClientStatus(true, value, lastClientSnapshot, snapshotsSent);
    }

    public static void debugStatusClientUnreliable(int value, int lastClientSnapshot, int snapshotsSent) {
        NetServer.logClientStatus(false, value, lastClientSnapshot, snapshotsSent);
    }

    static void logClientStatus(boolean reliable, int value, int lastClientSnapshot, int snapshotsSent) {
        Log.info("@ Debug status received. disconnected = @, connected = @, added = @, begunConnecting = @ lastClientSnapshot = @, snapshotsSent = @", reliable ? "[RELIABLE]" : "[UNRELIABLE]", (value & 1) != 0, (value & 2) != 0, (value & 4) != 0, (value & 8) != 0, lastClientSnapshot, snapshotsSent);
    }

    public static void serverPacketReliable(Player player, String type, String contents) {
        if (Vars.netServer.customPacketHandlers.containsKey(type)) {
            for (Cons2<Player, String> c : Vars.netServer.customPacketHandlers.get(type)) {
                c.get(player, contents);
            }
        }
    }

    public static void serverPacketUnreliable(Player player, String type, String contents) {
        NetServer.serverPacketReliable(player, type, contents);
    }

    public static void serverBinaryPacketReliable(Player player, String type, byte[] contents) {
        if (Vars.netServer.customBinaryPacketHandlers.containsKey(type)) {
            for (Cons2<Player, byte[]> c : Vars.netServer.customBinaryPacketHandlers.get(type)) {
                c.get(player, contents);
            }
        }
    }

    public static void serverBinaryPacketUnreliable(Player player, String type, byte[] contents) {
        NetServer.serverBinaryPacketReliable(player, type, contents);
    }

    public static void clientLogicDataReliable(Player player, String channel, Object value) {
        Seq<Cons2<Player, Object>> handlers = Vars.netServer.logicClientDataHandlers.get(channel);
        if (handlers != null) {
            for (Cons2<Player, Object> handler : handlers) {
                handler.get(player, value);
            }
        }
    }

    public static void clientLogicDataUnreliable(Player player, String channel, Object value) {
        NetServer.clientLogicDataReliable(player, channel, value);
    }

    private static boolean invalid(float f) {
        return Float.isInfinite(f) || Float.isNaN(f);
    }

    public static void clientSnapshot(Player player, int snapshotID, int unitID, boolean dead, float x, float y, float pointerX, float pointerY, float rotation, float baseRotation, float xVelocity, float yVelocity, Tile mining, boolean boosting, boolean shooting, boolean chatting, boolean building, @Nullable Queue<BuildPlan> plans, float viewX, float viewY, float viewWidth, float viewHeight) {
        boolean verifyPosition;
        NetConnection con = player.con;
        if (con == null || snapshotID < con.lastReceivedClientSnapshot) {
            return;
        }
        if (NetServer.invalid(x)) {
            x = 0.0f;
        }
        if (NetServer.invalid(y)) {
            y = 0.0f;
        }
        if (NetServer.invalid(xVelocity)) {
            xVelocity = 0.0f;
        }
        if (NetServer.invalid(yVelocity)) {
            yVelocity = 0.0f;
        }
        if (NetServer.invalid(pointerX)) {
            pointerX = 0.0f;
        }
        if (NetServer.invalid(pointerY)) {
            pointerY = 0.0f;
        }
        if (NetServer.invalid(rotation)) {
            rotation = 0.0f;
        }
        if (NetServer.invalid(baseRotation)) {
            baseRotation = 0.0f;
        }
        boolean bl = verifyPosition = Vars.netServer.admins.isStrict() && Vars.headless;
        if (con.lastReceivedClientTime == 0L) {
            con.lastReceivedClientTime = Time.millis() - 16L;
        }
        con.viewX = viewX;
        con.viewY = viewY;
        con.viewWidth = viewWidth;
        con.viewHeight = viewHeight;
        if (!player.dead() && player.unit().isFlying() && player.unit() instanceof Mechc) {
            shooting = false;
        }
        if (!(player.dead() || !player.unit().type.flying && player.unit().type.canBoost)) {
            boosting = false;
        }
        player.mouseX = pointerX;
        player.mouseY = pointerY;
        player.typing = chatting;
        player.shooting = shooting;
        player.boosting = boosting;
        Unit unit = player.unit();
        if (player.isBuilder()) {
            unit.clearBuilding();
            unit.updateBuilding(building);
            if (plans != null) {
                for (BuildPlan req : plans) {
                    Tile tile;
                    if (req == null || (tile = Vars.world.tile(req.x, req.y)) == null || !req.breaking && req.block == null || req.breaking && tile.block() == Blocks.air || !req.breaking && tile.block() == req.block && tile.team() != Team.derelict && (!req.block.rotate || tile.build != null && tile.build.rotation == req.rotation) || con.rejectedRequests.contains((BuildPlan)((Object)((Boolf<BuildPlan>)r -> r.breaking == req.breaking && r.x == req.x && r.y == req.y)))) continue;
                    if (!Vars.netServer.admins.allowAction(player, req.breaking ? Administration.ActionType.breakBlock : Administration.ActionType.placeBlock, tile, action -> {
                        action.block = req.block;
                        action.rotation = req.rotation;
                        action.config = req.config;
                    })) {
                        Call.removeQueueBlock(player.con, req.x, req.y, req.breaking);
                        con.rejectedRequests.add(req);
                        continue;
                    }
                    player.unit().plans().addLast(req);
                }
            }
        }
        con.rejectedRequests.clear();
        if (!player.dead()) {
            unit.controlWeapons(shooting, shooting);
            unit.aim(pointerX, pointerY);
            unit.mineTile = mining;
            long elapsed = Math.min(Time.timeSinceMillis(con.lastReceivedClientTime), 1500L);
            float maxSpeed = unit.speed();
            float maxMove = (float)elapsed / 1000.0f * 60.0f * maxSpeed * 1.2f;
            boolean ignorePosition = dead || unit.id != unitID;
            float newx = unit.x;
            float newy = unit.y;
            if (!ignorePosition) {
                unit.vel.set(xVelocity, yVelocity).limit(maxSpeed);
                vector.set(x, y).sub(unit);
                vector.limit(maxMove);
                float prevx = unit.x;
                float prevy = unit.y;
                if (!unit.isFlying()) {
                    unit.move(NetServer.vector.x, NetServer.vector.y);
                } else {
                    unit.trns(NetServer.vector.x, NetServer.vector.y);
                }
                newx = unit.x;
                newy = unit.y;
                if (!verifyPosition) {
                    unit.set(prevx, prevy);
                    newx = x;
                    newy = y;
                } else if (!Mathf.within(x, y, newx, newy, 112.0f)) {
                    Call.setPosition(player.con, newx, newy);
                }
            }
            fbuffer.limit(20);
            fbuffer.position(0);
            if (unit instanceof Mechc) {
                fbuffer.put(baseRotation);
            }
            fbuffer.put(rotation);
            fbuffer.put(newx);
            fbuffer.put(newy);
            fbuffer.flip();
            unit.readSyncManual(fbuffer);
        } else {
            player.x = x;
            player.y = y;
        }
        con.lastReceivedClientSnapshot = snapshotID;
        con.lastReceivedClientTime = Time.millis();
    }

    public static void adminRequest(Player player, Player other, Packets.AdminAction action, Object params) {
        if (!player.admin && !player.isLocal()) {
            Log.warn("ACCESS DENIED: Player @ / @ attempted to perform admin action '@' on '@' without proper security access.", player.plainName(), player.con == null ? "null" : player.con.address, action.name(), other == null ? null : other.plainName());
            return;
        }
        if (other == null || other.admin && !player.isLocal() && other != player) {
            Log.warn("@ &fi&lk[&lb@&fi&lk]&fb attempted to perform admin action on nonexistant or admin player.", player.plainName(), player.uuid());
            return;
        }
        Events.fire(new EventType.AdminRequestEvent(player, other, action));
        switch (action) {
            case wave: {
                Vars.logic.skipWave();
                Log.info("&lc@ &fi&lk[&lb@&fi&lk]&fb has skipped the wave.", player.plainName(), player.uuid());
                break;
            }
            case ban: {
                Vars.netServer.admins.banPlayerID(other.con.uuid);
                Vars.netServer.admins.banPlayerIP(other.con.address);
                other.kick(Packets.KickReason.banned);
                Log.info("&lc@ &fi&lk[&lb@&fi&lk]&fb has banned @ &fi&lk[&lb@&fi&lk]&fb.", player.plainName(), player.uuid(), other.plainName(), other.uuid());
                break;
            }
            case kick: {
                other.kick(Packets.KickReason.kick);
                Log.info("&lc@ &fi&lk[&lb@&fi&lk]&fb has kicked @ &fi&lk[&lb@&fi&lk]&fb.", player.plainName(), player.uuid(), other.plainName(), other.uuid());
                break;
            }
            case trace: {
                Administration.PlayerInfo stats = Vars.netServer.admins.getInfo(other.uuid());
                Administration.TraceInfo info = new Administration.TraceInfo(other.con.address, other.uuid(), other.locale, other.con.modclient, other.con.mobile, stats.timesJoined, stats.timesKicked, (String[])stats.ips.toArray(String.class), (String[])stats.names.toArray(String.class));
                if (player.con != null) {
                    Call.traceInfo(player.con, other, info);
                    break;
                }
                NetClient.traceInfo(other, info);
                break;
            }
            case switchTeam: {
                if (!(params instanceof Team)) break;
                Team team = (Team)params;
                other.team(team);
            }
        }
    }

    public static void connectConfirm(Player player) {
        if (player.con.kicked) {
            return;
        }
        player.add();
        Events.fire(new EventType.PlayerConnectionConfirmed(player));
        if (player.con == null || player.con.hasConnected) {
            return;
        }
        player.con.hasConnected = true;
        if (Administration.Config.showConnectMessages.bool()) {
            Call.sendMessage("[accent]" + player.name + "[accent] has connected.");
            String message = Strings.format("&lb@&fi&lk has connected. &fi&lk[&lb@&fi&lk]", player.plainName(), player.uuid());
            Log.info(message);
        }
        if (!Administration.Config.motd.string().equalsIgnoreCase("off")) {
            player.sendMessage(Administration.Config.motd.string());
        }
        Events.fire(new EventType.PlayerJoin(player));
    }

    public boolean isWaitingForPlayers() {
        if (Vars.state.rules.pvp && !Vars.state.gameOver) {
            int used = 0;
            for (Teams.TeamData t : Vars.state.teams.getActive()) {
                if (Groups.player.count(p -> p.team() == t.team) <= 0) continue;
                ++used;
            }
            return used < 2;
        }
        return false;
    }

    @Override
    public void update() {
        if (!Vars.headless && !this.closing && Vars.net.server() && Vars.state.isMenu()) {
            this.closing = true;
            Vars.ui.loadfrag.show("@server.closing");
            Time.runTask(5.0f, () -> {
                Vars.net.closeServer();
                Vars.ui.loadfrag.hide();
                this.closing = false;
            });
        }
        if (Vars.state.isGame() && Vars.net.server()) {
            boolean paused;
            boolean waiting;
            if (Vars.state.rules.pvp && Vars.state.rules.pvpAutoPause && (waiting = this.isWaitingForPlayers()) != (paused = Vars.state.isPaused())) {
                if (waiting) {
                    this.pvpAutoPaused = true;
                    Vars.state.set(GameState.State.paused);
                } else if (this.pvpAutoPaused) {
                    Vars.state.set(GameState.State.playing);
                    this.pvpAutoPaused = false;
                }
            }
            this.sync();
        }
    }

    public void buildHealthUpdate(Building build) {
        this.buildHealthChanged.add(build.pos());
    }

    public void openServer() {
        try {
            Vars.net.host(Administration.Config.port.num());
            Log.info("Opened a server on port @.", Administration.Config.port.num());
        }
        catch (BindException e) {
            Log.err("Unable to host: Port " + Administration.Config.port.num() + " already in use! Make sure no other servers are running on the same port in your network.", new Object[0]);
            Vars.state.set(GameState.State.menu);
        }
        catch (IOException e) {
            Log.err(e);
            Vars.state.set(GameState.State.menu);
        }
    }

    public void kickAll(Packets.KickReason reason) {
        for (NetConnection con : Vars.net.getConnections()) {
            con.kick(reason);
        }
    }

    public void writeBlockSnapshots() throws IOException {
        this.syncStream.reset();
        short sent = 0;
        for (Teams.TeamData team : Vars.state.teams.present) {
            for (Building build : Vars.indexer.getFlagged(team.team, BlockFlag.synced)) {
                sent = (short)(sent + 1);
                this.dataStream.writeInt(build.pos());
                this.dataStream.writeShort(build.block.id);
                build.writeSync(this.dataStreamWrites);
                if (this.syncStream.size() <= 800) continue;
                this.dataStream.close();
                Call.blockSnapshot(sent, this.syncStream.toByteArray());
                sent = 0;
                this.syncStream.reset();
            }
        }
        if (sent > 0) {
            this.dataStream.close();
            Call.blockSnapshot(sent, this.syncStream.toByteArray());
        }
    }

    public void writeEntitySnapshot(Player player) throws IOException {
        byte tps = (byte)Math.min(Core.graphics.getFramesPerSecond(), 255);
        this.syncStream.reset();
        byte activeTeams = (byte)Vars.state.teams.present.count(t -> t.cores.size > 0);
        this.dataStream.writeByte(activeTeams);
        NetServer.dataWrites.output = this.dataStream;
        for (Teams.TeamData data : Vars.state.teams.present) {
            if (data.cores.size <= 0) continue;
            this.dataStream.writeByte(data.team.id);
            data.cores.first().items.write(dataWrites);
        }
        this.dataStream.close();
        Call.stateSnapshot(player.con, Vars.state.wavetime, Vars.state.wave, Vars.state.enemies, Vars.state.isPaused(), Vars.state.gameOver, Vars.universe.seconds(), tps, GlobalVars.rand.seed0, GlobalVars.rand.seed1, this.syncStream.toByteArray());
        this.syncStream.reset();
        hiddenIds.clear();
        int sent = 0;
        for (Syncc entity : Groups.sync) {
            if (entity.isSyncHidden(player)) {
                hiddenIds.add(entity.id());
                continue;
            }
            this.dataStream.writeInt(entity.id());
            this.dataStream.writeByte(entity.classId() & 0xFF);
            entity.beforeWrite();
            entity.writeSync(this.dataStreamWrites);
            ++sent;
            if (this.syncStream.size() <= 800) continue;
            this.dataStream.close();
            Call.entitySnapshot(player.con, (short)sent, this.syncStream.toByteArray());
            sent = 0;
            this.syncStream.reset();
        }
        if (sent > 0) {
            this.dataStream.close();
            Call.entitySnapshot(player.con, (short)sent, this.syncStream.toByteArray());
        }
        if (NetServer.hiddenIds.size > 0) {
            Call.hiddenSnapshot(player.con, hiddenIds);
        }
        ++player.con.snapshotsSent;
    }

    public String fixName(String name) {
        if ((name = name.trim().replace("\n", "").replace("\t", "")).equals("[") || name.equals("]")) {
            return "";
        }
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) != '[' || i == name.length() - 1 || name.charAt(i + 1) == '[' || i != 0 && name.charAt(i - 1) == '[') continue;
            String prev = name.substring(0, i);
            String next = name.substring(i);
            String result = this.checkColor(next);
            name = prev + result;
        }
        StringBuilder result = new StringBuilder();
        int curChar = 0;
        while (curChar < name.length() && result.toString().getBytes(Strings.utf8).length < 40) {
            result.append(name.charAt(curChar++));
        }
        return result.toString();
    }

    public String checkColor(String str) {
        for (int i = 1; i < str.length(); ++i) {
            Color result;
            if (str.charAt(i) != ']') continue;
            String color = str.substring(1, i);
            if (Colors.get(color.toUpperCase()) != null || Colors.get(color.toLowerCase()) != null) {
                Color color2 = result = Colors.get(color.toLowerCase()) == null ? Colors.get(color.toUpperCase()) : Colors.get(color.toLowerCase());
                if (!(result.a < 1.0f)) continue;
                return str.substring(i + 1);
            }
            try {
                result = Color.valueOf(color);
                if (!(result.a < 1.0f)) continue;
                return str.substring(i + 1);
            }
            catch (Exception e) {
                return str;
            }
        }
        return str;
    }

    void sync() {
        try {
            int interval = Administration.Config.snapshotInterval.num();
            Groups.player.each(p -> !p.isLocal(), player -> {
                if (player.con == null || !player.con.isConnected()) {
                    NetServer.onDisconnect(player, "disappeared");
                    return;
                }
                NetConnection connection = player.con;
                if (Time.timeSinceMillis(connection.syncTime) < (long)interval || !connection.hasConnected) {
                    return;
                }
                connection.syncTime = Time.millis();
                try {
                    this.writeEntitySnapshot((Player)player);
                }
                catch (IOException e) {
                    Log.err(e);
                }
            });
            if (Groups.player.size() > 0 && Core.settings.getBool("blocksync") && this.timer.get(0, 360.0f)) {
                this.writeBlockSnapshots();
            }
            if (Groups.player.size() > 0 && this.buildHealthChanged.size > 0 && this.timer.get(1, 30.0f)) {
                healthSeq.clear();
                IntSet.IntSetIterator iter = this.buildHealthChanged.iterator();
                while (iter.hasNext) {
                    int next = iter.next();
                    Building build = Vars.world.build(next);
                    if (build != null) {
                        healthSeq.add(next, Float.floatToRawIntBits(build.health));
                    }
                    if (NetServer.healthSeq.size * 4 < 800) continue;
                    Call.buildHealthUpdate(healthSeq);
                    healthSeq.clear();
                }
                if (NetServer.healthSeq.size > 0) {
                    Call.buildHealthUpdate(healthSeq);
                }
                this.buildHealthChanged.clear();
            }
        }
        catch (IOException e) {
            Log.err(e);
        }
    }

    public static interface TeamAssigner {
        public Team assign(Player var1, Iterable<Player> var2);
    }

    public static interface ChatFormatter {
        public String format(@Nullable Player var1, String var2);
    }

    public static interface InvalidCommandHandler {
        public String handle(Player var1, CommandHandler.CommandResponse var2);
    }

    public class VoteSession {
        Player target;
        ObjectIntMap<String> voted = new ObjectIntMap();
        Timer.Task task;
        int votes;

        public VoteSession(Player target) {
            this.target = target;
            this.task = Timer.schedule(() -> {
                if (!this.checkPass()) {
                    Call.sendMessage(Strings.format("[lightgray]Vote failed. Not enough votes to kick[orange] @[lightgray].", target.name));
                    NetServer.this.currentlyKicking = null;
                    this.task.cancel();
                }
            }, voteDuration);
        }

        void vote(Player player, int d) {
            int lastVote = this.voted.get(player.uuid(), 0) | this.voted.get(NetServer.this.admins.getInfo((String)player.uuid()).lastIP, 0);
            this.votes -= lastVote;
            this.votes += d;
            this.voted.put(player.uuid(), d);
            this.voted.put(NetServer.this.admins.getInfo((String)player.uuid()).lastIP, d);
            Call.sendMessage(Strings.format("[lightgray]@[lightgray] has voted on kicking[orange] @[lightgray].[accent] (@/@)\n[lightgray]Type[orange] /vote <y/n>[] to agree.", player.name, this.target.name, this.votes, NetServer.this.votesRequired()));
            this.checkPass();
        }

        boolean checkPass() {
            if (this.votes >= NetServer.this.votesRequired()) {
                Call.sendMessage(Strings.format("[orange]Vote passed.[scarlet] @[orange] will be banned from the server for @ minutes.", this.target.name, kickDuration / 60));
                Groups.player.each(p -> p.uuid().equals(this.target.uuid()), p -> p.kick(Packets.KickReason.vote, (long)(kickDuration * 1000)));
                NetServer.this.currentlyKicking = null;
                this.task.cancel();
                return true;
            }
            return false;
        }
    }
}

