/*
 * Decompiled with CFR 0.152.
 */
package mindustry.core;

import arc.Core;
import arc.assets.AssetDescriptor;
import arc.assets.loaders.FileHandleResolver;
import arc.assets.loaders.MusicLoader;
import arc.assets.loaders.SoundLoader;
import arc.audio.Music;
import arc.audio.Sound;
import arc.files.Fi;
import arc.func.Prov;
import arc.struct.ObjectMap;
import mindustry.Vars;
import mindustry.gen.Sounds;

public class FileTree
implements FileHandleResolver {
    private ObjectMap<String, Fi> files = new ObjectMap();
    private ObjectMap<String, Sound> loadedSounds = new ObjectMap();
    private ObjectMap<String, Music> loadedMusic = new ObjectMap();

    public void addFile(String path, Fi f) {
        this.files.put(path.replace('\\', '/'), f);
    }

    public Fi get(String path) {
        return this.get(path, false);
    }

    public Fi get(String path, boolean safe) {
        if (this.files.containsKey(path)) {
            return this.files.get(path);
        }
        if (this.files.containsKey("/" + path)) {
            return this.files.get("/" + path);
        }
        if (Core.files == null && !safe) {
            return Fi.get(path);
        }
        return Core.files.internal(path);
    }

    public void clear() {
        this.files.clear();
    }

    @Override
    public Fi resolve(String fileName) {
        return this.get(fileName);
    }

    public Sound loadSound(String soundName) {
        if (Vars.headless) {
            return Sounds.none;
        }
        return (Sound)((Object)this.loadedSounds.get(soundName, (Sound)((Object)((Prov<Sound>)() -> {
            String name = "sounds/" + soundName;
            String path = Vars.tree.get(name + ".ogg").exists() ? name + ".ogg" : name + ".mp3";
            Sound sound = new Sound();
            AssetDescriptor<Sound> desc = Core.assets.load(path, Sound.class, new SoundLoader.SoundParameter(sound));
            desc.errored = Throwable::printStackTrace;
            return sound;
        }))));
    }

    public Music loadMusic(String musicName) {
        if (Vars.headless) {
            return new Music();
        }
        return (Music)((Object)this.loadedMusic.get(musicName, (Music)((Object)((Prov<Music>)() -> {
            String name = "music/" + musicName;
            String path = Vars.tree.get(name + ".ogg").exists() ? name + ".ogg" : name + ".mp3";
            Music music = new Music();
            AssetDescriptor<Music> desc = Core.assets.load(path, Music.class, new MusicLoader.MusicParameter(music));
            desc.errored = Throwable::printStackTrace;
            return music;
        }))));
    }
}

