/*
 * Decompiled with CFR 0.152.
 */
package mindustry.content;

import arc.graphics.Color;
import mindustry.content.StatusEffects;
import mindustry.gen.Sounds;
import mindustry.type.Weather;
import mindustry.type.weather.ParticleWeather;
import mindustry.type.weather.RainWeather;
import mindustry.world.meta.Attribute;

public class Weathers {
    public static Weather rain;
    public static Weather snow;
    public static Weather sandstorm;
    public static Weather sporestorm;
    public static Weather fog;
    public static Weather suspendParticles;

    public static void load() {
        snow = new ParticleWeather("snowing"){
            {
                this.particleRegion = "particle";
                this.sizeMax = 13.0f;
                this.sizeMin = 2.6f;
                this.density = 1200.0f;
                this.attrs.set(Attribute.light, -0.15f);
                this.sound = Sounds.windhowl;
                this.soundVol = 0.0f;
                this.soundVolOscMag = 1.5f;
                this.soundVolOscScl = 1100.0f;
                this.soundVolMin = 0.02f;
            }
        };
        rain = new RainWeather("rain"){
            {
                this.attrs.set(Attribute.light, -0.2f);
                this.attrs.set(Attribute.water, 0.2f);
                this.status = StatusEffects.wet;
                this.sound = Sounds.rain;
                this.soundVol = 0.25f;
            }
        };
        sandstorm = new ParticleWeather("sandstorm"){
            {
                this.color = this.noiseColor = Color.valueOf("f7cba4");
                this.particleRegion = "particle";
                this.drawNoise = true;
                this.useWindVector = true;
                this.sizeMax = 140.0f;
                this.sizeMin = 70.0f;
                this.minAlpha = 0.0f;
                this.maxAlpha = 0.2f;
                this.density = 1500.0f;
                this.baseSpeed = 5.4f;
                this.attrs.set(Attribute.light, -0.1f);
                this.attrs.set(Attribute.water, -0.1f);
                this.opacityMultiplier = 0.35f;
                this.force = 0.1f;
                this.sound = Sounds.wind;
                this.soundVol = 0.8f;
                this.duration = 25200.0f;
            }
        };
        sporestorm = new ParticleWeather("sporestorm"){
            {
                this.color = this.noiseColor = Color.valueOf("7457ce");
                this.particleRegion = "circle-small";
                this.drawNoise = true;
                this.statusGround = false;
                this.useWindVector = true;
                this.sizeMax = 5.0f;
                this.sizeMin = 2.5f;
                this.minAlpha = 0.1f;
                this.maxAlpha = 0.8f;
                this.density = 2000.0f;
                this.baseSpeed = 4.3f;
                this.attrs.set(Attribute.spores, 1.0f);
                this.attrs.set(Attribute.light, -0.15f);
                this.status = StatusEffects.sporeSlowed;
                this.opacityMultiplier = 0.5f;
                this.force = 0.1f;
                this.sound = Sounds.wind;
                this.soundVol = 0.7f;
                this.duration = 25200.0f;
            }
        };
        fog = new ParticleWeather("fog"){
            {
                this.duration = 54000.0f;
                this.noiseLayers = 3;
                this.noiseLayerSclM = 0.8f;
                this.noiseLayerAlphaM = 0.7f;
                this.noiseLayerSpeedM = 2.0f;
                this.noiseLayerSclM = 0.6f;
                this.baseSpeed = 0.05f;
                this.color = this.noiseColor = Color.grays(0.4f);
                this.noiseScale = 1100.0f;
                this.noisePath = "fog";
                this.drawParticles = false;
                this.drawNoise = true;
                this.useWindVector = false;
                this.xspeed = 1.0f;
                this.yspeed = 0.01f;
                this.attrs.set(Attribute.light, -0.3f);
                this.attrs.set(Attribute.water, 0.05f);
                this.opacityMultiplier = 0.47f;
            }
        };
        suspendParticles = new ParticleWeather("suspend-particles"){
            {
                this.color = this.noiseColor = Color.valueOf("a7c1fa");
                this.particleRegion = "particle";
                this.statusGround = false;
                this.useWindVector = true;
                this.hidden = true;
                this.sizeMax = 4.0f;
                this.sizeMin = 1.4f;
                this.minAlpha = 0.5f;
                this.maxAlpha = 1.0f;
                this.density = 10000.0f;
                this.baseSpeed = 0.03f;
            }
        };
    }
}

