/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai.types;

import arc.func.Boolf;
import arc.func.Cons;
import arc.util.Nullable;
import arc.util.Time;
import java.lang.invoke.LambdaMetafactory;
import mindustry.Vars;
import mindustry.ai.types.CommandAI;
import mindustry.ai.types.FlyingAI;
import mindustry.ai.types.GroundAI;
import mindustry.ai.types.PrebuildAI;
import mindustry.entities.Units;
import mindustry.entities.units.AIController;
import mindustry.entities.units.BuildPlan;
import mindustry.entities.units.UnitController;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.Groups;
import mindustry.gen.Player;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.world.Build;
import mindustry.world.blocks.ConstructBlock;

public class BuilderAI
extends AIController {
    public static float buildRadius = 1500.0f;
    public static float retreatDst = 110.0f;
    public static float retreatDelay = 120.0f;
    public static float defaultRebuildPeriod = 120.0f;
    @Nullable
    public Unit assistFollowing;
    @Nullable
    public Unit following;
    @Nullable
    public Teamc enemy;
    @Nullable
    public Teams.BlockPlan lastPlan;
    public float fleeRange = 370.0f;
    public float rebuildPeriod = defaultRebuildPeriod;
    public boolean alwaysFlee;
    public boolean onlyAssist;
    boolean found = false;
    float retreatTimer;

    public BuilderAI(boolean alwaysFlee, float fleeRange) {
        this.alwaysFlee = alwaysFlee;
        this.fleeRange = fleeRange;
    }

    public BuilderAI() {
    }

    @Override
    public void init() {
        if (this.rebuildPeriod == defaultRebuildPeriod && this.unit.team.rules().buildAi) {
            this.rebuildPeriod = 10.0f;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void updateMovement() {
        block32: {
            block30: {
                block31: {
                    if (this.target != null && this.shouldShoot()) {
                        this.unit.lookAt(this.target);
                    } else if (!this.unit.type.flying) {
                        this.unit.lookAt(this.unit.prefRotation());
                    }
                    this.unit.updateBuilding = true;
                    if (this.assistFollowing != null && !this.assistFollowing.isValid()) {
                        this.assistFollowing = null;
                    }
                    if (this.following != null && !this.following.isValid()) {
                        this.following = null;
                    }
                    if (this.assistFollowing != null && this.assistFollowing.activelyBuilding()) {
                        this.following = this.assistFollowing;
                    }
                    moving = false;
                    if (this.following != null) {
                        this.retreatTimer = 0.0f;
                        if (!this.following.isValid() || !this.following.activelyBuilding()) {
                            this.following = null;
                            this.unit.plans.clear();
                            return;
                        }
                        this.unit.plans.clear();
                        this.unit.plans.addFirst(this.following.buildPlan());
                        this.lastPlan = null;
                    } else if (this.unit.buildPlan() == null || this.alwaysFlee) {
                        if (this.timer.get(3, 40.0f)) {
                            this.enemy = this.target(this.unit.x, this.unit.y, this.fleeRange, true, true);
                        }
                        if (((this.retreatTimer += Time.delta) >= BuilderAI.retreatDelay || this.alwaysFlee) && this.enemy != null) {
                            this.unit.clearBuilding();
                            core = this.unit.closestCore();
                            if (core != null && !this.unit.within(core, BuilderAI.retreatDst)) {
                                this.moveTo(core, BuilderAI.retreatDst);
                                moving = true;
                            }
                        }
                    }
                    if (this.unit.buildPlan() == null) break block30;
                    if (!this.alwaysFlee) {
                        this.retreatTimer = 0.0f;
                    }
                    req = this.unit.buildPlan();
                    if (!req.breaking && this.timer.get(1, 40.0f)) {
                        for (Player player : Groups.player) {
                            if (!player.isBuilder() || !player.unit().activelyBuilding() || !player.unit().buildPlan().samePos(req) || !player.unit().buildPlan().breaking) continue;
                            this.unit.plans.removeFirst();
                            this.unit.team.data().plans.remove((Teams.BlockPlan)(Boolf<Teams.BlockPlan>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$updateMovement$0(mindustry.entities.units.BuildPlan mindustry.game.Teams$BlockPlan ), (Lmindustry/game/Teams$BlockPlan;)Z)((BuildPlan)req));
                            return;
                        }
                    }
                    if (this.lastPlan != null && this.lastPlan.removed) ** GOTO lbl-1000
                    if (req.tile() == null || !((var5_10 = req.tile().build) instanceof ConstructBlock.ConstructBuild)) break block31;
                    cons = (ConstructBlock.ConstructBuild)var5_10;
                    if (cons.current == req.block) ** GOTO lbl-1000
                }
                if (req.breaking != false ? Build.validBreak(this.unit.team(), req.x, req.y) != false : Build.validPlace(req.block, this.unit.team(), req.x, req.y, req.rotation) != false) lbl-1000:
                // 2 sources

                {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = valid = false;
                }
                if (valid) {
                    range = Math.min(this.unit.type.buildRange - 20.0f, 100.0f);
                    this.moveTo(req.tile(), range - 10.0f, 20.0f);
                    moving = this.unit.within(req.tile(), range) == false;
                } else {
                    this.unit.plans.removeFirst();
                    this.lastPlan = null;
                }
                break block32;
            }
            if (this.assistFollowing != null) {
                this.moveTo(this.assistFollowing, this.assistFollowing.type.hitSize + this.unit.type.hitSize / 2.0f + 60.0f);
                v1 = moving = this.unit.within(this.assistFollowing, this.assistFollowing.type.hitSize + this.unit.type.hitSize / 2.0f + 65.0f) == false;
            }
            if (this.timer.get(1, 20.0f)) {
                this.found = false;
                Units.nearby(this.unit.team, this.unit.x, this.unit.y, BuilderAI.buildRadius, (Cons<Unit>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$updateMovement$1(mindustry.gen.Unit ), (Lmindustry/gen/Unit;)V)((BuilderAI)this));
                if (this.onlyAssist) {
                    minDst = 3.4028235E38f;
                    closest = null;
                    for (Player player : Groups.player) {
                        if (player.dead() || !player.isBuilder() || player.team() != this.unit.team || !((dst = player.dst2(this.unit)) < minDst)) continue;
                        closest = player;
                        minDst = dst;
                    }
                    v2 = this.assistFollowing = closest == null ? null : closest.unit();
                }
            }
            if (!this.onlyAssist && !this.unit.team.data().plans.isEmpty() && this.following == null && this.timer.get(2, this.rebuildPeriod)) {
                blocks = this.unit.team.data().plans;
                block = blocks.first();
                if (Vars.world.tile(block.x, block.y) != null && Vars.world.tile(block.x, block.y).block() == block.block) {
                    blocks.removeFirst();
                } else if (!(!Build.validPlace(block.block, this.unit.team(), block.x, block.y, block.rotation) || this.alwaysFlee && this.nearEnemy(block.x, block.y))) {
                    this.lastPlan = block;
                    this.unit.addBuild(new BuildPlan(block.x, block.y, block.rotation, block.block, block.config));
                    blocks.addLast(blocks.removeFirst());
                } else {
                    blocks.addLast(blocks.removeFirst());
                }
            }
        }
        if (!this.unit.type.flying) {
            this.unit.updateBoosting(this.unit.type.boostWhenBuilding != false || moving != false || this.unit.floorOn().isDuct != false || this.unit.floorOn().damageTaken > 0.0f || this.unit.floorOn().isDeep() != false);
        }
    }

    protected boolean nearEnemy(int x, int y) {
        return Units.nearEnemy(this.unit.team, (float)(x * 8) - this.fleeRange / 2.0f, (float)(y * 8) - this.fleeRange / 2.0f, this.fleeRange, this.fleeRange);
    }

    @Override
    public AIController fallback() {
        if (this.unit.team.isAI() && this.unit.team.rules().prebuildAi) {
            return new PrebuildAI();
        }
        return this.unit.type.flying ? new FlyingAI() : new GroundAI();
    }

    @Override
    public boolean useFallback() {
        if (this.unit.team.isAI() && this.unit.team.rules().prebuildAi) {
            return true;
        }
        return Vars.state.rules.waves && this.unit.team == Vars.state.rules.waveTeam && !this.unit.team.rules().rtsAi;
    }

    @Override
    public boolean shouldFire() {
        CommandAI ai;
        UnitController unitController = this.unit.controller();
        return !(unitController instanceof CommandAI) || (ai = (CommandAI)unitController).shouldFire();
    }

    @Override
    public boolean shouldShoot() {
        return !this.unit.isBuilding() && this.unit.type.canAttack;
    }

    private /* synthetic */ void lambda$updateMovement$1(Unit u) {
        if (this.found) {
            return;
        }
        if (u.canBuild() && u != this.unit && u.activelyBuilding()) {
            ConstructBlock.ConstructBuild cons;
            float dist;
            BuildPlan plan = u.buildPlan();
            Building build = Vars.world.build(plan.x, plan.y);
            if (build instanceof ConstructBlock.ConstructBuild && (dist = Math.min((cons = (ConstructBlock.ConstructBuild)build).dst(this.unit) - this.unit.type.buildRange, 0.0f)) / this.unit.speed() < cons.buildCost * 0.9f) {
                this.following = u;
                this.found = true;
            }
        }
    }

    private static /* synthetic */ boolean lambda$updateMovement$0(BuildPlan req, Teams.BlockPlan p) {
        return p.x == req.x && p.y == req.y;
    }
}

