/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai;

import arc.Core;
import arc.input.KeyBind;
import arc.scene.style.TextureRegionDrawable;
import arc.struct.Bits;
import arc.struct.Seq;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.ai.ItemUnitStance;
import mindustry.ctype.ContentType;
import mindustry.ctype.MappableContent;
import mindustry.gen.Icon;
import mindustry.gen.Iconc;
import mindustry.input.Binding;
import mindustry.type.Item;

public class UnitStance
extends MappableContent {
    public static UnitStance stop;
    public static UnitStance holdFire;
    public static UnitStance pursueTarget;
    public static UnitStance patrol;
    public static UnitStance ram;
    public static UnitStance mineAuto;
    public String icon;
    @Nullable
    public KeyBind keybind;
    public Seq<UnitStance> incompatibleStances = new Seq();
    public Bits incompatibleBits = new Bits(32);
    public boolean toggle = true;

    public UnitStance(String name, String icon, KeyBind keybind, boolean toggle) {
        super(name);
        this.icon = icon;
        this.keybind = keybind;
        this.toggle = toggle;
    }

    public UnitStance(String name, String icon, KeyBind keybind) {
        this(name, icon, keybind, true);
    }

    @Override
    public void init() {
        super.init();
        for (UnitStance stance : this.incompatibleStances) {
            if (stance == this) continue;
            this.incompatibleBits.set(stance.id);
            stance.incompatibleBits.set(this.id);
        }
    }

    public String localized() {
        return Core.bundle.get("stance." + this.name);
    }

    public TextureRegionDrawable getIcon() {
        return Icon.icons.get(this.icon, Icon.cancel);
    }

    public char getEmoji() {
        return (char)Iconc.codes.get(this.icon, 59413);
    }

    @Override
    public ContentType getContentType() {
        return ContentType.unitStance;
    }

    @Override
    public String toString() {
        return "UnitStance:" + this.name;
    }

    public static void loadAll() {
        stop = new UnitStance("stop", "cancel", Binding.cancelOrders, false);
        holdFire = new UnitStance("holdfire", "none", Binding.unitStanceHoldFire);
        pursueTarget = new UnitStance("pursuetarget", "right", Binding.unitStancePursueTarget);
        patrol = new UnitStance("patrol", "refresh", Binding.unitStancePatrol);
        ram = new UnitStance("ram", "rightOpen", Binding.unitStanceRam);
        mineAuto = new UnitStance("mineauto", "settings", null, false);
        for (Item item : Vars.content.items()) {
            new ItemUnitStance(item);
        }
    }
}

