/*
 * Decompiled with CFR 0.152.
 */
package arc.scene.actions;

import arc.func.Prov;
import arc.graphics.Color;
import arc.math.Interp;
import arc.scene.Action;
import arc.scene.Element;
import arc.scene.actions.AddAction;
import arc.scene.actions.AddListenerAction;
import arc.scene.actions.AfterAction;
import arc.scene.actions.AlphaAction;
import arc.scene.actions.ColorAction;
import arc.scene.actions.DelayAction;
import arc.scene.actions.LayoutAction;
import arc.scene.actions.MoveByAction;
import arc.scene.actions.MoveToAction;
import arc.scene.actions.OriginAction;
import arc.scene.actions.ParallelAction;
import arc.scene.actions.RemoveAction;
import arc.scene.actions.RemoveActorAction;
import arc.scene.actions.RemoveListenerAction;
import arc.scene.actions.RepeatAction;
import arc.scene.actions.RotateByAction;
import arc.scene.actions.RotateToAction;
import arc.scene.actions.RunnableAction;
import arc.scene.actions.ScaleByAction;
import arc.scene.actions.ScaleToAction;
import arc.scene.actions.SequenceAction;
import arc.scene.actions.SizeByAction;
import arc.scene.actions.SizeToAction;
import arc.scene.actions.TimeScaleAction;
import arc.scene.actions.TouchableAction;
import arc.scene.actions.TranslateByAction;
import arc.scene.actions.VisibleAction;
import arc.scene.event.EventListener;
import arc.scene.event.Touchable;
import arc.util.pooling.Pools;

public class Actions {
    public static <T extends Action> T action(Class<T> type, Prov<T> sup) {
        Action action = (Action)Pools.obtain(type, sup);
        action.setPool(Pools.get(type, sup));
        return (T)action;
    }

    public static AddAction addAction(Action action) {
        AddAction addAction = Actions.action(AddAction.class, AddAction::new);
        addAction.setAction(action);
        return addAction;
    }

    public static AddAction addAction(Action action, Element targetActor) {
        AddAction addAction = Actions.action(AddAction.class, AddAction::new);
        addAction.setTarget(targetActor);
        addAction.setAction(action);
        return addAction;
    }

    public static RemoveAction removeAction(Action action) {
        RemoveAction removeAction = Actions.action(RemoveAction.class, RemoveAction::new);
        removeAction.setAction(action);
        return removeAction;
    }

    public static RemoveAction removeAction(Action action, Element targetActor) {
        RemoveAction removeAction = Actions.action(RemoveAction.class, RemoveAction::new);
        removeAction.setTarget(targetActor);
        removeAction.setAction(action);
        return removeAction;
    }

    public static Action originCenter() {
        return new OriginAction();
    }

    public static MoveToAction moveTo(float x, float y) {
        return Actions.moveTo(x, y, 0.0f, null);
    }

    public static MoveToAction moveTo(float x, float y, float duration) {
        return Actions.moveTo(x, y, duration, null);
    }

    public static MoveToAction moveTo(float x, float y, float duration, Interp interpolation) {
        MoveToAction action = Actions.action(MoveToAction.class, MoveToAction::new);
        action.setPosition(x, y);
        action.setDuration(duration);
        action.setInterpolation(interpolation);
        return action;
    }

    public static MoveToAction moveToAligned(float x, float y, int alignment) {
        return Actions.moveToAligned(x, y, alignment, 0.0f, null);
    }

    public static MoveToAction moveToAligned(float x, float y, int alignment, float duration) {
        return Actions.moveToAligned(x, y, alignment, duration, null);
    }

    public static MoveToAction moveToAligned(float x, float y, int alignment, float duration, Interp interpolation) {
        MoveToAction action = Actions.action(MoveToAction.class, MoveToAction::new);
        action.setPosition(x, y, alignment);
        action.setDuration(duration);
        action.setInterpolation(interpolation);
        return action;
    }

    public static MoveByAction moveBy(float amountX, float amountY) {
        return Actions.moveBy(amountX, amountY, 0.0f, null);
    }

    public static MoveByAction moveBy(float amountX, float amountY, float duration) {
        return Actions.moveBy(amountX, amountY, duration, null);
    }

    public static RunnableAction translateTo(float amountX, float amountY) {
        RunnableAction action = Actions.action(RunnableAction.class, RunnableAction::new);
        action.setRunnable(() -> action.getActor().setTranslation(amountX, amountY));
        return action;
    }

    public static TranslateByAction translateBy(float amountX, float amountY, float duration, Interp interpolation) {
        TranslateByAction action = Actions.action(TranslateByAction.class, TranslateByAction::new);
        action.setAmount(amountX, amountY);
        action.setDuration(duration);
        action.setInterpolation(interpolation);
        return action;
    }

    public static TranslateByAction translateBy(float amountX, float amountY) {
        return Actions.translateBy(amountX, amountY, 0.0f, null);
    }

    public static TranslateByAction translateBy(float amountX, float amountY, float duration) {
        return Actions.translateBy(amountX, amountY, duration, null);
    }

    public static MoveByAction moveBy(float amountX, float amountY, float duration, Interp interpolation) {
        MoveByAction action = Actions.action(MoveByAction.class, MoveByAction::new);
        action.setAmount(amountX, amountY);
        action.setDuration(duration);
        action.setInterpolation(interpolation);
        return action;
    }

    public static SizeToAction sizeTo(float x, float y) {
        return Actions.sizeTo(x, y, 0.0f, null);
    }

    public static SizeToAction sizeTo(float x, float y, float duration) {
        return Actions.sizeTo(x, y, duration, null);
    }

    public static SizeToAction sizeTo(float x, float y, float duration, Interp interpolation) {
        SizeToAction action = Actions.action(SizeToAction.class, SizeToAction::new);
        action.setSize(x, y);
        action.setDuration(duration);
        action.setInterpolation(interpolation);
        return action;
    }

    public static SizeByAction sizeBy(float amountX, float amountY) {
        return Actions.sizeBy(amountX, amountY, 0.0f, null);
    }

    public static SizeByAction sizeBy(float amountX, float amountY, float duration) {
        return Actions.sizeBy(amountX, amountY, duration, null);
    }

    public static SizeByAction sizeBy(float amountX, float amountY, float duration, Interp interpolation) {
        SizeByAction action = Actions.action(SizeByAction.class, SizeByAction::new);
        action.setAmount(amountX, amountY);
        action.setDuration(duration);
        action.setInterpolation(interpolation);
        return action;
    }

    public static ScaleToAction scaleTo(float x, float y) {
        return Actions.scaleTo(x, y, 0.0f, null);
    }

    public static ScaleToAction scaleTo(float x, float y, float duration) {
        return Actions.scaleTo(x, y, duration, null);
    }

    public static ScaleToAction scaleTo(float x, float y, float duration, Interp interpolation) {
        ScaleToAction action = Actions.action(ScaleToAction.class, ScaleToAction::new);
        action.setScale(x, y);
        action.setDuration(duration);
        action.setInterpolation(interpolation);
        return action;
    }

    public static ScaleByAction scaleBy(float amountX, float amountY) {
        return Actions.scaleBy(amountX, amountY, 0.0f, null);
    }

    public static ScaleByAction scaleBy(float amountX, float amountY, float duration) {
        return Actions.scaleBy(amountX, amountY, duration, null);
    }

    public static ScaleByAction scaleBy(float amountX, float amountY, float duration, Interp interpolation) {
        ScaleByAction action = Actions.action(ScaleByAction.class, ScaleByAction::new);
        action.setAmount(amountX, amountY);
        action.setDuration(duration);
        action.setInterpolation(interpolation);
        return action;
    }

    public static RotateToAction rotateTo(float rotation) {
        return Actions.rotateTo(rotation, 0.0f, null);
    }

    public static RotateToAction rotateTo(float rotation, float duration) {
        return Actions.rotateTo(rotation, duration, null);
    }

    public static RotateToAction rotateTo(float rotation, float duration, Interp interpolation) {
        RotateToAction action = Actions.action(RotateToAction.class, RotateToAction::new);
        action.setRotation(rotation);
        action.setDuration(duration);
        action.setInterpolation(interpolation);
        return action;
    }

    public static RotateByAction rotateBy(float rotationAmount) {
        return Actions.rotateBy(rotationAmount, 0.0f, null);
    }

    public static RotateByAction rotateBy(float rotationAmount, float duration) {
        return Actions.rotateBy(rotationAmount, duration, null);
    }

    public static RotateByAction rotateBy(float rotationAmount, float duration, Interp interpolation) {
        RotateByAction action = Actions.action(RotateByAction.class, RotateByAction::new);
        action.setAmount(rotationAmount);
        action.setDuration(duration);
        action.setInterpolation(interpolation);
        return action;
    }

    public static ColorAction color(Color color) {
        return Actions.color(color, 0.0f, null);
    }

    public static ColorAction color(Color color, float duration) {
        return Actions.color(color, duration, null);
    }

    public static ColorAction color(Color color, float duration, Interp interpolation) {
        ColorAction action = Actions.action(ColorAction.class, ColorAction::new);
        action.setEndColor(color);
        action.setDuration(duration);
        action.setInterpolation(interpolation);
        return action;
    }

    public static AlphaAction alpha(float a) {
        return Actions.alpha(a, 0.0f, null);
    }

    public static AlphaAction alpha(float a, float duration) {
        return Actions.alpha(a, duration, null);
    }

    public static AlphaAction alpha(float a, float duration, Interp interpolation) {
        AlphaAction action = Actions.action(AlphaAction.class, AlphaAction::new);
        action.setAlpha(a);
        action.setDuration(duration);
        action.setInterpolation(interpolation);
        return action;
    }

    public static AlphaAction fadeOut(float duration) {
        return Actions.alpha(0.0f, duration, null);
    }

    public static AlphaAction fadeOut(float duration, Interp interpolation) {
        AlphaAction action = Actions.action(AlphaAction.class, AlphaAction::new);
        action.setAlpha(0.0f);
        action.setDuration(duration);
        action.setInterpolation(interpolation);
        return action;
    }

    public static AlphaAction fadeIn(float duration) {
        return Actions.alpha(1.0f, duration, null);
    }

    public static AlphaAction fadeIn(float duration, Interp interpolation) {
        AlphaAction action = Actions.action(AlphaAction.class, AlphaAction::new);
        action.setAlpha(1.0f);
        action.setDuration(duration);
        action.setInterpolation(interpolation);
        return action;
    }

    public static VisibleAction show() {
        return Actions.visible(true);
    }

    public static VisibleAction hide() {
        return Actions.visible(false);
    }

    public static VisibleAction visible(boolean visible) {
        VisibleAction action = Actions.action(VisibleAction.class, VisibleAction::new);
        action.setVisible(visible);
        return action;
    }

    public static TouchableAction touchable(Touchable touchable) {
        TouchableAction action = Actions.action(TouchableAction.class, TouchableAction::new);
        action.touchable(touchable);
        return action;
    }

    public static RemoveActorAction remove() {
        return Actions.action(RemoveActorAction.class, RemoveActorAction::new);
    }

    public static RemoveActorAction remove(Element removeActor) {
        RemoveActorAction action = Actions.action(RemoveActorAction.class, RemoveActorAction::new);
        action.setTarget(removeActor);
        return action;
    }

    public static DelayAction delay(float duration) {
        DelayAction action = Actions.action(DelayAction.class, DelayAction::new);
        action.setDuration(duration);
        return action;
    }

    public static DelayAction delay(float duration, Action delayedAction) {
        DelayAction action = Actions.action(DelayAction.class, DelayAction::new);
        action.setDuration(duration);
        action.setAction(delayedAction);
        return action;
    }

    public static TimeScaleAction timeScale(float scale, Action scaledAction) {
        TimeScaleAction action = Actions.action(TimeScaleAction.class, TimeScaleAction::new);
        action.setScale(scale);
        action.setAction(scaledAction);
        return action;
    }

    public static SequenceAction sequence(Action action1) {
        SequenceAction action = Actions.action(SequenceAction.class, SequenceAction::new);
        action.addAction(action1);
        return action;
    }

    public static SequenceAction sequence(Action action1, Action action2) {
        SequenceAction action = Actions.action(SequenceAction.class, SequenceAction::new);
        action.addAction(action1);
        action.addAction(action2);
        return action;
    }

    public static SequenceAction sequence(Action action1, Action action2, Action action3) {
        SequenceAction action = Actions.action(SequenceAction.class, SequenceAction::new);
        action.addAction(action1);
        action.addAction(action2);
        action.addAction(action3);
        return action;
    }

    public static SequenceAction sequence(Action action1, Action action2, Action action3, Action action4) {
        SequenceAction action = Actions.action(SequenceAction.class, SequenceAction::new);
        action.addAction(action1);
        action.addAction(action2);
        action.addAction(action3);
        action.addAction(action4);
        return action;
    }

    public static SequenceAction sequence(Action action1, Action action2, Action action3, Action action4, Action action5) {
        SequenceAction action = Actions.action(SequenceAction.class, SequenceAction::new);
        action.addAction(action1);
        action.addAction(action2);
        action.addAction(action3);
        action.addAction(action4);
        action.addAction(action5);
        return action;
    }

    public static SequenceAction sequence(Action ... actions) {
        SequenceAction action = Actions.action(SequenceAction.class, SequenceAction::new);
        int n = actions.length;
        for (int i = 0; i < n; ++i) {
            action.addAction(actions[i]);
        }
        return action;
    }

    public static SequenceAction sequence() {
        return Actions.action(SequenceAction.class, SequenceAction::new);
    }

    public static ParallelAction parallel(Action action1) {
        ParallelAction action = Actions.action(ParallelAction.class, ParallelAction::new);
        action.addAction(action1);
        return action;
    }

    public static ParallelAction parallel(Action action1, Action action2) {
        ParallelAction action = Actions.action(ParallelAction.class, ParallelAction::new);
        action.addAction(action1);
        action.addAction(action2);
        return action;
    }

    public static ParallelAction parallel(Action action1, Action action2, Action action3) {
        ParallelAction action = Actions.action(ParallelAction.class, ParallelAction::new);
        action.addAction(action1);
        action.addAction(action2);
        action.addAction(action3);
        return action;
    }

    public static ParallelAction parallel(Action action1, Action action2, Action action3, Action action4) {
        ParallelAction action = Actions.action(ParallelAction.class, ParallelAction::new);
        action.addAction(action1);
        action.addAction(action2);
        action.addAction(action3);
        action.addAction(action4);
        return action;
    }

    public static ParallelAction parallel(Action action1, Action action2, Action action3, Action action4, Action action5) {
        ParallelAction action = Actions.action(ParallelAction.class, ParallelAction::new);
        action.addAction(action1);
        action.addAction(action2);
        action.addAction(action3);
        action.addAction(action4);
        action.addAction(action5);
        return action;
    }

    public static ParallelAction parallel(Action ... actions) {
        ParallelAction action = Actions.action(ParallelAction.class, ParallelAction::new);
        int n = actions.length;
        for (int i = 0; i < n; ++i) {
            action.addAction(actions[i]);
        }
        return action;
    }

    public static ParallelAction parallel() {
        return Actions.action(ParallelAction.class, ParallelAction::new);
    }

    public static RepeatAction repeat(int count, Action repeatedAction) {
        RepeatAction action = Actions.action(RepeatAction.class, RepeatAction::new);
        action.setCount(count);
        action.setAction(repeatedAction);
        return action;
    }

    public static RepeatAction forever(Action repeatedAction) {
        RepeatAction action = Actions.action(RepeatAction.class, RepeatAction::new);
        action.setCount(-1);
        action.setAction(repeatedAction);
        return action;
    }

    public static RunnableAction run(Runnable runnable) {
        RunnableAction action = Actions.action(RunnableAction.class, RunnableAction::new);
        action.setRunnable(runnable);
        return action;
    }

    public static LayoutAction layout(boolean enabled) {
        LayoutAction action = Actions.action(LayoutAction.class, LayoutAction::new);
        action.setLayoutEnabled(enabled);
        return action;
    }

    public static AfterAction after(Action action) {
        AfterAction afterAction = Actions.action(AfterAction.class, AfterAction::new);
        afterAction.setAction(action);
        return afterAction;
    }

    public static AddListenerAction addListener(EventListener listener, boolean capture) {
        AddListenerAction addAction = Actions.action(AddListenerAction.class, AddListenerAction::new);
        addAction.setListener(listener);
        addAction.setCapture(capture);
        return addAction;
    }

    public static AddListenerAction addListener(EventListener listener, boolean capture, Element targetActor) {
        AddListenerAction addAction = Actions.action(AddListenerAction.class, AddListenerAction::new);
        addAction.setTarget(targetActor);
        addAction.setListener(listener);
        addAction.setCapture(capture);
        return addAction;
    }

    public static RemoveListenerAction removeListener(EventListener listener, boolean capture) {
        RemoveListenerAction addAction = Actions.action(RemoveListenerAction.class, RemoveListenerAction::new);
        addAction.setListener(listener);
        addAction.setCapture(capture);
        return addAction;
    }

    public static RemoveListenerAction removeListener(EventListener listener, boolean capture, Element targetActor) {
        RemoveListenerAction addAction = Actions.action(RemoveListenerAction.class, RemoveListenerAction::new);
        addAction.setTarget(targetActor);
        addAction.setListener(listener);
        addAction.setCapture(capture);
        return addAction;
    }
}

