/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.g3d;

import arc.graphics.Gl;
import arc.graphics.Texture;
import arc.graphics.g2d.Batch;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.g3d.VertexBatch3D;
import arc.math.Mathf;
import arc.math.geom.Mat3D;
import arc.math.geom.Vec3;

public class PlaneBatch3D
extends Batch {
    protected final Vec3 up = new Vec3();
    protected final Vec3 right = new Vec3();
    protected final Vec3 origin = new Vec3();
    protected final Vec3 vec = new Vec3();
    protected final VertexBatch3D batch;
    protected final float[] vertex = new float[6];
    protected float scaling = 1.0f;

    public PlaneBatch3D() {
        this(5000);
    }

    public PlaneBatch3D(int vertices) {
        this.batch = new VertexBatch3D(vertices, false, true, 1);
    }

    public void setScaling(float scaling) {
        this.scaling = scaling;
    }

    public void setPlane(Vec3 origin, Vec3 up, Vec3 right) {
        this.origin.set(origin);
        this.up.set(up).nor();
        this.right.set(right).nor();
    }

    public void proj(Mat3D mat) {
        this.batch.proj(mat);
    }

    @Override
    protected void flush() {
        if (this.lastTexture == null || this.idx == 0) {
            return;
        }
        Gl.depthMask(false);
        this.lastTexture.bind();
        this.batch.flush(4);
        this.idx = 0;
        Gl.depthMask(true);
    }

    @Override
    protected void draw(TextureRegion region, float x, float y, float originX, float originY, float width, float height, float rotation) {
        Texture texture = region.texture;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        }
        this.checkFlush();
        float worldOriginX = x + originX;
        float worldOriginY = y + originY;
        float fx = -originX;
        float fy = -originY;
        float fx2 = width - originX;
        float fy2 = height - originY;
        float cos = Mathf.cosDeg(rotation);
        float sin = Mathf.sinDeg(rotation);
        float x1 = cos * fx - sin * fy;
        float y1 = sin * fx + cos * fy;
        float x2 = cos * fx - sin * fy2;
        float y2 = sin * fx + cos * fy2;
        float x3 = cos * fx2 - sin * fy2;
        float y3 = sin * fx2 + cos * fy2;
        float x4 = x1 + (x3 - x2);
        float y4 = y3 - (y2 - y1);
        x1 += worldOriginX;
        y1 += worldOriginY;
        x2 += worldOriginX;
        y2 += worldOriginY;
        x3 += worldOriginX;
        y3 += worldOriginY;
        x4 += worldOriginX;
        y4 += worldOriginY;
        float u = region.u;
        float v = region.v2;
        float u2 = region.u2;
        float v2 = region.v;
        float color = this.colorPacked;
        this.vertex(x2, y2, color, u, v2);
        this.vertex(x1, y1, color, u, v);
        this.vertex(x3, y3, color, u2, v2);
        this.vertex(x4, y4, color, u2, v);
        this.vertex(x3, y3, color, u2, v2);
        this.vertex(x1, y1, color, u, v);
        ++this.idx;
    }

    @Override
    protected void draw(Texture texture, float[] v, int offset, int count) {
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        }
        for (int i = offset; i < count; i += 24) {
            this.checkFlush();
            this.vertex(v[i], v[i + 1], v[i + 2], v[i + 3], v[i + 4]);
            this.vertex(v[i + 12], v[i + 13], v[i + 14], v[i + 15], v[i + 16]);
            this.vertex(v[i + 6], v[i + 7], v[i + 8], v[i + 9], v[i + 10]);
            this.vertex(v[i + 12], v[i + 13], v[i + 14], v[i + 15], v[i + 16]);
            this.vertex(v[i], v[i + 1], v[i + 2], v[i + 3], v[i + 4]);
            this.vertex(v[i + 18], v[i + 19], v[i + 20], v[i + 21], v[i + 22]);
            ++this.idx;
        }
    }

    private void checkFlush() {
        if (this.idx >= this.batch.getMaxVertices() / 6 / 6) {
            this.flush();
        }
    }

    private void vertex(float x1, float y1, float c1, float u1, float v1) {
        this.vec.set(this.origin).add(this.right, x1 * this.scaling).add(this.up, y1 * this.scaling);
        this.vertex[0] = this.vec.x;
        this.vertex[1] = this.vec.y;
        this.vertex[2] = this.vec.z;
        this.vertex[3] = c1;
        this.vertex[4] = u1;
        this.vertex[5] = v1;
        this.batch.vertex(this.vertex);
    }
}

