/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.g2d;

import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.Shader;
import arc.math.Mat;
import arc.util.Disposable;

public abstract class Batch
implements Disposable {
    protected float z;
    protected int idx = 0;
    protected Texture lastTexture = null;
    protected boolean apply;
    protected final Mat transformMatrix = new Mat();
    protected final Mat projectionMatrix = new Mat();
    protected final Mat combinedMatrix = new Mat();
    protected Blending blending = Blending.normal;
    protected Shader shader;
    protected Shader customShader = null;
    protected boolean ownsShader;
    protected float colorPacked = Color.whiteFloatBits;
    protected float mixColorPacked = Color.clearFloatBits;

    protected void z(float z) {
        this.z = z;
    }

    protected void setSort(boolean sort) {
    }

    protected void setPackedColor(float packedColor) {
        this.colorPacked = packedColor;
    }

    protected float getPackedColor() {
        return this.colorPacked;
    }

    protected void setPackedMixColor(float packedColor) {
        this.mixColorPacked = packedColor;
    }

    protected float getPackedMixColor() {
        return this.mixColorPacked;
    }

    protected abstract void draw(Texture var1, float[] var2, int var3, int var4);

    protected abstract void draw(TextureRegion var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8);

    protected void draw(Runnable request) {
        request.run();
    }

    protected abstract void flush();

    protected void discard() {
        this.idx = 0;
    }

    protected void setBlending(Blending blending) {
        if (this.blending != blending) {
            this.flush();
        }
        this.blending = blending;
    }

    protected Blending getBlending() {
        return this.blending;
    }

    @Override
    public void dispose() {
        if (this.ownsShader && this.shader != null) {
            this.shader.dispose();
        }
    }

    protected Mat getProjection() {
        return this.projectionMatrix;
    }

    protected Mat getTransform() {
        return this.transformMatrix;
    }

    protected void setProjection(Mat projection) {
        this.flush();
        this.projectionMatrix.set(projection);
    }

    protected void setTransform(Mat transform) {
        this.flush();
        this.transformMatrix.set(transform);
    }

    protected void setupMatrices() {
        this.combinedMatrix.set(this.projectionMatrix).mul(this.transformMatrix);
        this.getShader().setUniformMatrix4("u_projTrans", this.combinedMatrix);
    }

    protected void switchTexture(Texture texture) {
        this.flush();
        this.lastTexture = texture;
    }

    protected void setShader(Shader shader) {
        this.setShader(shader, true);
    }

    protected void setShader(Shader shader, boolean apply) {
        this.flush();
        this.customShader = shader;
        this.apply = apply;
    }

    protected Shader getShader() {
        return this.customShader == null ? this.shader : this.customShader;
    }
}

