/*
 * Decompiled with CFR 0.152.
 */
package arc.fx.util;

import arc.fx.FxProcessor;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.math.Mathf;
import arc.math.geom.Rect;
import arc.scene.Scene;
import arc.scene.ui.layout.WidgetGroup;
import arc.util.viewport.Viewport;

public class FxWidgetGroup
extends WidgetGroup {
    private final FxProcessor fxProcessor = new FxProcessor();
    private boolean initialized = false;
    private boolean resizePending = false;
    private boolean matchWidgetSize = false;

    public FxWidgetGroup() {
        super.setTransform(false);
    }

    public FxProcessor getFxProcessor() {
        return this.fxProcessor;
    }

    public boolean isMatchWidgetSize() {
        return this.matchWidgetSize;
    }

    public void setMatchWidgetSize(boolean matchWidgetSize) {
        if (this.matchWidgetSize == matchWidgetSize) {
            return;
        }
        this.matchWidgetSize = matchWidgetSize;
        this.resizePending = true;
    }

    @Override
    protected void setScene(Scene stage) {
        super.setScene(stage);
        if (stage != null) {
            this.initialize();
        } else {
            this.reset();
        }
    }

    @Override
    protected void sizeChanged() {
        super.sizeChanged();
        this.resizePending = true;
    }

    @Override
    public void draw() {
        Draw.flush();
        this.performPendingResize();
        this.fxProcessor.clear();
        this.fxProcessor.begin();
        this.validate();
        this.drawChildren();
        Draw.flush();
        this.fxProcessor.end();
        this.fxProcessor.applyEffects();
        if (this.fxProcessor.hasResult()) {
            Color color = this.color;
            Draw.color(color.r, color.g, color.b, color.a * this.parentAlpha);
            Draw.rect(Draw.wrap((Texture)this.fxProcessor.getResultBuffer().getTexture()), this.x + this.width / 2.0f, this.y + this.height / 2.0f, this.width, this.height);
        }
    }

    @Override
    protected void drawChildren() {
        boolean capturing = this.fxProcessor.isCapturing();
        if (capturing) {
            super.setTransform(true);
        }
        if (!capturing) {
            this.clipBegin();
        }
        super.drawChildren();
        Draw.flush();
        if (capturing) {
            super.setTransform(false);
        }
        if (!capturing) {
            this.clipEnd();
        }
    }

    @Override
    @Deprecated
    public void setCullingArea(Rect cullingArea) {
        throw new UnsupportedOperationException("VfxWidgetGroup doesn't support culling area.");
    }

    @Override
    @Deprecated
    public void setTransform(boolean transform) {
        throw new UnsupportedOperationException("VfxWidgetGroup doesn't support transform.");
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        this.performPendingResize();
        this.resizePending = false;
        this.initialized = true;
    }

    private void reset() {
        if (!this.initialized) {
            return;
        }
        this.fxProcessor.dispose();
        this.resizePending = false;
        this.initialized = false;
    }

    private void performPendingResize() {
        int height;
        int width;
        if (!this.resizePending) {
            return;
        }
        if ((int)this.getWidth() == 0 || (int)this.getHeight() == 0) {
            width = 16;
            height = 16;
        } else if (this.matchWidgetSize) {
            width = Mathf.floor(this.getWidth());
            height = Mathf.floor(this.getHeight());
        } else {
            Viewport viewport = this.getScene().getViewport();
            float ppu = (float)viewport.getScreenWidth() / viewport.getWorldWidth();
            width = Mathf.floor(this.getWidth() * ppu);
            height = Mathf.floor(this.getHeight() * ppu);
        }
        this.fxProcessor.resize(width, height);
        this.resizePending = false;
    }
}

