/*
 * Decompiled with CFR 0.152.
 */
package arc.fx.util;

import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.graphics.gl.FrameBuffer;
import arc.struct.Seq;
import arc.util.Disposable;

public class FxBufferQueue
implements Disposable {
    private final Seq<FrameBuffer> buffers;
    private int currentIdx = 0;
    private Texture.TextureWrap wrapU = Texture.TextureWrap.clampToEdge;
    private Texture.TextureWrap wrapV = Texture.TextureWrap.clampToEdge;
    private Texture.TextureFilter filterMin = Texture.TextureFilter.nearest;
    private Texture.TextureFilter filterMag = Texture.TextureFilter.nearest;

    public FxBufferQueue(Pixmap.Format pixelFormat, int fboAmount) {
        if (fboAmount < 1) {
            throw new IllegalArgumentException("FBO amount should be a positive number.");
        }
        this.buffers = new Seq(true, fboAmount);
        for (int i = 0; i < fboAmount; ++i) {
            this.buffers.add(new FrameBuffer(pixelFormat, 4, 4));
        }
    }

    @Override
    public void dispose() {
        for (int i = 0; i < this.buffers.size; ++i) {
            this.buffers.get(i).dispose();
        }
    }

    public void resize(int width, int height) {
        for (int i = 0; i < this.buffers.size; ++i) {
            this.buffers.get(i).resize(width, height);
        }
    }

    public void rebind() {
        for (int i = 0; i < this.buffers.size; ++i) {
            FrameBuffer wrapper = this.buffers.get(i);
            if (wrapper == null) continue;
            Texture texture = (Texture)wrapper.getTexture();
            texture.setWrap(this.wrapU, this.wrapV);
            texture.setFilter(this.filterMin, this.filterMag);
        }
    }

    public FrameBuffer getCurrent() {
        return this.buffers.get(this.currentIdx);
    }

    public FrameBuffer changeToNext() {
        this.currentIdx = (this.currentIdx + 1) % this.buffers.size;
        return this.getCurrent();
    }

    public void setTextureParams(Texture.TextureWrap u, Texture.TextureWrap v, Texture.TextureFilter min, Texture.TextureFilter mag) {
        this.wrapU = u;
        this.wrapV = v;
        this.filterMin = min;
        this.filterMag = mag;
        this.rebind();
    }
}

