/*
 * Decompiled with CFR 0.152.
 */
package arc.fx.filters;

import arc.fx.FxFilter;
import arc.fx.filters.CombineFilter;
import arc.fx.filters.GaussianBlurFilter;
import arc.fx.filters.ThresholdFilter;
import arc.fx.util.PingPongBuffer;
import arc.graphics.Blending;
import arc.graphics.Gl;
import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.graphics.gl.FrameBuffer;

public class BloomFilter
extends FxFilter {
    public final PingPongBuffer buffer;
    public final GaussianBlurFilter blur;
    public final ThresholdFilter threshold;
    public final CombineFilter combine;
    public Blending blending = Blending.normal;
    public int scaling = 4;

    public BloomFilter() {
        this.buffer = new PingPongBuffer(Pixmap.Format.rgba8888);
        this.blur = new GaussianBlurFilter();
        this.threshold = new ThresholdFilter();
        this.combine = new CombineFilter();
        this.blur.setPasses(2);
        this.blur.setAmount(10.0f);
        this.threshold.gamma = 0.0f;
        this.combine.src1int = 1.0f;
        this.combine.src1sat = 1.0f;
        this.combine.src2int = 2.0f;
        this.combine.src2sat = 2.0f;
        this.rebind();
    }

    @Override
    public void rebind() {
        this.threshold.rebind();
        this.combine.rebind();
        this.buffer.rebind();
    }

    @Override
    public void resize(int width, int height) {
        this.buffer.resize(width /= this.scaling, height /= this.scaling);
        this.blur.resize(width, height);
        this.threshold.resize(width, height);
        this.combine.resize(width, height);
    }

    @Override
    public void dispose() {
        this.combine.dispose();
        this.threshold.dispose();
        this.blur.dispose();
        this.buffer.dispose();
    }

    @Override
    public void render(FrameBuffer src, FrameBuffer dst) {
        Texture texSrc = (Texture)src.getTexture();
        Gl.disable(3042);
        this.buffer.begin();
        this.threshold.setInput(texSrc).setOutput(this.buffer.getDstBuffer()).render();
        this.buffer.swap();
        this.blur.render(this.buffer);
        this.buffer.end();
        if (this.blending != Blending.disabled) {
            this.blending.apply();
        }
        this.combine.setInput(texSrc, this.buffer.getDstTexture()).setOutput(dst).render();
    }
}

