/*
 * Decompiled with CFR 0.152.
 */
package arc.flabel.effects;

import arc.flabel.FEffect;
import arc.flabel.FGlyph;
import arc.flabel.FLabel;
import arc.util.noise.Simplex;

public class WindEffect
extends FEffect {
    private static final float defaultSpacing = 10.0f;
    private static final float defaultDistance = 0.33f;
    private static final float defaultIntensity = 0.375f;
    private static final float distanceXRatio = 1.5f;
    private static final float distanceYRatio = 1.0f;
    private float noiseCursorX = 0.0f;
    private float noiseCursorY = 0.0f;
    public float distanceX = 1.0f;
    public float distanceY = 1.0f;
    public float spacing = 1.0f;
    public float intensity = 1.0f;

    @Override
    public void update(float delta) {
        super.update(delta);
        this.noiseCursorX += 0.1f * this.intensity * 0.375f;
        this.noiseCursorY += 0.1f * this.intensity * 0.375f;
    }

    @Override
    protected void onApply(FLabel label, FGlyph glyph, int localIndex, float delta) {
        float progressModifier = 1.0f / this.intensity * 0.375f;
        float normalSpacing = 1.0f / this.spacing * 10.0f;
        float progressOffset = (float)localIndex / normalSpacing;
        float progress = this.calculateProgress(progressModifier, progressOffset);
        float indexOffset = (float)localIndex * 0.05f * this.spacing;
        float noiseX = Simplex.noise2d(1, 6.0, 0.0, 1.0, this.noiseCursorX + indexOffset, 0.0);
        float noiseY = Simplex.noise2d(1, 6.0, 0.0, 1.0, this.noiseCursorY + indexOffset, 0.0);
        float lineHeight = this.getLineHeight(label);
        float x = lineHeight * noiseX * progress * this.distanceX * 1.5f * 0.33f;
        float y = lineHeight * noiseY * progress * this.distanceY * 1.0f * 0.33f;
        float fadeout = this.calculateFadeout();
        x *= fadeout;
        x = Math.abs(x) * -Math.signum(this.distanceX);
        glyph.xoffset = (int)((float)glyph.xoffset + x);
        glyph.yoffset = (int)((float)glyph.yoffset + (y *= fadeout));
    }
}

