/*
 * Decompiled with CFR 0.152.
 */
package arc.flabel.effects;

import arc.flabel.FEffect;
import arc.flabel.FGlyph;
import arc.flabel.FLabel;
import arc.math.Interp;

public class WaveEffect
extends FEffect {
    private static final float defaultFrequency = 15.0f;
    private static final float defaultDistance = 0.33f;
    private static final float defaultIntensity = 0.5f;
    public float distance = 1.0f;
    public float frequency = 1.0f;
    public float intensity = 1.0f;

    @Override
    protected void onApply(FLabel label, FGlyph glyph, int localIndex, float delta) {
        float progressModifier = 1.0f / this.intensity * 0.5f;
        float normalFrequency = 1.0f / this.frequency * 15.0f;
        float progressOffset = (float)localIndex / normalFrequency;
        float progress = this.calculateProgress(progressModifier, progressOffset);
        float y = this.getLineHeight(label) * this.distance * Interp.sine.apply(-1.0f, 1.0f, progress) * 0.33f;
        float fadeout = this.calculateFadeout();
        glyph.yoffset = (int)((float)glyph.yoffset + (y *= fadeout));
    }
}

