/*
 * Decompiled with CFR 0.152.
 */
package arc;

import arc.ApplicationListener;
import arc.Core;
import arc.struct.Seq;
import arc.util.Disposable;
import arc.util.Nullable;
import arc.util.Time;
import java.net.InetSocketAddress;

public interface Application
extends Disposable {
    public Seq<ApplicationListener> getListeners();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void addListener(ApplicationListener listener) {
        Seq<ApplicationListener> seq = this.getListeners();
        synchronized (seq) {
            this.getListeners().add(listener);
        }
    }

    default public void removeListener(ApplicationListener listener) {
        this.post(() -> {
            Seq<ApplicationListener> seq = this.getListeners();
            synchronized (seq) {
                this.getListeners().remove(listener);
            }
        });
    }

    default public void defaultUpdate() {
        Core.settings.autosave();
        Time.updateGlobal();
    }

    public ApplicationType getType();

    default public boolean isDesktop() {
        return this.getType() == ApplicationType.desktop;
    }

    default public boolean isHeadless() {
        return this.getType() == ApplicationType.headless;
    }

    default public boolean isAndroid() {
        return this.getType() == ApplicationType.android;
    }

    default public boolean isIOS() {
        return this.getType() == ApplicationType.iOS;
    }

    default public boolean isMobile() {
        return this.isAndroid() || this.isIOS();
    }

    default public boolean isWeb() {
        return this.getType() == ApplicationType.web;
    }

    default public int getVersion() {
        return 0;
    }

    default public long getJavaHeap() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    default public long getNativeHeap() {
        return 0L;
    }

    @Nullable
    default public Thread getMainThread() {
        return null;
    }

    default public boolean isOnMainThread() {
        Thread thread = this.getMainThread();
        return thread == null || Thread.currentThread() == thread;
    }

    @Nullable
    public String getClipboardText();

    public void setClipboardText(String var1);

    default public boolean openFolder(String file) {
        return false;
    }

    default public boolean openURI(String URI2) {
        return false;
    }

    default public void getDnsServers(Seq<InetSocketAddress> out) {
    }

    public void post(Runnable var1);

    public void exit();

    @Override
    default public void dispose() {
        if (Core.settings != null) {
            Core.settings.autosave();
        }
        if (Core.audio != null) {
            Core.audio.dispose();
        }
    }

    public static enum ApplicationType {
        android,
        desktop,
        headless,
        web,
        iOS;

    }
}

