/*
 * Decompiled with CFR 0.152.
 */
package rhino;

import rhino.Context;
import rhino.Interpreter;
import rhino.InterpreterData;
import rhino.NativeFunction;
import rhino.Script;
import rhino.ScriptRuntime;
import rhino.Scriptable;
import rhino.debug.DebuggableScript;

final class InterpretedFunction
extends NativeFunction
implements Script {
    InterpreterData idata;

    private InterpretedFunction(InterpreterData idata) {
        this.idata = idata;
    }

    private InterpretedFunction(InterpretedFunction parent, int index) {
        this.idata = parent.idata.itsNestedFunctions[index];
    }

    static InterpretedFunction createScript(InterpreterData idata) {
        InterpretedFunction f = new InterpretedFunction(idata);
        return f;
    }

    static InterpretedFunction createFunction(Context cx, Scriptable scope, InterpreterData idata) {
        InterpretedFunction f = new InterpretedFunction(idata);
        f.initScriptFunction(cx, scope, f.idata.isES6Generator);
        return f;
    }

    static InterpretedFunction createFunction(Context cx, Scriptable scope, InterpretedFunction parent, int index) {
        InterpretedFunction f = new InterpretedFunction(parent, index);
        f.initScriptFunction(cx, scope, f.idata.isES6Generator);
        return f;
    }

    @Override
    public String getFunctionName() {
        return this.idata.itsName == null ? "" : this.idata.itsName;
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!ScriptRuntime.hasTopCall(cx)) {
            return ScriptRuntime.doTopCall(this, cx, scope, thisObj, args, this.idata.isStrict);
        }
        return Interpreter.interpret(this, cx, scope, thisObj, args);
    }

    @Override
    public Object exec(Context cx, Scriptable scope) {
        if (!this.isScript()) {
            throw new IllegalStateException();
        }
        if (!ScriptRuntime.hasTopCall(cx)) {
            return ScriptRuntime.doTopCall(this, cx, scope, scope, ScriptRuntime.emptyArgs, this.idata.isStrict);
        }
        return Interpreter.interpret(this, cx, scope, scope, ScriptRuntime.emptyArgs);
    }

    public boolean isScript() {
        return this.idata.itsFunctionType == 0;
    }

    @Override
    public String getEncodedSource() {
        return Interpreter.getEncodedSource(this.idata);
    }

    @Override
    public DebuggableScript getDebuggableView() {
        return this.idata;
    }

    @Override
    public Object resumeGenerator(Context cx, Scriptable scope, int operation, Object state, Object value) {
        return Interpreter.resumeGenerator(cx, scope, operation, state, value);
    }

    @Override
    protected int getLanguageVersion() {
        return this.idata.languageVersion;
    }

    @Override
    protected int getParamCount() {
        return this.idata.argCount;
    }

    @Override
    protected int getParamAndVarCount() {
        return this.idata.argNames.length;
    }

    @Override
    protected String getParamOrVarName(int index) {
        return this.idata.argNames[index];
    }

    @Override
    protected boolean getParamOrVarConst(int index) {
        return this.idata.argIsConst[index];
    }

    boolean hasFunctionNamed(String name) {
        for (int f = 0; f < this.idata.getFunctionCount(); ++f) {
            InterpreterData functionData = (InterpreterData)this.idata.getFunction(f);
            if (functionData.declaredAsFunctionExpression || !name.equals(functionData.getFunctionName())) continue;
            return false;
        }
        return true;
    }
}

