/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.util.Eachable;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class DrawPower
extends DrawBlock {
    public TextureRegion emptyRegion;
    public TextureRegion fullRegion;
    public String suffix = "-power";
    public boolean drawPlan = true;
    public boolean mixcol = true;
    public Color emptyLightColor = Color.valueOf("f8c266");
    public Color fullLightColor = Color.valueOf("fb9567");
    public float layer = -1.0f;

    public DrawPower() {
    }

    public DrawPower(String suffix) {
        this.suffix = suffix;
    }

    @Override
    public void draw(Building build) {
        float z = Draw.z();
        if (this.layer > 0.0f) {
            Draw.z(this.layer);
        }
        if (this.mixcol) {
            Draw.color(this.emptyLightColor, this.fullLightColor, build.power.status);
            if (this.emptyRegion.found()) {
                Draw.rect(this.emptyRegion, build.x, build.y);
            } else {
                Fill.square(build.x, build.y, ((float)(8 * build.block.size) / 2.0f - 1.0f) * Draw.xscl);
            }
        } else {
            Draw.rect(this.emptyRegion, build.x, build.y);
            Draw.alpha(build.power.status);
            Draw.rect(this.fullRegion, build.x, build.y);
        }
        Draw.color();
        Draw.z(z);
    }

    @Override
    public void drawPlan(Block block, BuildPlan plan, Eachable<BuildPlan> list) {
        if (!this.drawPlan || this.mixcol || !this.emptyRegion.found()) {
            return;
        }
        Draw.rect(this.emptyRegion, plan.drawx(), plan.drawy());
    }

    @Override
    public TextureRegion[] icons(Block block) {
        TextureRegion[] textureRegionArray;
        if (!this.mixcol && this.emptyRegion.found()) {
            TextureRegion[] textureRegionArray2 = new TextureRegion[1];
            textureRegionArray = textureRegionArray2;
            textureRegionArray2[0] = this.emptyRegion;
        } else {
            textureRegionArray = new TextureRegion[]{};
        }
        return textureRegionArray;
    }

    @Override
    public void load(Block block) {
        if (this.mixcol) {
            this.emptyRegion = Core.atlas.find(block.name + this.suffix);
        } else {
            this.emptyRegion = Core.atlas.find(block.name + this.suffix + "-empty");
            this.fullRegion = Core.atlas.find(block.name + this.suffix + "-full");
        }
    }
}

