/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.power;

import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.QuadTree;
import arc.struct.Seq;
import arc.util.Tmp;
import java.util.Arrays;
import mindustry.Vars;
import mindustry.core.Renderer;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.input.Placement;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.power.PowerBlock;
import mindustry.world.blocks.power.PowerGraph;
import mindustry.world.blocks.power.PowerNode;
import mindustry.world.meta.BlockStatus;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class BeamNode
extends PowerBlock {
    private static final int maxRange = 30;
    public int range = 5;
    public TextureRegion laser;
    public TextureRegion laserEnd;
    public Color laserColor1 = Color.white;
    public Color laserColor2 = Color.valueOf("ffd9c2");
    public float pulseScl = 7.0f;
    public float pulseMag = 0.05f;
    public float laserWidth = 0.4f;

    public BeamNode(String name) {
        super(name);
        this.outputsPower = false;
        this.consumesPower = false;
        this.drawDisabled = false;
        this.envEnabled |= 2;
        this.allowDiagonal = false;
        this.underBullets = true;
        this.priority = -1.0f;
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addBar("power", PowerNode.makePowerBalance());
        this.addBar("batteries", PowerNode.makeBatteryBalance());
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.powerRange, this.range, StatUnit.blocks);
    }

    @Override
    public void init() {
        super.init();
        this.updateClipRadius((this.range + 1) * 8);
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        for (int i = 0; i < 4; ++i) {
            Building other;
            int maxLen = this.range + this.size / 2;
            Building dest = null;
            Point2 dir = Geometry.d4[i];
            int dx = dir.x;
            int dy = dir.y;
            int offset = this.size / 2;
            for (int j = 1 + offset; !(j > this.range + offset || (other = Vars.world.build(x + j * dir.x, y + j * dir.y)) != null && other.isInsulated()); ++j) {
                if (other == null || !other.block.hasPower || other.team != Vars.player.team() || other.block instanceof PowerNode) continue;
                maxLen = j;
                dest = other;
                break;
            }
            Drawf.dashLine(Pal.placing, (float)(x * 8) + (float)dx * ((float)(8 * this.size) / 2.0f + 2.0f), (float)(y * 8) + (float)dy * ((float)(8 * this.size) / 2.0f + 2.0f), x * 8 + dx * maxLen * 8, y * 8 + dy * maxLen * 8);
            if (dest == null) continue;
            Drawf.square(dest.x, dest.y, (float)(dest.block.size * 8) / 2.0f + 2.5f, 0.0f);
        }
    }

    @Override
    public void changePlacementPath(Seq<Point2> points, int rotation, boolean diagonal) {
        if (!diagonal) {
            Placement.calculateNodes(points, this, rotation, (point, other) -> Math.max(Math.abs(point.x - other.x), Math.abs(point.y - other.y)) <= this.range + this.size - 1);
        }
    }

    public static void getNodeLinks(Tile tile, Block block, Team team, Cons<Building> others) {
        QuadTree<Building> tree = team.data().buildingTree;
        if (tree == null) {
            return;
        }
        float cx = tile.worldx() + block.offset;
        float cy = tile.worldy() + block.offset;
        float s = (float)(block.size * 8) / 2.0f;
        float r = 240.0f;
        for (int i = 0; i < 4; ++i) {
            switch (i) {
                case 0: {
                    Tmp.r1.set(cx - s, cy - s, r, s * 2.0f);
                    break;
                }
                case 1: {
                    Tmp.r1.set(cx - s, cy - s, s * 2.0f, r);
                    break;
                }
                case 2: {
                    Tmp.r1.set(cx + s, cy - s, -r, s * 2.0f).normalize();
                    break;
                }
                case 3: {
                    Tmp.r1.set(cx - s, cy + s, s * 2.0f, -r).normalize();
                }
            }
            tempBuilds.clear();
            tree.intersect(Tmp.r1, tempBuilds);
            int fi = i;
            Building closest = tempBuilds.min(b -> {
                BeamNodeBuild node;
                return b instanceof BeamNodeBuild && (node = (BeamNodeBuild)b).couldConnect((fi + 2) % 4, block, tile.x, tile.y);
            }, b -> b.dst2(cx, cy));
            tempBuilds.clear();
            if (closest == null) continue;
            others.get(closest);
        }
    }

    public void drawLaser(float x1, float y1, float x2, float y2, int size1, int size2) {
        float w = this.laserWidth;
        float dst = Math.max(Math.abs(x1 - x2), Math.abs(y2 - y1)) / 8.0f;
        float sizeOff = dst * 8.0f - (float)((size1 + size2) * 8) / 2.0f;
        if (dst > (float)(1 + this.size / 2)) {
            Point2 point = Geometry.d4(Tile.relativeTo(x1, y1, x2, y2));
            float poff = 4.0f;
            Drawf.laser(this.laser, this.laserEnd, x1 + poff * (float)this.size * (float)point.x, y1 + poff * (float)this.size * (float)point.y, x1 + (poff * (float)this.size + sizeOff) * (float)point.x, y1 + (poff * (float)this.size + sizeOff) * (float)point.y, w);
        }
    }

    public class BeamNodeBuild
    extends Building {
        public Building[] links = new Building[4];
        public Tile[] dests = new Tile[4];
        public int lastChange = -2;

        public boolean couldConnect(int direction, Block target, int targetX, int targetY) {
            int offset = -(target.size - 1) / 2;
            int minX = targetX + offset;
            int minY = targetY + offset;
            int maxX = targetX + offset + target.size - 1;
            int maxY = targetY + offset + target.size - 1;
            Point2 dir = Geometry.d4[direction];
            int rangeOffset = BeamNode.this.size / 2;
            for (int j = 1 + rangeOffset; j <= BeamNode.this.range + rangeOffset; ++j) {
                Tile other = Vars.world.tile(this.tile.x + j * dir.x, this.tile.y + j * dir.y);
                if (other == null) {
                    return false;
                }
                if (other.build != null && other.build.isInsulated() || other.block().hasPower && other.block().connectedPower && other.team() == this.team) {
                    return false;
                }
                if (other.x < minX || other.y < minY || other.x > maxX || other.y > maxY) continue;
                return true;
            }
            return false;
        }

        @Override
        public void updateTile() {
            if (this.lastChange != Vars.world.tileChanges) {
                this.lastChange = Vars.world.tileChanges;
                this.updateDirections();
            }
        }

        @Override
        public BlockStatus status() {
            float balance = this.power.graph.getPowerBalance();
            if (balance > 0.0f) {
                return BlockStatus.active;
            }
            if (balance < 0.0f && this.power.graph.getLastPowerStored() > 0.0f) {
                return BlockStatus.noOutput;
            }
            return BlockStatus.noInput;
        }

        @Override
        public void draw() {
            super.draw();
            if (Mathf.zero(Renderer.laserOpacity) || this.team == Team.derelict) {
                return;
            }
            Draw.z(70.0f);
            Draw.color(BeamNode.this.laserColor1, BeamNode.this.laserColor2, (1.0f - this.power.graph.getSatisfaction()) * 0.86f + Mathf.absin(3.0f, 0.1f));
            Draw.alpha(Renderer.laserOpacity);
            float w = BeamNode.this.laserWidth + Mathf.absin(BeamNode.this.pulseScl, BeamNode.this.pulseMag);
            for (int i = 0; i < 4; ++i) {
                int dst;
                if (this.dests[i] == null || !this.links[i].wasVisible) continue;
                Block block = this.links[i].block;
                if (block instanceof BeamNode) {
                    BeamNode node = (BeamNode)block;
                    if (!(this.links[i].tileX() != this.tileX() && this.links[i].tileY() != this.tileY() || this.links[i].id > this.id && BeamNode.this.range >= node.range) && BeamNode.this.range <= node.range) continue;
                }
                if ((dst = Math.max(Math.abs(this.dests[i].x - this.tile.x), Math.abs(this.dests[i].y - this.tile.y))) <= 1 + BeamNode.this.size / 2) continue;
                Point2 point = Geometry.d4[i];
                float poff = 4.0f;
                Drawf.laser(BeamNode.this.laser, BeamNode.this.laserEnd, this.x + poff * (float)BeamNode.this.size * (float)point.x, this.y + poff * (float)BeamNode.this.size * (float)point.y, this.dests[i].worldx() - poff * (float)point.x, this.dests[i].worldy() - poff * (float)point.y, w);
            }
            Draw.reset();
        }

        @Override
        public void pickedUp() {
            Arrays.fill(this.links, null);
            Arrays.fill(this.dests, null);
        }

        public void updateDirections() {
            for (int i = 0; i < 4; ++i) {
                Building next;
                Building other;
                Building prev = this.links[i];
                Point2 dir = Geometry.d4[i];
                this.links[i] = null;
                this.dests[i] = null;
                int offset = BeamNode.this.size / 2;
                for (int j = 1 + offset; !(j > BeamNode.this.range + offset || (other = Vars.world.build(this.tile.x + j * dir.x, this.tile.y + j * dir.y)) != null && other.isInsulated()); ++j) {
                    if (other == null || !other.block.hasPower || !other.block.connectedPower || other.team != this.team || other.block instanceof PowerNode) continue;
                    this.links[i] = other;
                    this.dests[i] = Vars.world.tile(this.tile.x + j * dir.x, this.tile.y + j * dir.y);
                    break;
                }
                if ((next = this.links[i]) == prev) continue;
                if (prev != null && prev.isAdded()) {
                    prev.power.links.removeValue(this.pos());
                    this.power.links.removeValue(prev.pos());
                    PowerGraph newgraph = new PowerGraph();
                    newgraph.reflow(this);
                    if (prev.power.graph != newgraph) {
                        PowerGraph og = new PowerGraph();
                        og.reflow(prev);
                    }
                }
                if (next == null) continue;
                this.power.links.addUnique(next.pos());
                next.power.links.addUnique(this.pos());
                this.power.graph.addGraph(next.power.graph);
            }
        }
    }
}

