/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks;

import arc.util.serialization.Json;
import arc.util.serialization.JsonValue;
import java.util.Arrays;
import mindustry.world.meta.Attribute;

public class Attributes
implements Json.JsonSerializable {
    private float[] arr = new float[Attribute.all.length];

    public void clear() {
        Arrays.fill(this.arr, 0.0f);
    }

    public float get(Attribute attr) {
        this.check();
        return this.arr[attr.id];
    }

    public void set(Attribute attr, float value) {
        this.check();
        this.arr[attr.id] = value;
    }

    public void add(Attributes other) {
        this.check();
        other.check();
        for (int i = 0; i < this.arr.length; ++i) {
            int n = i;
            this.arr[n] = this.arr[n] + other.arr[i];
        }
    }

    public void add(Attributes other, float scl) {
        this.check();
        other.check();
        for (int i = 0; i < this.arr.length; ++i) {
            int n = i;
            this.arr[n] = this.arr[n] + other.arr[i] * scl;
        }
    }

    @Override
    public void write(Json json) {
        this.check();
        for (Attribute at : Attribute.all) {
            if (this.arr[at.id] == 0.0f) continue;
            json.writeValue(at.name, Float.valueOf(this.arr[at.id]));
        }
    }

    @Override
    public void read(Json json, JsonValue data) {
        this.check();
        for (Attribute at : Attribute.all) {
            this.arr[at.id] = data.getFloat(at.name, 0.0f);
        }
    }

    private void check() {
        if (this.arr.length != Attribute.all.length) {
            float[] last = this.arr;
            this.arr = new float[Attribute.all.length];
            System.arraycopy(last, 0, this.arr, 0, Math.min(last.length, this.arr.length));
        }
    }
}

