/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type.weather;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.TextureRegion;
import mindustry.content.Liquids;
import mindustry.gen.WeatherState;
import mindustry.type.Liquid;
import mindustry.type.Weather;

public class RainWeather
extends Weather {
    public float yspeed = 5.0f;
    public float xspeed = 1.5f;
    public float padding = 16.0f;
    public float density = 1200.0f;
    public float stroke = 0.75f;
    public float sizeMin = 8.0f;
    public float sizeMax = 40.0f;
    public float splashTimeScale = 22.0f;
    public Liquid liquid = Liquids.water;
    public TextureRegion[] splashes = new TextureRegion[12];
    public Color color = Color.valueOf("7a95eaff");

    public RainWeather(String name) {
        super(name);
    }

    @Override
    public void load() {
        super.load();
        for (int i = 0; i < this.splashes.length; ++i) {
            this.splashes[i] = Core.atlas.find("splash-" + i);
        }
    }

    @Override
    public void drawOver(WeatherState state) {
        RainWeather.drawRain(this.sizeMin, this.sizeMax, this.xspeed, this.yspeed, this.density, state.intensity, this.stroke, this.color);
    }

    @Override
    public void drawUnder(WeatherState state) {
        RainWeather.drawSplashes(this.splashes, this.sizeMax, this.density, state.intensity, state.opacity, this.splashTimeScale, this.stroke, this.color, this.liquid);
    }
}

