/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.effect;

import arc.audio.Sound;
import arc.graphics.Color;
import arc.math.Mathf;
import arc.util.Time;
import mindustry.entities.Effect;
import mindustry.gen.Sounds;

public class SoundEffect
extends Effect {
    public Sound sound = Sounds.none;
    public float minPitch = 0.8f;
    public float maxPitch = 1.2f;
    public float minVolume = 1.0f;
    public float maxVolume = 1.0f;
    public Effect effect;

    public SoundEffect() {
        this.startDelay = -1.0f;
    }

    public SoundEffect(Sound sound, Effect effect) {
        this();
        this.sound = sound;
        this.effect = effect;
    }

    @Override
    public void init() {
        if (this.startDelay < 0.0f) {
            this.startDelay = this.effect.startDelay;
        }
    }

    @Override
    public void create(float x, float y, float rotation, Color color, Object data) {
        if (!this.shouldCreate()) {
            return;
        }
        if (this.startDelay > 0.0f) {
            Time.run(this.startDelay, () -> this.sound.at(x, y, Mathf.random(this.minPitch, this.maxPitch), Mathf.random(this.minVolume, this.maxVolume)));
        } else {
            this.sound.at(x, y, Mathf.random(this.minPitch, this.maxPitch), Mathf.random(this.minVolume, this.maxVolume));
        }
        this.effect.create(x, y, rotation, color, data);
    }
}

