/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.graphics.Mesh;
import arc.graphics.Texture;
import arc.graphics.VertexAttribute;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.IndexData;
import arc.graphics.gl.Shader;
import arc.math.Mathf;
import arc.struct.IntSeq;
import arc.struct.Seq;
import arc.util.Disposable;
import arc.util.Nullable;
import arc.util.Pack;

public class EditorSpriteCache
implements Disposable {
    static final int vertexSize = 3;
    @Nullable
    private Mesh mesh;
    private final Seq<Texture> textures = new Seq(8);
    private final IntSeq counts = new IntSeq(8);
    private final float packX;
    private final float packY;
    private final float packW;
    private final float packH;
    private float[] tmpVertices;
    private int index;

    public EditorSpriteCache(float[] tmpVertices, float packX, float packY, float packW, float packH) {
        this.tmpVertices = tmpVertices;
        this.packX = packX;
        this.packY = packY;
        this.packW = packW;
        this.packH = packH;
    }

    public boolean isEmpty() {
        return this.index == 0;
    }

    public void build(IndexData indices) {
        if (this.mesh != null) {
            this.mesh.dispose();
        }
        this.mesh = new Mesh(true, this.index / 3, 0, VertexAttribute.packedPosition, VertexAttribute.color, VertexAttribute.packedTexCoords);
        this.mesh.indices = indices;
        this.mesh.setVertices(this.tmpVertices, 0, this.index);
    }

    public void draw(TextureRegion region, float x, float y, float originX, float originY, float width, float height, float rotation, float colorPacked) {
        float y4;
        float x4;
        float y3;
        float x3;
        float y2;
        float x2;
        float y1;
        float x1;
        if (this.mesh != null) {
            throw new IllegalStateException("This cache is already built. Call #clear() before drawing new sprites.");
        }
        float worldOriginX = x + originX;
        float worldOriginY = y + originY;
        float fx = -originX;
        float fy = -originY;
        float fx2 = width - originX;
        float fy2 = height - originY;
        if (rotation != 0.0f) {
            float cos = Mathf.cosDeg(rotation);
            float sin = Mathf.sinDeg(rotation);
            x1 = cos * fx - sin * fy;
            y1 = sin * fx + cos * fy;
            x2 = cos * fx - sin * fy2;
            y2 = sin * fx + cos * fy2;
            x3 = cos * fx2 - sin * fy2;
            y3 = sin * fx2 + cos * fy2;
            x4 = x1 + (x3 - x2);
            y4 = y3 - (y2 - y1);
        } else {
            x1 = fx;
            y1 = fy;
            x2 = fx;
            y2 = fy2;
            x3 = fx2;
            y3 = fy2;
            x4 = fx2;
            y4 = fy;
        }
        x1 += worldOriginX;
        y1 += worldOriginY;
        x2 += worldOriginX;
        y2 += worldOriginY;
        x3 += worldOriginX;
        y3 += worldOriginY;
        x4 += worldOriginX;
        y4 += worldOriginY;
        float u = region.u;
        float v = region.v2;
        float u2 = region.u2;
        float v2 = region.v;
        int idx = this.index;
        float[] verts = this.tmpVertices;
        Texture texture = region.texture;
        verts[idx + 0] = this.pack(x1, y1);
        verts[idx + 1] = colorPacked;
        verts[idx + 2] = Pack.packUv(u, v);
        verts[idx + 3] = this.pack(x2, y2);
        verts[idx + 4] = colorPacked;
        verts[idx + 5] = Pack.packUv(u, v2);
        verts[idx + 6] = this.pack(x3, y3);
        verts[idx + 7] = colorPacked;
        verts[idx + 8] = Pack.packUv(u2, v2);
        verts[idx + 9] = this.pack(x4, y4);
        verts[idx + 10] = colorPacked;
        verts[idx + 11] = Pack.packUv(u2, v);
        int lastIndex = this.textures.size - 1;
        if (lastIndex < 0 || this.textures.get(lastIndex) != texture) {
            this.textures.add(texture);
            this.counts.add(6);
        } else {
            this.counts.incr(lastIndex, 6);
        }
        this.index += 12;
    }

    private float pack(float x, float y) {
        return Pack.packUv((x + this.packX) / this.packW, (y + this.packY) / this.packH);
    }

    public void render(Shader shader) {
        if (this.mesh == null) {
            throw new IllegalStateException("Cache is empty, call build() first.");
        }
        int offset = 0;
        for (int i = 0; i < this.textures.size; ++i) {
            int count = this.counts.items[i];
            this.textures.get(i).bind();
            this.mesh.render(shader, 4, offset, count);
            offset += count;
        }
    }

    @Override
    public void dispose() {
        if (this.mesh != null) {
            this.mesh.dispose();
            this.mesh = null;
        }
    }
}

