/*
 * Decompiled with CFR 0.152.
 */
package arc.util;

import arc.files.Fi;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Strings;
import arc.util.TextFormatter;
import arc.util.io.PropertiesUtils;
import arc.util.io.Streams;
import java.io.Reader;
import java.util.Locale;
import java.util.MissingResourceException;

public class I18NBundle {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final Locale ROOT_LOCALE = new Locale("", "", "");
    private static boolean simpleFormatter = false;
    private I18NBundle parent;
    private Locale locale;
    private ObjectMap<String, String> properties;
    private TextFormatter formatter;

    public static boolean getSimpleFormatter() {
        return simpleFormatter;
    }

    public static void setSimpleFormatter(boolean enabled) {
        simpleFormatter = enabled;
    }

    public static I18NBundle createEmptyBundle() {
        I18NBundle bundle = new I18NBundle();
        bundle.locale = ROOT_LOCALE;
        bundle.properties = new ObjectMap();
        return bundle;
    }

    public static I18NBundle createBundle(Fi baseFileHandle) {
        return I18NBundle.createBundleImpl(baseFileHandle, Locale.getDefault(), DEFAULT_ENCODING);
    }

    public static I18NBundle createBundle(Fi baseFileHandle, Locale locale) {
        return I18NBundle.createBundleImpl(baseFileHandle, locale, DEFAULT_ENCODING);
    }

    public static I18NBundle createBundle(Fi baseFileHandle, String encoding) {
        return I18NBundle.createBundleImpl(baseFileHandle, Locale.getDefault(), encoding);
    }

    public static I18NBundle createBundle(Fi baseFileHandle, Locale locale, String encoding) {
        return I18NBundle.createBundleImpl(baseFileHandle, locale, encoding);
    }

    private static I18NBundle createBundleImpl(Fi baseFileHandle, Locale locale, String encoding) {
        I18NBundle bundle;
        if (baseFileHandle == null || locale == null || encoding == null) {
            throw new NullPointerException();
        }
        I18NBundle baseBundle = null;
        Locale targetLocale = locale;
        do {
            Seq<Locale> candidateLocales;
            if ((bundle = I18NBundle.loadBundleChain(baseFileHandle, encoding, candidateLocales = I18NBundle.getCandidateLocales(targetLocale), 0, baseBundle)) == null) continue;
            Locale bundleLocale = bundle.locale;
            boolean isBaseBundle = bundleLocale.equals(ROOT_LOCALE);
            if (!isBaseBundle || bundleLocale.equals(locale) || candidateLocales.size == 1 && bundleLocale.equals(candidateLocales.get(0))) break;
            if (baseBundle != null) continue;
            baseBundle = bundle;
        } while ((targetLocale = I18NBundle.getFallbackLocale(targetLocale)) != null);
        if (bundle == null) {
            if (baseBundle == null) {
                throw new MissingResourceException("Can't find bundle for base file handle " + baseFileHandle.path() + ", locale " + locale, baseFileHandle + "_" + locale, "");
            }
            bundle = baseBundle;
        }
        return bundle;
    }

    private static Seq<Locale> getCandidateLocales(Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        Seq<Locale> locales = new Seq<Locale>(4);
        if (variant.length() > 0) {
            locales.add(locale);
        }
        if (country.length() > 0) {
            locales.add(locales.isEmpty() ? locale : new Locale(language, country));
        }
        if (language.length() > 0) {
            locales.add(locales.isEmpty() ? locale : new Locale(language));
        }
        locales.add(ROOT_LOCALE);
        return locales;
    }

    private static Locale getFallbackLocale(Locale locale) {
        Locale defaultLocale = Locale.getDefault();
        return locale.equals(defaultLocale) ? null : defaultLocale;
    }

    private static I18NBundle loadBundleChain(Fi baseFileHandle, String encoding, Seq<Locale> candidateLocales, int candidateIndex, I18NBundle baseBundle) {
        Locale targetLocale = candidateLocales.get(candidateIndex);
        I18NBundle parent = null;
        if (candidateIndex != candidateLocales.size - 1) {
            parent = I18NBundle.loadBundleChain(baseFileHandle, encoding, candidateLocales, candidateIndex + 1, baseBundle);
        } else if (baseBundle != null && targetLocale.equals(ROOT_LOCALE)) {
            return baseBundle;
        }
        I18NBundle bundle = I18NBundle.loadBundle(baseFileHandle, encoding, targetLocale);
        if (bundle != null) {
            bundle.parent = parent;
            return bundle;
        }
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static I18NBundle loadBundle(Fi baseFileHandle, String encoding, Locale targetLocale) {
        I18NBundle bundle = null;
        Reader reader = null;
        try {
            Fi fileHandle = I18NBundle.toFileHandle(baseFileHandle, targetLocale);
            if (I18NBundle.checkFileExistence(fileHandle)) {
                bundle = new I18NBundle();
                reader = fileHandle.reader(encoding);
                bundle.load(reader);
            }
        }
        finally {
            Streams.close(reader);
        }
        if (bundle != null) {
            bundle.setLocale(targetLocale);
        }
        return bundle;
    }

    private static boolean checkFileExistence(Fi fh) {
        try {
            fh.read().close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static Fi toFileHandle(Fi baseFileHandle, Locale locale) {
        StringBuilder sb = new StringBuilder(baseFileHandle.name());
        if (!locale.equals(ROOT_LOCALE)) {
            String language = locale.getLanguage().replace("in", "id");
            String country = locale.getCountry();
            String variant = locale.getVariant();
            boolean emptyLanguage = "".equals(language);
            boolean emptyCountry = "".equals(country);
            boolean emptyVariant = "".equals(variant);
            if (!(emptyLanguage && emptyCountry && emptyVariant)) {
                sb.append('_');
                if (!emptyVariant) {
                    sb.append(language).append('_').append(country).append('_').append(variant);
                } else if (!emptyCountry) {
                    sb.append(language).append('_').append(country);
                } else {
                    sb.append(language);
                }
            }
        }
        return baseFileHandle.sibling(sb.append(".properties").toString());
    }

    private void load(Reader reader) {
        this.properties = new ObjectMap();
        PropertiesUtils.load(this.properties, reader);
    }

    public Locale getLocale() {
        return this.locale;
    }

    private void setLocale(Locale locale) {
        this.locale = locale;
        this.formatter = new TextFormatter(locale, !simpleFormatter);
    }

    public final String get(String key) {
        String result = this.properties.get(key);
        if (result == null) {
            if (this.parent != null) {
                result = this.parent.get(key);
            }
            if (result == null) {
                return "???" + key + "???";
            }
        }
        return result;
    }

    public String get(String key, String def) {
        return this.has(key) ? this.get(key) : def;
    }

    public String getOrNull(String key) {
        return this.has(key) ? this.get(key) : null;
    }

    public String getNotNull(String key) {
        String s = this.getOrNull(key);
        if (s == null) {
            throw new MissingResourceException("No key with name \"" + key + "\" found!", this.getClass().getName(), key);
        }
        return s;
    }

    public Iterable<String> getKeys() {
        return this.properties.keys();
    }

    public ObjectMap<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(ObjectMap<String, String> properties) {
        this.properties = properties;
    }

    public boolean has(String key) {
        if (this.properties.containsKey(key)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.has(key);
        }
        return false;
    }

    public String format(String key, Object ... args) {
        return this.formatter.format(this.get(key), args);
    }

    public String formatString(String string, Object ... args) {
        return this.formatter.format(string, args);
    }

    public String formatFloat(String key, float value, int places) {
        return this.formatter.format(this.get(key), Strings.fixed(value, places));
    }

    public void debug(String placeholder) {
        ObjectMap.Keys<String> keys = this.properties.keys();
        if (keys == null) {
            return;
        }
        for (String s : keys) {
            this.properties.put(s, placeholder);
        }
    }

    public I18NBundle getParent() {
        return this.parent;
    }
}

