/*
 * Decompiled with CFR 0.152.
 */
package arc.struct;

import arc.struct.ObjectSet;
import arc.struct.Seq;
import java.util.NoSuchElementException;

public class OrderedSet<T>
extends ObjectSet<T> {
    final Seq<T> items;
    OrderedSetIterator iterator1;
    OrderedSetIterator iterator2;

    public OrderedSet() {
        this.items = new Seq();
    }

    public OrderedSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.items = new Seq(this.capacity);
    }

    public OrderedSet(int initialCapacity) {
        super(initialCapacity);
        this.items = new Seq(this.capacity);
    }

    public OrderedSet(OrderedSet set) {
        super(set);
        this.items = new Seq(this.capacity);
        this.items.addAll(set.items);
    }

    @Override
    public T first() {
        return this.items.first();
    }

    @Override
    public boolean add(T key) {
        if (!super.add(key)) {
            return false;
        }
        this.items.add(key);
        return true;
    }

    public boolean add(T key, int index) {
        if (!super.add(key)) {
            this.items.remove(key, true);
            this.items.insert(index, key);
            return false;
        }
        this.items.insert(index, key);
        return true;
    }

    @Override
    public boolean remove(T key) {
        if (!super.remove(key)) {
            return false;
        }
        this.items.remove(key, false);
        return true;
    }

    public T removeIndex(int index) {
        T key = this.items.remove(index);
        super.remove(key);
        return key;
    }

    @Override
    public void clear(int maximumCapacity) {
        this.items.clear();
        super.clear(maximumCapacity);
    }

    @Override
    public void clear() {
        this.items.clear();
        super.clear();
    }

    public Seq<T> orderedItems() {
        return this.items;
    }

    @Override
    public OrderedSetIterator iterator() {
        if (this.iterator1 == null) {
            this.iterator1 = new OrderedSetIterator();
            this.iterator2 = new OrderedSetIterator();
        }
        if (this.iterator1.done) {
            this.iterator1.reset();
            return this.iterator1;
        }
        if (this.iterator2.done) {
            this.iterator2.reset();
            return this.iterator2;
        }
        return new OrderedSetIterator();
    }

    @Override
    public String toString() {
        if (this.size == 0) {
            return "{}";
        }
        T[] items = this.items.items;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('{');
        buffer.append(items[0]);
        for (int i = 1; i < this.size; ++i) {
            buffer.append(", ");
            buffer.append(items[i]);
        }
        buffer.append('}');
        return buffer.toString();
    }

    @Override
    public String toString(String separator) {
        return this.items.toString(separator);
    }

    public class OrderedSetIterator
    extends ObjectSet.ObjectSetIterator {
        @Override
        public void reset() {
            super.reset();
            this.nextIndex = 0;
            this.hasNext = OrderedSet.this.size > 0;
        }

        @Override
        public T next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            Object key = OrderedSet.this.items.get(this.nextIndex);
            ++this.nextIndex;
            this.hasNext = this.nextIndex < OrderedSet.this.size;
            return key;
        }

        @Override
        public void remove() {
            if (this.nextIndex < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            --this.nextIndex;
            OrderedSet.this.removeIndex(this.nextIndex);
        }
    }
}

