/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.gl;

import arc.Core;
import arc.graphics.Gl;
import arc.graphics.gl.HdpiMode;

public class HdpiUtils {
    private static HdpiMode mode = HdpiMode.logical;

    public static void setMode(HdpiMode mode) {
        HdpiUtils.mode = mode;
    }

    public static void glScissor(int x, int y, int width, int height) {
        if (mode == HdpiMode.logical && (Core.graphics.getWidth() != Core.graphics.getBackBufferWidth() || Core.graphics.getHeight() != Core.graphics.getBackBufferHeight())) {
            Gl.scissor(HdpiUtils.toBackBufferX(x), HdpiUtils.toBackBufferY(y), HdpiUtils.toBackBufferX(width), HdpiUtils.toBackBufferY(height));
        } else {
            Gl.scissor(x, y, width, height);
        }
    }

    public static void glViewport(int x, int y, int width, int height) {
        if (mode == HdpiMode.logical && (Core.graphics.getWidth() != Core.graphics.getBackBufferWidth() || Core.graphics.getHeight() != Core.graphics.getBackBufferHeight())) {
            Gl.viewport(HdpiUtils.toBackBufferX(x), HdpiUtils.toBackBufferY(y), HdpiUtils.toBackBufferX(width), HdpiUtils.toBackBufferY(height));
        } else {
            Gl.viewport(x, y, width, height);
        }
    }

    public static int toLogicalX(int backBufferX) {
        return (int)((float)(backBufferX * Core.graphics.getWidth()) / (float)Core.graphics.getBackBufferWidth());
    }

    public static int toLogicalY(int backBufferY) {
        return (int)((float)(backBufferY * Core.graphics.getHeight()) / (float)Core.graphics.getBackBufferHeight());
    }

    public static int toBackBufferX(int logicalX) {
        return (int)((float)(logicalX * Core.graphics.getBackBufferWidth()) / (float)Core.graphics.getWidth());
    }

    public static int toBackBufferY(int logicalY) {
        return (int)((float)(logicalY * Core.graphics.getBackBufferHeight()) / (float)Core.graphics.getHeight());
    }
}

