/*
 * Decompiled with CFR 0.152.
 */
package arc.fx.filters;

import arc.Core;
import arc.fx.FxFilter;
import arc.graphics.Texture;

public final class VignettingFilter
extends FxFilter {
    private Texture lutTexture = null;
    public float vignetteX = 0.8f;
    public float vignetteY = 0.25f;
    public float centerX = 0.5f;
    public float centerY = 0.5f;
    public float intensity = 1.0f;
    public float saturation = 0.0f;
    public float saturationMul = 0.0f;
    public boolean saturationEnabled;
    public boolean lutEnabled = false;
    public float lutIntensity = 1.0f;
    public int lutIndex1 = -1;
    public int lutIndex2 = -1;
    public float lutStep;
    public float lutStepOffset;
    public float lutIndexOffset = 0.0f;

    public VignettingFilter(boolean controlSaturation) {
        super(VignettingFilter.compileShader(Core.files.classpath("vfxshaders/screenspace.vert"), Core.files.classpath("vfxshaders/vignetting.frag"), controlSaturation ? "#define CONTROL_SATURATION\n#define ENABLE_GRADIENT_MAPPING" : "#define ENABLE_GRADIENT_MAPPING"));
        this.saturationEnabled = controlSaturation;
        this.rebind();
    }

    public void setLut(Texture texture) {
        this.lutTexture = texture;
        boolean bl = this.lutEnabled = this.lutTexture != null;
        if (this.lutEnabled) {
            this.lutStep = 1.0f / (float)texture.height;
            this.lutStepOffset = this.lutStep / 2.0f;
        }
    }

    @Override
    public void setParams() {
        this.shader.setUniformi("u_texture0", 0);
        this.shader.setUniformi("u_lutIndex1", this.lutIndex1);
        this.shader.setUniformi("u_lutIndex2", this.lutIndex2);
        this.shader.setUniformf("u_lutIndexOffset", this.lutIndexOffset);
        this.shader.setUniformi("u_texture1", 1);
        this.shader.setUniformf("u_lutIntensity", this.lutIntensity);
        this.shader.setUniformf("u_lutStep", this.lutStep);
        this.shader.setUniformf("u_lutStepOffset", this.lutStepOffset);
        if (this.saturationEnabled) {
            this.shader.setUniformf("u_saturation", this.saturation);
            this.shader.setUniformf("u_saturationMul", this.saturationMul);
        }
        this.shader.setUniformf("u_vignetteIntensity", this.intensity);
        this.shader.setUniformf("u_vignetteX", this.vignetteX);
        this.shader.setUniformf("u_vignetteY", this.vignetteY);
        this.shader.setUniformf("u_centerX", this.centerX);
        this.shader.setUniformf("u_centerY", this.centerY);
    }

    @Override
    protected void onBeforeRender() {
        this.inputTexture.bind(0);
        if (this.lutEnabled) {
            this.lutTexture.bind(1);
        }
    }
}

