/*
 * Decompiled with CFR 0.152.
 */
package arc.audio;

import arc.Core;
import arc.audio.AudioBus;
import arc.audio.AudioSource;
import arc.audio.Soloud;
import arc.files.Fi;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.util.Nullable;

public class Sound
extends AudioSource {
    public AudioBus bus;
    @Nullable
    public Fi file;
    long framePlayed;

    public Sound() {
        this.bus = Core.audio == null ? null : Core.audio.soundBus;
    }

    public Sound(Fi file) {
        this.bus = Core.audio == null ? null : Core.audio.soundBus;
        this.load(file);
    }

    public void load(Fi file) {
        byte[] data = file.readBytes();
        this.file = file;
        this.handle = Soloud.wavLoad(data, data.length);
    }

    public int play(float volume, float pitch, float pan, boolean loop, boolean checkFrame) {
        if (this.handle == 0L || checkFrame && this.framePlayed == Core.graphics.getFrameId() || this.bus == null || !Core.audio.initialized) {
            return -1;
        }
        this.framePlayed = Core.graphics.getFrameId();
        if (Float.isInfinite(volume) || Float.isNaN(volume)) {
            volume = 0.0f;
        }
        if (Float.isInfinite(pan) || Float.isNaN(pan)) {
            pan = 0.0f;
        }
        if (Float.isInfinite(pitch) || Float.isNaN(pitch)) {
            pitch = 1.0f;
        }
        return Soloud.sourcePlayBus(this.handle, this.bus.handle, volume, Mathf.clamp(pitch * Core.audio.globalPitch, 1.0E-4f, 10.0f), Mathf.clamp(pan, -1.0f, 1.0f), loop);
    }

    public void setBus(AudioBus bus) {
        this.bus = bus;
    }

    public void stop() {
        if (this.handle == 0L) {
            return;
        }
        Soloud.sourceStop(this.handle);
    }

    public float calcPan(float x, float y) {
        if (Core.app.isHeadless()) {
            return 0.0f;
        }
        return Mathf.clamp((x - Core.camera.position.x) / (Core.camera.width / 2.0f), -0.9f, 0.9f);
    }

    public float calcVolume(float x, float y) {
        return this.calcFalloff(x, y) * Core.audio.sfxVolume;
    }

    public float calcFalloff(float x, float y) {
        if (Core.app.isHeadless()) {
            return 1.0f;
        }
        float dst2 = Mathf.dst2(x, y, Core.camera.position.x, Core.camera.position.y);
        return Mathf.clamp(1.0f / (dst2 / Core.audio.falloff));
    }

    public int at(float x, float y, float pitch) {
        return this.at(x, y, pitch, 1.0f);
    }

    public int at(float x, float y, float pitch, float volume, boolean checkFrame) {
        float vol = this.calcVolume(x, y) * volume;
        if (vol < 0.01f) {
            return -1;
        }
        return this.play(vol, pitch, this.calcPan(x, y), false, checkFrame);
    }

    public int at(float x, float y, float pitch, float volume) {
        return this.at(x, y, pitch, volume, true);
    }

    public int at(float x, float y) {
        return this.at(x, y, 1.0f);
    }

    public int at(Position pos) {
        return this.at(pos.getX(), pos.getY());
    }

    public int at(Position pos, float pitch) {
        return this.at(pos.getX(), pos.getY(), pitch);
    }

    public int play() {
        return this.play(Core.audio.sfxVolume);
    }

    public int play(float volume) {
        return this.play(volume, 1.0f, 0.0f);
    }

    public int play(float volume, float pitch, float pan, boolean loop) {
        return this.play(volume, pitch, pan, loop, true);
    }

    public int play(float volume, float pitch, float pan) {
        return this.play(volume, pitch, pan, false);
    }

    public int loop() {
        return this.loop(1.0f);
    }

    public int loop(float volume) {
        return this.loop(volume, 1.0f, 0.0f);
    }

    public int loop(float volume, float pitch, float pan) {
        return this.play(volume, pitch, pan, true);
    }

    public String toString() {
        return "SoloudSound: " + this.file;
    }
}

