/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.unit.presenter;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.Promotion;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.UnitIconGroup;
import com.unciv.ui.images.IconCircleGroup;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.pickerscreens.PromotionPickerScreen;
import com.unciv.ui.screens.pickerscreens.UnitRenamePopup;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.unit.UnitTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010!\u001a\u00020\u0012J\b\u0010\"\u001a\u00020\u001fH\u0016J\b\u0010#\u001a\u00020\u001fH\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010 \u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR!\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\t0\rj\b\u0012\u0004\u0012\u00020\t`\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006&"}, d2={"Lcom/unciv/ui/screens/worldscreen/unit/presenter/UnitPresenter;", "Lcom/unciv/ui/screens/worldscreen/unit/UnitTable$Presenter;", "unitTable", "Lcom/unciv/ui/screens/worldscreen/unit/UnitTable;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "<init>", "(Lcom/unciv/ui/screens/worldscreen/unit/UnitTable;Lcom/unciv/ui/screens/worldscreen/WorldScreen;)V", "selectedUnit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "getSelectedUnit", "()Lcom/unciv/logic/map/mapunit/MapUnit;", "selectedUnits", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getSelectedUnits", "()Ljava/util/ArrayList;", "selectedUnitIsSwapping", "", "getSelectedUnitIsSwapping", "()Z", "setSelectedUnitIsSwapping", "(Z)V", "selectedUnitIsConnectingRoad", "getSelectedUnitIsConnectingRoad", "setSelectedUnitIsConnectingRoad", "position", "Lcom/badlogic/gdx/math/Vector2;", "getPosition", "()Lcom/badlogic/gdx/math/Vector2;", "selectUnit", "", "unit", "append", "update", "updateWhenNeeded", "buildNameLabelText", "", "core"})
@SourceDebugExtension(value={"SMAP\nUnitPresenter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitPresenter.kt\ncom/unciv/ui/screens/worldscreen/unit/presenter/UnitPresenter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,163:1\n1761#2,3:164\n*S KotlinDebug\n*F\n+ 1 UnitPresenter.kt\ncom/unciv/ui/screens/worldscreen/unit/presenter/UnitPresenter\n*L\n130#1:164,3\n*E\n"})
public final class UnitPresenter
implements UnitTable.Presenter {
    @NotNull
    private final UnitTable unitTable;
    @NotNull
    private final WorldScreen worldScreen;
    @NotNull
    private final ArrayList<MapUnit> selectedUnits;
    private boolean selectedUnitIsSwapping;
    private boolean selectedUnitIsConnectingRoad;

    public UnitPresenter(@NotNull UnitTable unitTable, @NotNull WorldScreen worldScreen) {
        Intrinsics.checkNotNullParameter(unitTable, "unitTable");
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        this.unitTable = unitTable;
        this.worldScreen = worldScreen;
        this.selectedUnits = new ArrayList();
    }

    @Nullable
    public final MapUnit getSelectedUnit() {
        return (MapUnit)CollectionsKt.firstOrNull((List)this.selectedUnits);
    }

    @NotNull
    public final ArrayList<MapUnit> getSelectedUnits() {
        return this.selectedUnits;
    }

    public final boolean getSelectedUnitIsSwapping() {
        return this.selectedUnitIsSwapping;
    }

    public final void setSelectedUnitIsSwapping(boolean bl) {
        this.selectedUnitIsSwapping = bl;
    }

    public final boolean getSelectedUnitIsConnectingRoad() {
        return this.selectedUnitIsConnectingRoad;
    }

    public final void setSelectedUnitIsConnectingRoad(boolean bl) {
        this.selectedUnitIsConnectingRoad = bl;
    }

    @Override
    @Nullable
    public Vector2 getPosition() {
        IsPartOfGameInfoSerialization isPartOfGameInfoSerialization = this.getSelectedUnit();
        return isPartOfGameInfoSerialization != null && (isPartOfGameInfoSerialization = ((MapUnit)isPartOfGameInfoSerialization).getCurrentTile()) != null ? ((Tile)isPartOfGameInfoSerialization).getPosition() : null;
    }

    public final void selectUnit(@Nullable MapUnit unit, boolean append2) {
        if (!append2) {
            this.selectedUnits.clear();
        }
        if (unit != null) {
            this.selectedUnits.add(unit);
            unit.actionsOnDeselect();
        }
        this.selectedUnitIsSwapping = false;
        this.selectedUnitIsConnectingRoad = false;
    }

    public static /* synthetic */ void selectUnit$default(UnitPresenter unitPresenter, MapUnit mapUnit, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            mapUnit = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        unitPresenter.selectUnit(mapUnit, bl);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update() {
        block7: {
            block8: {
                int interceptionRange;
                boolean disappeared;
                MapUnit mapUnit = this.getSelectedUnit();
                if (mapUnit == null) break block7;
                MapUnit unit = mapUnit;
                boolean bl = false;
                boolean captured = !Intrinsics.areEqual(unit.getCiv(), this.worldScreen.getViewingCiv()) && !this.worldScreen.getViewingCiv().isSpectator();
                boolean bl2 = disappeared = !SequencesKt.contains(unit.getTile().getUnits(), unit);
                if (captured || disappeared) {
                    UnitTable.selectUnit$default(this.unitTable, null, false, 3, null);
                    this.worldScreen.setShouldUpdate(true);
                    return;
                }
                if (this.selectedUnits.size() != 1) break block8;
                UnitTable $this$update_u24lambda_u246_u24lambda_u244 = this.unitTable;
                boolean bl3 = false;
                $this$update_u24lambda_u246_u24lambda_u244.getSeparator$core().setVisible(true);
                $this$update_u24lambda_u246_u24lambda_u244.setNameLabelText(this.buildNameLabelText(unit));
                $this$update_u24lambda_u246_u24lambda_u244.getUnitNameLabel$core().clearListeners();
                ActivationExtensionsKt.onClick($this$update_u24lambda_u246_u24lambda_u244.getUnitNameLabel$core(), () -> UnitPresenter.update$lambda$6$lambda$4$lambda$1($this$update_u24lambda_u246_u24lambda_u244, unit, this));
                $this$update_u24lambda_u246_u24lambda_u244.getDescriptionTable$core().clear();
                $this$update_u24lambda_u246_u24lambda_u244.getDescriptionTable$core().defaults().pad(2.0f);
                char c = '\u27a1';
                Object object = unit.getMovementString();
                $this$update_u24lambda_u246_u24lambda_u244.getDescriptionTable$core().add(c + (String)object).padRight(10.0f);
                if (!unit.isCivilian()) {
                    c = '\u2020';
                    object = TranslationsKt.tr(unit.getBaseUnit().getStrength());
                    $this$update_u24lambda_u246_u24lambda_u244.getDescriptionTable$core().add(c + (String)object).padRight(10.0f);
                }
                if (unit.getBaseUnit().getRangedStrength() != 0) {
                    c = '\u2021';
                    object = TranslationsKt.tr(unit.getBaseUnit().getRangedStrength());
                    $this$update_u24lambda_u246_u24lambda_u244.getDescriptionTable$core().add(c + (String)object).padRight(10.0f);
                }
                if (unit.getBaseUnit().isRanged()) {
                    c = '\u2026';
                    object = TranslationsKt.tr(unit.getRange());
                    $this$update_u24lambda_u246_u24lambda_u244.getDescriptionTable$core().add(c + (String)object).padRight(10.0f);
                }
                if ((interceptionRange = unit.getInterceptionRange()) > 0) {
                    $this$update_u24lambda_u246_u24lambda_u244.getDescriptionTable$core().add((Actor)ImageGetter.getStatIcon$default(ImageGetter.INSTANCE, "InterceptRange", 0.0f, 2, null)).size(20.0f);
                    $this$update_u24lambda_u246_u24lambda_u244.getDescriptionTable$core().add(TranslationsKt.tr(interceptionRange)).padRight(10.0f);
                }
                if (!unit.isCivilian()) {
                    void $this$update_u24lambda_u246_u24lambda_u244_u24lambda_u243;
                    Object object2 = object = Scene2dExtensionsKt.toLabel("XP");
                    Table table2 = $this$update_u24lambda_u246_u24lambda_u244.getDescriptionTable$core();
                    boolean bl4 = false;
                    ActivationExtensionsKt.onClick((Actor)$this$update_u24lambda_u246_u24lambda_u244_u24lambda_u243, () -> UnitPresenter.update$lambda$6$lambda$4$lambda$3$lambda$2($this$update_u24lambda_u246_u24lambda_u244, unit));
                    table2.add((Actor)object);
                    $this$update_u24lambda_u246_u24lambda_u244.getDescriptionTable$core().add(TranslationsKt.tr(unit.getPromotions().getXP()) + '/' + TranslationsKt.tr(unit.getPromotions().xpForNextPromotion()));
                }
                if (unit.getBaseUnit().getReligiousStrength() > 0) {
                    $this$update_u24lambda_u246_u24lambda_u244.getDescriptionTable$core().add((Actor)ImageGetter.getStatIcon$default(ImageGetter.INSTANCE, "ReligiousStrength", 0.0f, 2, null)).size(20.0f);
                    $this$update_u24lambda_u246_u24lambda_u244.getDescriptionTable$core().add(TranslationsKt.tr(unit.getBaseUnit().getReligiousStrength() - unit.getReligiousStrengthLost()));
                }
                if (unit.getPromotions().getPromotions().size() == $this$update_u24lambda_u246_u24lambda_u244.getPromotionsTable$core().getChildren().size) break block7;
                $this$update_u24lambda_u246_u24lambda_u244.setShouldUpdate(true);
                break block7;
            }
            UnitTable $this$update_u24lambda_u246_u24lambda_u245 = this.unitTable;
            boolean bl = false;
            $this$update_u24lambda_u246_u24lambda_u245.setNameLabelText("");
            $this$update_u24lambda_u246_u24lambda_u245.getDescriptionTable$core().clear();
        }
    }

    @Override
    public void updateWhenNeeded() {
        MapUnit mapUnit = this.getSelectedUnit();
        if (mapUnit != null) {
            MapUnit unit = mapUnit;
            boolean bl = false;
            if (this.selectedUnits.size() == 1) {
                UnitTable $this$updateWhenNeeded_u24lambda_u2411_u24lambda_u2410 = this.unitTable;
                boolean bl2 = false;
                $this$updateWhenNeeded_u24lambda_u2411_u24lambda_u2410.getUnitIconHolder$core().add((Actor)new UnitIconGroup(unit, 30.0f)).pad(5.0f);
                Iterator<Object> iterator2 = unit.getPromotions().getPromotions(true).iterator();
                while (iterator2.hasNext()) {
                    Promotion promotion = iterator2.next();
                    if (IHasUniques.hasUnique$default(promotion, UniqueType.NotShownOnWorldScreen, null, 2, null)) continue;
                    $this$updateWhenNeeded_u24lambda_u2411_u24lambda_u2410.getPromotionsTable$core().add((Actor)ImageGetter.INSTANCE.getPromotionPortrait(promotion.getName(), 20.0f)).padBottom(2.0f);
                }
                for (Object object : unit.getStatusMap().values()) {
                    boolean bl3;
                    MapUnit.UnitStatus status;
                    block9: {
                        Intrinsics.checkNotNullExpressionValue(object, "next(...)");
                        status = (MapUnit.UnitStatus)object;
                        Iterable $this$any$iv = status.getUniques();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                Unique it = (Unique)element$iv;
                                boolean bl4 = false;
                                if (!(it.getType() == UniqueType.NotShownOnWorldScreen)) continue;
                                bl3 = true;
                                break block9;
                            }
                            bl3 = false;
                        }
                    }
                    if (bl3) continue;
                    Group group = ImageGetter.getPromotionPortrait$default(ImageGetter.INSTANCE, status.getName(), 0.0f, 2, null);
                    IconCircleGroup turnsLeft = Scene2dExtensionsKt.surroundWithCircle$default(Scene2dExtensionsKt.toLabel$default("" + status.getTurnsLeft() + '\u23f3', null, 8, 0, false, 13, null), 15.0f, false, ImageGetter.INSTANCE.getCHARCOAL(), null, 10, null);
                    group.addActor(turnsLeft);
                    turnsLeft.setPosition(group.getWidth(), 0.0f, 20);
                    $this$updateWhenNeeded_u24lambda_u2411_u24lambda_u2410.getPromotionsTable$core().add((Actor)group).padBottom(2.0f);
                }
                ActivationExtensionsKt.onClick($this$updateWhenNeeded_u24lambda_u2411_u24lambda_u2410.getPromotionsTable$core(), () -> UnitPresenter.updateWhenNeeded$lambda$11$lambda$10$lambda$8($this$updateWhenNeeded_u24lambda_u2411_u24lambda_u2410, unit));
                ActivationExtensionsKt.onClick($this$updateWhenNeeded_u24lambda_u2411_u24lambda_u2410.getUnitIconHolder$core(), () -> UnitPresenter.updateWhenNeeded$lambda$11$lambda$10$lambda$9($this$updateWhenNeeded_u24lambda_u2411_u24lambda_u2410, unit));
            } else {
                Iterator<MapUnit> iterator2 = this.selectedUnits.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
                Iterator<MapUnit> iterator4 = iterator2;
                while (iterator4.hasNext()) {
                    MapUnit selectedUnit;
                    Intrinsics.checkNotNullExpressionValue(iterator4.next(), "next(...)");
                    this.unitTable.getUnitIconHolder$core().add((Actor)new UnitIconGroup(selectedUnit, 30.0f)).pad(5.0f);
                }
            }
        }
    }

    private final String buildNameLabelText(MapUnit unit) {
        String nameLabelText = TranslationsKt.tr$default(unit.displayName(), true, false, 2, null);
        if (unit.getHealth() < 100) {
            nameLabelText = nameLabelText + " (" + TranslationsKt.tr(unit.getHealth()) + ')';
        }
        return nameLabelText;
    }

    @Override
    public boolean shouldBeShown() {
        return UnitTable.Presenter.super.shouldBeShown();
    }

    private static final Unit update$lambda$6$lambda$4$lambda$1$lambda$0(UnitTable $this_with, UnitPresenter this$0, MapUnit $unit) {
        $this_with.getUnitNameLabel$core().setText(this$0.buildNameLabelText($unit));
        $this_with.setShouldUpdate(true);
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$6$lambda$4$lambda$1(UnitTable $this_with, MapUnit $unit, UnitPresenter this$0) {
        if (!$this_with.getWorldScreen().getCanChangeState()) {
            return Unit.INSTANCE;
        }
        new UnitRenamePopup($this_with.getWorldScreen(), $unit, () -> UnitPresenter.update$lambda$6$lambda$4$lambda$1$lambda$0($this_with, this$0, $unit));
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$6$lambda$4$lambda$3$lambda$2(UnitTable $this_with, MapUnit $unit) {
        if ($this_with.getSelectedUnit() == null) {
            return Unit.INSTANCE;
        }
        $this_with.getWorldScreen().getGame().pushScreen(new PromotionPickerScreen($unit, false, null, 6, null));
        return Unit.INSTANCE;
    }

    private static final Unit updateWhenNeeded$lambda$11$lambda$10$lambda$8(UnitTable $this_with, MapUnit $unit) {
        if ($this_with.getSelectedUnit() == null || $this_with.getPromotionsTable$core().getChildren().isEmpty()) {
            return Unit.INSTANCE;
        }
        $this_with.getWorldScreen().getGame().pushScreen(new PromotionPickerScreen($unit, false, null, 6, null));
        return Unit.INSTANCE;
    }

    private static final Unit updateWhenNeeded$lambda$11$lambda$10$lambda$9(UnitTable $this_with, MapUnit $unit) {
        $this_with.getWorldScreen().openCivilopedia($unit.getBaseUnit().makeLink());
        return Unit.INSTANCE;
    }
}

