/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.unit;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.city.City;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Spy;
import com.unciv.models.skins.SkinStrings;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.images.IconTextButtonKt;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.unit.IdleUnitButton;
import com.unciv.ui.screens.worldscreen.unit.presenter.CityPresenter;
import com.unciv.ui.screens.worldscreen.unit.presenter.SpyPresenter;
import com.unciv.ui.screens.worldscreen.unit.presenter.SummaryPresenter;
import com.unciv.ui.screens.worldscreen.unit.presenter.UnitPresenter;
import com.unciv.ui.screens.worldscreen.worldmap.WorldMapHolder;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001[B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010M\u001a\u00020N2\n\b\u0002\u0010O\u001a\u0004\u0018\u0001012\b\b\u0002\u0010P\u001a\u00020)J\u0010\u0010Q\u001a\u00020N2\b\u0010R\u001a\u0004\u0018\u000109J\u000e\u0010S\u001a\u00020)2\u0006\u0010T\u001a\u000205J\u0006\u0010U\u001a\u00020NJ\b\u0010V\u001a\u00020NH\u0002J\u001a\u0010W\u001a\u00020N2\u0006\u0010X\u001a\u00020Y2\n\b\u0002\u0010Z\u001a\u0004\u0018\u000101R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0014\u0010\u0014\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u0014\u0010\u0016\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u0014\u0010\u0018\u001a\u00020\u0019X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u0019X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u000e\u0010.\u001a\u00020/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u00100\u001a\u0004\u0018\u0001018F\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0013\u00104\u001a\u0004\u0018\u0001058F\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0013\u00108\u001a\u0004\u0018\u0001098F\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0017\u0010<\u001a\b\u0012\u0004\u0012\u0002010=8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R$\u0010A\u001a\u00020)2\u0006\u0010@\u001a\u00020)8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bB\u0010+\"\u0004\bC\u0010-R$\u0010D\u001a\u00020)2\u0006\u0010@\u001a\u00020)8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bE\u0010+\"\u0004\bF\u0010-R$\u0010H\u001a\u00020G2\u0006\u0010@\u001a\u00020G8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bI\u0010J\"\u0004\bK\u0010L\u00a8\u0006\\"}, d2={"Lcom/unciv/ui/screens/worldscreen/unit/UnitTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "<init>", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;)V", "getWorldScreen", "()Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "prevIdleUnitButton", "Lcom/unciv/ui/screens/worldscreen/unit/IdleUnitButton;", "nextIdleUnitButton", "unitIconHolder", "getUnitIconHolder$core", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "unitNameLabel", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "getUnitNameLabel$core", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "unitIconNameGroup", "getUnitIconNameGroup$core", "promotionsTable", "getPromotionsTable$core", "descriptionTable", "getDescriptionTable$core", "closeButton", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "getCloseButton$core", "()Lcom/badlogic/gdx/scenes/scene2d/Actor;", "separator", "getSeparator$core", "presenter", "Lcom/unciv/ui/screens/worldscreen/unit/UnitTable$Presenter;", "unitPresenter", "Lcom/unciv/ui/screens/worldscreen/unit/presenter/UnitPresenter;", "cityPresenter", "Lcom/unciv/ui/screens/worldscreen/unit/presenter/CityPresenter;", "spyPresenter", "Lcom/unciv/ui/screens/worldscreen/unit/presenter/SpyPresenter;", "summaryPresenter", "Lcom/unciv/ui/screens/worldscreen/unit/presenter/SummaryPresenter;", "shouldUpdate", "", "getShouldUpdate", "()Z", "setShouldUpdate", "(Z)V", "bg", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "selectedUnit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "getSelectedUnit", "()Lcom/unciv/logic/map/mapunit/MapUnit;", "selectedCity", "Lcom/unciv/logic/city/City;", "getSelectedCity", "()Lcom/unciv/logic/city/City;", "selectedSpy", "Lcom/unciv/models/Spy;", "getSelectedSpy", "()Lcom/unciv/models/Spy;", "selectedUnits", "", "getSelectedUnits", "()Ljava/util/List;", "value", "selectedUnitIsSwapping", "getSelectedUnitIsSwapping", "setSelectedUnitIsSwapping", "selectedUnitIsConnectingRoad", "getSelectedUnitIsConnectingRoad", "setSelectedUnitIsConnectingRoad", "", "nameLabelText", "getNameLabelText", "()Ljava/lang/String;", "setNameLabelText", "(Ljava/lang/String;)V", "selectUnit", "", "unit", "append", "selectSpy", "spy", "citySelected", "city", "update", "resetUnitTable", "tileSelected", "selectedTile", "Lcom/unciv/logic/map/tile/Tile;", "forceSelectUnit", "Presenter", "core"})
@SourceDebugExtension(value={"SMAP\nUnitTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitTable.kt\ncom/unciv/ui/screens/worldscreen/unit/UnitTable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,283:1\n1#2:284\n*E\n"})
public final class UnitTable
extends Table {
    @NotNull
    private final WorldScreen worldScreen;
    @NotNull
    private final IdleUnitButton prevIdleUnitButton;
    @NotNull
    private final IdleUnitButton nextIdleUnitButton;
    @NotNull
    private final Table unitIconHolder;
    @NotNull
    private final Label unitNameLabel;
    @NotNull
    private final Table unitIconNameGroup;
    @NotNull
    private final Table promotionsTable;
    @NotNull
    private final Table descriptionTable;
    @NotNull
    private final Actor closeButton;
    @NotNull
    private final Actor separator;
    @NotNull
    private Presenter presenter;
    @NotNull
    private final UnitPresenter unitPresenter;
    @NotNull
    private final CityPresenter cityPresenter;
    @NotNull
    private final SpyPresenter spyPresenter;
    @NotNull
    private final SummaryPresenter summaryPresenter;
    private boolean shouldUpdate;
    @NotNull
    private Image bg;

    /*
     * WARNING - void declaration
     */
    public UnitTable(@NotNull WorldScreen worldScreen) {
        void $this$_init__u24lambda_u249;
        Table table2;
        Actor $this$promotionsTable_u24lambda_u241;
        Actor $this$unitNameLabel_u24lambda_u240;
        Actor actor;
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        this.worldScreen = worldScreen;
        this.prevIdleUnitButton = new IdleUnitButton(this, this.worldScreen.getMapHolder(), true, KeyboardBinding.PrevIdleButton);
        this.nextIdleUnitButton = new IdleUnitButton(this, this.worldScreen.getMapHolder(), false, KeyboardBinding.NextIdleButton);
        this.unitIconHolder = new Table();
        Label label = actor = Scene2dExtensionsKt.toLabel$default("", null, 24, 0, false, 13, null);
        UnitTable unitTable = this;
        boolean bl = false;
        $this$unitNameLabel_u24lambda_u240.setAlignment(1);
        unitTable.unitNameLabel = actor;
        this.unitIconNameGroup = new Table();
        $this$unitNameLabel_u24lambda_u240 = actor = new Table();
        unitTable = this;
        boolean bl2 = false;
        ((Table)$this$promotionsTable_u24lambda_u241).defaults().padRight(5.0f);
        unitTable.promotionsTable = actor;
        this.descriptionTable = new Table(BaseScreen.Companion.getSkin());
        this.unitPresenter = new UnitPresenter(this, this.worldScreen);
        this.cityPresenter = new CityPresenter(this, this.unitPresenter);
        this.spyPresenter = new SpyPresenter(this);
        this.summaryPresenter = new SummaryPresenter(this);
        this.bg = new Image(BaseScreen.Companion.getSkinStrings().getUiBackground("WorldScreen/UnitTable", BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleMidShape(), Scene2dExtensionsKt.darken(BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor(), 0.5f)));
        this.presenter = this.summaryPresenter;
        this.pad(5.0f);
        this.setTouchable(Touchable.enabled);
        this.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "WorldScreen/UnitTable", BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleMidShape(), null, 4, null));
        this.addActor(this.bg);
        this.promotionsTable.setTouchable(Touchable.enabled);
        this.closeButton = Scene2dExtensionsKt.addRoundCloseButton(this, () -> UnitTable._init_$lambda$5(this));
        ActivationExtensionsKt.getKeyShortcuts(this.closeButton).clear();
        $this$promotionsTable_u24lambda_u241 = actor = new Table();
        unitTable = this;
        boolean bl3 = false;
        Table $this$lambda_u249_u24lambda_u246 = table2 = new Table();
        boolean bl4 = false;
        $this$lambda_u249_u24lambda_u246.add((Actor)this.prevIdleUnitButton);
        this.unitIconNameGroup.add((Actor)this.unitIconHolder);
        Cell<Actor> cell = this.unitIconNameGroup.add((Actor)this.unitNameLabel);
        Intrinsics.checkNotNullExpressionValue(cell, "add(...)");
        IconTextButtonKt.padTopDescent(cell);
        this.unitIconHolder.setTouchable(Touchable.enabled);
        this.unitNameLabel.setTouchable(Touchable.enabled);
        $this$lambda_u249_u24lambda_u246.add((Actor)this.unitIconNameGroup);
        $this$lambda_u249_u24lambda_u246.add((Actor)this.nextIdleUnitButton);
        Table moveBetweenUnitsTable = table2;
        $this$_init__u24lambda_u249.add((Actor)moveBetweenUnitsTable).fill().row();
        Object t = Scene2dExtensionsKt.addSeparator$default((Table)$this$_init__u24lambda_u249, null, 0, 0.0f, 7, null).padBottom(5.0f).getActor();
        Intrinsics.checkNotNull(t);
        this.separator = t;
        $this$_init__u24lambda_u249.add((Actor)this.promotionsTable).row();
        $this$_init__u24lambda_u249.add((Actor)this.descriptionTable);
        $this$_init__u24lambda_u249.setTouchable(Touchable.enabled);
        ActivationExtensionsKt.onClick((Actor)$this$_init__u24lambda_u249, () -> UnitTable.lambda$9$lambda$8(this));
        unitTable.add((Actor)actor).expand();
    }

    @NotNull
    public final WorldScreen getWorldScreen() {
        return this.worldScreen;
    }

    @NotNull
    public final Table getUnitIconHolder$core() {
        return this.unitIconHolder;
    }

    @NotNull
    public final Label getUnitNameLabel$core() {
        return this.unitNameLabel;
    }

    @NotNull
    public final Table getUnitIconNameGroup$core() {
        return this.unitIconNameGroup;
    }

    @NotNull
    public final Table getPromotionsTable$core() {
        return this.promotionsTable;
    }

    @NotNull
    public final Table getDescriptionTable$core() {
        return this.descriptionTable;
    }

    @NotNull
    public final Actor getCloseButton$core() {
        return this.closeButton;
    }

    @NotNull
    public final Actor getSeparator$core() {
        return this.separator;
    }

    public final boolean getShouldUpdate() {
        return this.shouldUpdate;
    }

    public final void setShouldUpdate(boolean bl) {
        this.shouldUpdate = bl;
    }

    @Nullable
    public final MapUnit getSelectedUnit() {
        Presenter it = this.presenter;
        boolean bl = false;
        return it instanceof UnitPresenter ? ((UnitPresenter)it).getSelectedUnit() : null;
    }

    @Nullable
    public final City getSelectedCity() {
        Presenter it = this.presenter;
        boolean bl = false;
        return it instanceof CityPresenter ? ((CityPresenter)it).getSelectedCity() : null;
    }

    @Nullable
    public final Spy getSelectedSpy() {
        Presenter it = this.presenter;
        boolean bl = false;
        return it instanceof SpyPresenter ? ((SpyPresenter)it).getSelectedSpy() : null;
    }

    @NotNull
    public final List<MapUnit> getSelectedUnits() {
        return this.unitPresenter.getSelectedUnits();
    }

    public final boolean getSelectedUnitIsSwapping() {
        return this.unitPresenter.getSelectedUnitIsSwapping();
    }

    public final void setSelectedUnitIsSwapping(boolean value) {
        this.unitPresenter.setSelectedUnitIsSwapping(value);
    }

    public final boolean getSelectedUnitIsConnectingRoad() {
        return this.unitPresenter.getSelectedUnitIsConnectingRoad();
    }

    public final void setSelectedUnitIsConnectingRoad(boolean value) {
        this.unitPresenter.setSelectedUnitIsConnectingRoad(value);
    }

    @NotNull
    public final String getNameLabelText() {
        String string = this.unitNameLabel.getText().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    public final void setNameLabelText(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        if (!Intrinsics.areEqual(this.getNameLabelText(), value)) {
            this.unitNameLabel.setText(value);
            this.shouldUpdate = true;
        }
    }

    public final void selectUnit(@Nullable MapUnit unit, boolean append2) {
        this.presenter = unit != null ? (Presenter)this.unitPresenter : (Presenter)this.summaryPresenter;
        this.unitPresenter.selectUnit(unit, append2);
        this.resetUnitTable();
    }

    public static /* synthetic */ void selectUnit$default(UnitTable unitTable, MapUnit mapUnit, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            mapUnit = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        unitTable.selectUnit(mapUnit, bl);
    }

    public final void selectSpy(@Nullable Spy spy) {
        this.presenter = this.spyPresenter;
        this.spyPresenter.selectSpy(spy);
        this.resetUnitTable();
    }

    public final boolean citySelected(@NotNull City city) {
        boolean bl;
        Intrinsics.checkNotNullParameter(city, "city");
        this.presenter = this.cityPresenter;
        boolean it = bl = this.cityPresenter.selectCity(city);
        boolean bl2 = false;
        this.resetUnitTable();
        this.worldScreen.setShouldUpdate(true);
        return bl;
    }

    public final void update() {
        this.closeButton.setVisible(true);
        if (!this.presenter.shouldBeShown()) {
        }
        this.presenter.update();
        if (SequencesKt.any(this.worldScreen.getViewingCiv().getUnits().getIdleUnits())) {
            this.prevIdleUnitButton.enable();
            this.nextIdleUnitButton.enable();
        } else {
            this.prevIdleUnitButton.disable();
            this.nextIdleUnitButton.disable();
        }
        if (!this.shouldUpdate) {
            return;
        }
        this.resetUnitTable();
        this.presenter.updateWhenNeeded();
        this.pack();
        this.closeButton.setPosition(this.getWidth() - this.closeButton.getWidth() * (float)3 / (float)4, this.getHeight() - this.closeButton.getHeight() * (float)3 / (float)4);
        this.closeButton.toFront();
        this.bg.setSize(this.getWidth() - 3.0f, this.getHeight() - 3.0f);
        Scene2dExtensionsKt.center((Actor)this.bg, this);
        this.shouldUpdate = false;
    }

    private final void resetUnitTable() {
        this.unitIconHolder.clear();
        this.promotionsTable.clear();
        this.descriptionTable.clearListeners();
        this.separator.setWidth(0.0f);
        this.shouldUpdate = true;
    }

    public final void tileSelected(@NotNull Tile selectedTile, @Nullable MapUnit forceSelectUnit) {
        Intrinsics.checkNotNullParameter(selectedTile, "selectedTile");
        MapUnit previouslySelectedUnit = this.getSelectedUnit();
        int previousNumberOfSelectedUnits = this.getSelectedUnits().size();
        if (this.getSelectedUnitIsSwapping() && this.getSelectedUnit() != null) {
            MapUnit mapUnit = this.getSelectedUnit();
            Intrinsics.checkNotNull(mapUnit);
            if (mapUnit.getMovement().canUnitSwapTo(selectedTile)) {
                return;
            }
        }
        if (this.getSelectedUnit() != null) {
            MapUnit mapUnit = this.getSelectedUnit();
            Intrinsics.checkNotNull(mapUnit);
            if (mapUnit.isPreparingAirSweep()) {
                return;
            }
        }
        MapUnit civUnit = selectedTile.getCivilianUnit();
        MapUnit milUnit = selectedTile.getMilitaryUnit();
        MapUnit curUnit = this.getSelectedUnit();
        MapUnit nextUnit = null;
        MapUnit priorityUnit = milUnit != null && UnitTable.tileSelected$isEligible(milUnit, this) ? milUnit : (civUnit != null && UnitTable.tileSelected$isEligible(civUnit, this) ? civUnit : null);
        nextUnit = curUnit == null ? priorityUnit : (Intrinsics.areEqual(curUnit, civUnit) && milUnit != null && UnitTable.tileSelected$isEligible(milUnit, this) ? null : (Intrinsics.areEqual(curUnit, milUnit) && civUnit != null && UnitTable.tileSelected$isEligible(civUnit, this) ? civUnit : priorityUnit));
        boolean isCitySelected = selectedTile.isCityCenter() && (Intrinsics.areEqual(selectedTile.getOwner(), this.worldScreen.getViewingCiv()) || this.worldScreen.getViewingCiv().isSpectator()) && !this.getSelectedUnitIsConnectingRoad();
        MapUnit mapUnit = forceSelectUnit;
        if (mapUnit != null) {
            UnitTable.selectUnit$default(this, mapUnit, false, 2, null);
        } else if (isCitySelected) {
            City city = selectedTile.getCity();
            Intrinsics.checkNotNull(city);
            this.citySelected(city);
        } else {
            MapUnit mapUnit2 = nextUnit;
            if (mapUnit2 != null) {
                Input input2 = Gdx.input;
                Intrinsics.checkNotNullExpressionValue(input2, "input");
                this.selectUnit(mapUnit2, Scene2dExtensionsKt.isShiftKeyPressed(input2));
            } else {
                MapUnit mapUnit3 = previouslySelectedUnit;
                if (Intrinsics.areEqual(selectedTile, mapUnit3 != null ? mapUnit3.getCurrentTile() : null)) {
                    UnitTable.selectUnit$default(this, null, false, 3, null);
                    this.shouldUpdate = true;
                }
            }
        }
        if (!Intrinsics.areEqual(this.getSelectedUnit(), previouslySelectedUnit) || this.getSelectedUnits().size() != previousNumberOfSelectedUnits) {
            this.shouldUpdate = true;
        }
    }

    public static /* synthetic */ void tileSelected$default(UnitTable unitTable, Tile tile, MapUnit mapUnit, int n, Object object) {
        if ((n & 2) != 0) {
            mapUnit = null;
        }
        unitTable.tileSelected(tile, mapUnit);
    }

    private static final Unit _init_$lambda$5(UnitTable this$0) {
        UnitTable.selectUnit$default(this$0, null, false, 3, null);
        this$0.worldScreen.setShouldUpdate(true);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$9$lambda$8(UnitTable this$0) {
        block0: {
            Vector2 vector2 = this$0.presenter.getPosition();
            if (vector2 == null) break block0;
            Vector2 it = vector2;
            boolean bl = false;
            WorldMapHolder.setCenterPosition$default(this$0.worldScreen.getMapHolder(), it, false, false, null, 8, null);
        }
        return Unit.INSTANCE;
    }

    private static final boolean tileSelected$isEligible(MapUnit $this$tileSelected_u24isEligible, UnitTable this$0) {
        return (Intrinsics.areEqual($this$tileSelected_u24isEligible.getCiv(), this$0.worldScreen.getViewingCiv()) || this$0.worldScreen.getViewingCiv().isSpectator()) && !this$0.getSelectedUnits().contains($this$tileSelected_u24isEligible);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000b\u00c0\u0006\u0003"}, d2={"Lcom/unciv/ui/screens/worldscreen/unit/UnitTable$Presenter;", "", "position", "Lcom/badlogic/gdx/math/Vector2;", "getPosition", "()Lcom/badlogic/gdx/math/Vector2;", "update", "", "updateWhenNeeded", "shouldBeShown", "", "core"})
    public static interface Presenter {
        @Nullable
        public Vector2 getPosition();

        default public void update() {
        }

        default public void updateWhenNeeded() {
        }

        default public boolean shouldBeShown() {
            return true;
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @Deprecated
            public static void update(@NotNull Presenter $this) {
                $this.update();
            }

            @Deprecated
            public static void updateWhenNeeded(@NotNull Presenter $this) {
                $this.updateWhenNeeded();
            }

            @Deprecated
            public static boolean shouldBeShown(@NotNull Presenter $this) {
                return $this.shouldBeShown();
            }
        }
    }
}

