/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.status;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.automation.civilization.NextTurnAutomation;
import com.unciv.logic.automation.unit.UnitAutomation;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.managers.TurnManager;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.popups.AnimatedMenuPopup;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.status.NextTurnButton;
import com.unciv.ui.screens.worldscreen.unit.AutoPlay;
import java.util.Comparator;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0002J\b\u0010\u0015\u001a\u00020\u0011H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/unciv/ui/screens/worldscreen/status/AutoPlayMenu;", "Lcom/unciv/ui/popups/AnimatedMenuPopup;", "stage", "Lcom/badlogic/gdx/scenes/scene2d/Stage;", "positionNextTo", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "nextTurnButton", "Lcom/unciv/ui/screens/worldscreen/status/NextTurnButton;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "<init>", "(Lcom/badlogic/gdx/scenes/scene2d/Stage;Lcom/badlogic/gdx/scenes/scene2d/Actor;Lcom/unciv/ui/screens/worldscreen/status/NextTurnButton;Lcom/unciv/ui/screens/worldscreen/WorldScreen;)V", "autoPlay", "Lcom/unciv/ui/screens/worldscreen/unit/AutoPlay;", "createContentTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "autoPlayEndTurn", "", "multiturnAutoPlay", "autoPlayMilitary", "autoPlayCivilian", "autoPlayEconomy", "core"})
@SourceDebugExtension(value={"SMAP\nAutoPlayMenu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoPlayMenu.kt\ncom/unciv/ui/screens/worldscreen/status/AutoPlayMenu\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,110:1\n608#2:111\n608#2:112\n*S KotlinDebug\n*F\n+ 1 AutoPlayMenu.kt\ncom/unciv/ui/screens/worldscreen/status/AutoPlayMenu\n*L\n70#1:111\n90#1:112\n*E\n"})
public final class AutoPlayMenu
extends AnimatedMenuPopup {
    @NotNull
    private final NextTurnButton nextTurnButton;
    @NotNull
    private final WorldScreen worldScreen;
    @NotNull
    private final AutoPlay autoPlay;

    public AutoPlayMenu(@NotNull Stage stage, @NotNull Actor positionNextTo, @NotNull NextTurnButton nextTurnButton, @NotNull WorldScreen worldScreen) {
        Intrinsics.checkNotNullParameter(stage, "stage");
        Intrinsics.checkNotNullParameter(positionNextTo, "positionNextTo");
        Intrinsics.checkNotNullParameter(nextTurnButton, "nextTurnButton");
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        super(stage, AnimatedMenuPopup.Companion.getActorTopRight(positionNextTo));
        this.nextTurnButton = nextTurnButton;
        this.worldScreen = worldScreen;
        this.autoPlay = this.worldScreen.getAutoPlay();
        this.setAfterCloseCallback(() -> AutoPlayMenu._init_$lambda$0(this));
    }

    @Override
    @NotNull
    public Table createContentTable() {
        Table table2 = super.createContentTable();
        Intrinsics.checkNotNull(table2);
        Table table3 = table2;
        if (!this.worldScreen.getGameInfo().getGameParameters().isOnlineMultiplayer()) {
            table3.add((Actor)this.getButton("Start AutoPlay", KeyboardBinding.AutoPlay, new Function0<Unit>((Object)this){

                public final void invoke() {
                    AutoPlayMenu.access$multiturnAutoPlay((AutoPlayMenu)this.receiver);
                }
            })).row();
        }
        table3.add((Actor)this.getButton("AutoPlay End Turn", KeyboardBinding.AutoPlayMenuEndTurn, new Function0<Unit>((Object)this){

            public final void invoke() {
                AutoPlayMenu.access$autoPlayEndTurn((AutoPlayMenu)this.receiver);
            }
        })).row();
        table3.add((Actor)this.getButton("AutoPlay Military Once", KeyboardBinding.AutoPlayMenuMilitary, new Function0<Unit>((Object)this){

            public final void invoke() {
                AutoPlayMenu.access$autoPlayMilitary((AutoPlayMenu)this.receiver);
            }
        })).row();
        table3.add((Actor)this.getButton("AutoPlay Civilians Once", KeyboardBinding.AutoPlayMenuCivilians, new Function0<Unit>((Object)this){

            public final void invoke() {
                AutoPlayMenu.access$autoPlayCivilian((AutoPlayMenu)this.receiver);
            }
        })).row();
        table3.add((Actor)this.getButton("AutoPlay Economy Once", KeyboardBinding.AutoPlayMenuEconomy, new Function0<Unit>((Object)this){

            public final void invoke() {
                AutoPlayMenu.access$autoPlayEconomy((AutoPlayMenu)this.receiver);
            }
        })).row();
        return table3;
    }

    private final void autoPlayEndTurn() {
        Function0<Unit> endTurnFunction = () -> AutoPlayMenu.autoPlayEndTurn$lambda$1(this);
        if (this.worldScreen.getViewingCiv().getUnits().getCivUnitsSize() + this.worldScreen.getViewingCiv().getCities().size() >= 30) {
            this.autoPlay.runAutoPlayJobInNewThread("AutoPlayEndTurn", this.worldScreen, false, endTurnFunction);
        } else {
            this.autoPlay.setAutoPlayTurnInProgress(true);
            endTurnFunction.invoke();
        }
    }

    private final void multiturnAutoPlay() {
        this.worldScreen.getAutoPlay().startMultiturnAutoPlay();
        this.nextTurnButton.update();
    }

    private final void autoPlayMilitary() {
        Civilization civInfo = this.worldScreen.getViewingCiv();
        Function0<Unit> autoPlayMilitaryFunction = () -> AutoPlayMenu.autoPlayMilitary$lambda$4(civInfo, this);
        if (civInfo.getUnits().getCivUnitsSize() > 30) {
            this.autoPlay.runAutoPlayJobInNewThread("AutoPlayMilitary", this.worldScreen, true, autoPlayMilitaryFunction);
        } else {
            this.autoPlay.setAutoPlayTurnInProgress(true);
            autoPlayMilitaryFunction.invoke();
            this.autoPlay.setAutoPlayTurnInProgress(false);
        }
    }

    private final void autoPlayCivilian() {
        Civilization civInfo = this.worldScreen.getViewingCiv();
        Function0<Unit> autoPlayCivilainFunction = () -> AutoPlayMenu.autoPlayCivilian$lambda$7(civInfo, this);
        if (civInfo.getUnits().getCivUnitsSize() > 50) {
            this.autoPlay.runAutoPlayJobInNewThread("AutoPlayCivilian", this.worldScreen, true, autoPlayCivilainFunction);
        } else {
            this.autoPlay.setAutoPlayTurnInProgress(true);
            autoPlayCivilainFunction.invoke();
            this.autoPlay.setAutoPlayTurnInProgress(false);
        }
    }

    private final void autoPlayEconomy() {
        Civilization civInfo = this.worldScreen.getViewingCiv();
        NextTurnAutomation.INSTANCE.automateCities(civInfo);
        this.worldScreen.setShouldUpdate(true);
        this.worldScreen.render(0.0f);
    }

    private static final Unit _init_$lambda$0(AutoPlayMenu this$0) {
        this$0.worldScreen.setShouldUpdate(true);
        return Unit.INSTANCE;
    }

    private static final Unit autoPlayEndTurn$lambda$1(AutoPlayMenu this$0) {
        this$0.nextTurnButton.update();
        new TurnManager(this$0.worldScreen.getViewingCiv()).automateTurn();
        this$0.worldScreen.getAutoPlay().stopAutoPlay();
        this$0.worldScreen.nextTurn();
        return Unit.INSTANCE;
    }

    private static final boolean autoPlayMilitary$lambda$4$lambda$2(MapUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isMilitary();
    }

    private static final Unit autoPlayMilitary$lambda$4(Civilization $civInfo, AutoPlayMenu this$0) {
        boolean isAtWar = $civInfo.isAtWar();
        Sequence<MapUnit> $this$sortedBy$iv = SequencesKt.filter($civInfo.getUnits().getCivUnits(), AutoPlayMenu::autoPlayMilitary$lambda$4$lambda$2);
        boolean $i$f$sortedBy = false;
        Sequence<MapUnit> sortedUnits = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(isAtWar){
            final /* synthetic */ boolean $isAtWar$inlined;
            {
                this.$isAtWar$inlined = bl;
            }

            public final int compare(T a, T b) {
                MapUnit unit = (MapUnit)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(NextTurnAutomation.INSTANCE.getUnitPriority(unit, this.$isAtWar$inlined));
                unit = (MapUnit)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, NextTurnAutomation.INSTANCE.getUnitPriority(unit, this.$isAtWar$inlined));
            }
        });
        Iterator<IsPartOfGameInfoSerialization> iterator2 = sortedUnits.iterator();
        while (iterator2.hasNext()) {
            MapUnit unit = iterator2.next();
            UnitAutomation.INSTANCE.automateUnitMoves(unit);
        }
        for (City city : $civInfo.getCities()) {
            UnitAutomation.INSTANCE.tryBombardEnemy(city);
        }
        this$0.worldScreen.setShouldUpdate(true);
        return Unit.INSTANCE;
    }

    private static final boolean autoPlayCivilian$lambda$7$lambda$5(MapUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isCivilian();
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit autoPlayCivilian$lambda$7(Civilization $civInfo, AutoPlayMenu this$0) {
        void $this$sortedBy$iv;
        boolean isAtWar = $civInfo.isAtWar();
        Object object = SequencesKt.filter($civInfo.getUnits().getCivUnits(), AutoPlayMenu::autoPlayCivilian$lambda$7$lambda$5);
        boolean $i$f$sortedBy = false;
        Sequence sortedUnits = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(isAtWar){
            final /* synthetic */ boolean $isAtWar$inlined;
            {
                this.$isAtWar$inlined = bl;
            }

            public final int compare(T a, T b) {
                MapUnit unit = (MapUnit)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(NextTurnAutomation.INSTANCE.getUnitPriority(unit, this.$isAtWar$inlined));
                unit = (MapUnit)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, NextTurnAutomation.INSTANCE.getUnitPriority(unit, this.$isAtWar$inlined));
            }
        });
        object = sortedUnits.iterator();
        while (object.hasNext()) {
            MapUnit unit = (MapUnit)object.next();
            UnitAutomation.INSTANCE.automateUnitMoves(unit);
        }
        this$0.worldScreen.setShouldUpdate(true);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$multiturnAutoPlay(AutoPlayMenu $this) {
        $this.multiturnAutoPlay();
    }

    public static final /* synthetic */ void access$autoPlayEndTurn(AutoPlayMenu $this) {
        $this.autoPlayEndTurn();
    }

    public static final /* synthetic */ void access$autoPlayMilitary(AutoPlayMenu $this) {
        $this.autoPlayMilitary();
    }

    public static final /* synthetic */ void access$autoPlayCivilian(AutoPlayMenu $this) {
        $this.autoPlayCivilian();
    }

    public static final /* synthetic */ void access$autoPlayEconomy(AutoPlayMenu $this) {
        $this.autoPlayEconomy();
    }
}

