/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.minimap;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.utils.Array;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.ExploredRegion;
import com.unciv.logic.map.MapParameters;
import com.unciv.logic.map.MapSize;
import com.unciv.logic.map.tile.Tile;
import com.unciv.ui.components.NonTransformGroup;
import com.unciv.ui.images.ClippingImage;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.worldscreen.minimap.MinimapTile;
import com.unciv.ui.screens.worldscreen.minimap.MinimapTileUtil;
import com.unciv.ui.screens.worldscreen.minimap.TileLayerGroup;
import com.unciv.ui.screens.worldscreen.worldmap.WorldMapHolder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Pure;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u001bH\u0003J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001b2\b\b\u0002\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011H\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)H\u0002J\u000e\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020\u0007J\u001a\u0010,\u001a\u00020%2\b\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/unciv/ui/screens/worldscreen/minimap/Minimap;", "Lcom/unciv/ui/components/NonTransformGroup;", "mapHolder", "Lcom/unciv/ui/screens/worldscreen/worldmap/WorldMapHolder;", "minimapSize", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "<init>", "(Lcom/unciv/ui/screens/worldscreen/worldmap/WorldMapHolder;ILcom/unciv/logic/civilization/Civilization;)V", "getMapHolder", "()Lcom/unciv/ui/screens/worldscreen/worldmap/WorldMapHolder;", "tileLayer", "Lcom/unciv/ui/screens/worldscreen/minimap/TileLayerGroup;", "borderLayer", "cityLayer", "minimapTiles", "", "Lcom/unciv/ui/screens/worldscreen/minimap/MinimapTile;", "scrollPositionIndicators", "Lcom/unciv/ui/images/ClippingImage;", "lastViewingCiv", "tileSize", "", "tileMapWidth", "tileMapHeight", "calcTileSize", "Lcom/badlogic/gdx/math/Vector2;", "calcMinTileSize", "getClosestMinimapSize", "targetSize", "touchInside", "", "calcMinimapSize", "createScrollPositionIndicators", "createMinimapTiles", "updateScrollPosition", "", "worldWidth", "worldHeight", "worldViewport", "Lcom/badlogic/gdx/math/Rectangle;", "update", "viewingCiv", "draw", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "parentAlpha", "core"})
@SourceDebugExtension(value={"SMAP\nMinimap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Minimap.kt\ncom/unciv/ui/screens/worldscreen/minimap/Minimap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,285:1\n1#2:286\n1869#3,2:287\n*S KotlinDebug\n*F\n+ 1 Minimap.kt\ncom/unciv/ui/screens/worldscreen/minimap/Minimap\n*L\n72#1:287,2\n*E\n"})
public final class Minimap
extends NonTransformGroup {
    @NotNull
    private final WorldMapHolder mapHolder;
    @Nullable
    private final Civilization civInfo;
    @NotNull
    private final TileLayerGroup tileLayer;
    @NotNull
    private final NonTransformGroup borderLayer;
    @NotNull
    private final NonTransformGroup cityLayer;
    @NotNull
    private final List<MinimapTile> minimapTiles;
    @NotNull
    private final List<ClippingImage> scrollPositionIndicators;
    @Nullable
    private Civilization lastViewingCiv;
    private float tileSize;
    private float tileMapWidth;
    private float tileMapHeight;

    public Minimap(@NotNull WorldMapHolder mapHolder, int minimapSize, @Nullable Civilization civInfo) {
        Actor group;
        Intrinsics.checkNotNullParameter(mapHolder, "mapHolder");
        this.mapHolder = mapHolder;
        this.civInfo = civInfo;
        this.tileLayer = new TileLayerGroup();
        this.borderLayer = new NonTransformGroup();
        this.cityLayer = new NonTransformGroup();
        Vector2 stageMinimapSize = this.calcMinimapSize(minimapSize);
        this.setSize(stageMinimapSize.x, stageMinimapSize.y);
        this.tileSize = this.calcTileSize(stageMinimapSize);
        this.minimapTiles = this.createMinimapTiles(this.tileSize);
        Rectangle tileExtension = MinimapTileUtil.INSTANCE.spreadOutMinimapTiles(this.tileLayer, this.minimapTiles, this.tileSize);
        this.tileLayer.setSize(this.getWidth(), this.getHeight());
        this.tileMapWidth = tileExtension.width;
        this.tileMapHeight = tileExtension.height;
        float padX = (stageMinimapSize.x - this.tileMapWidth) * 0.5f - tileExtension.x;
        float padY = (stageMinimapSize.y - this.tileMapHeight) * 0.5f - tileExtension.y;
        Iterator iterator2 = this.tileLayer.getChildren().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iterator3 = iterator2;
        while (((Array.ArrayIterator)iterator3).hasNext()) {
            group = (Actor)((Array.ArrayIterator)iterator3).next();
            group.moveBy(padX, padY);
        }
        this.addActor(this.tileLayer);
        this.addActor(this.borderLayer);
        this.addActor(this.cityLayer);
        Actor $this$_init__u24lambda_u240 = group = new Group();
        boolean bl = false;
        $this$_init__u24lambda_u240.setTouchable(Touchable.disabled);
        Actor scrollIndicatorLayer = group;
        scrollIndicatorLayer.setSize(this.getWidth(), this.getHeight());
        this.scrollPositionIndicators = this.createScrollPositionIndicators();
        Iterable $this$forEach$iv = this.scrollPositionIndicators;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Actor p0 = (Actor)element$iv;
            boolean bl2 = false;
            ((Group)scrollIndicatorLayer).addActor(p0);
        }
        this.addActor(scrollIndicatorLayer);
        this.mapHolder.setOnViewportChangedListener((Function3<? super Float, ? super Float, ? super Rectangle, Unit>)new Function3<Float, Float, Rectangle, Unit>((Object)this){

            @Override
            public final void invoke(float p0, float p1, Rectangle p2) {
                Intrinsics.checkNotNullParameter(p2, "p2");
                ((Minimap)this.receiver).updateScrollPosition(p0, p1, p2);
            }
        });
    }

    @NotNull
    public final WorldMapHolder getMapHolder() {
        return this.mapHolder;
    }

    @Readonly
    private final float calcTileSize(Vector2 minimapSize) {
        float height = 0.0f;
        float width = 0.0f;
        MapParameters mapParameters = this.mapHolder.getTileMap$core().getMapParameters();
        if (this.civInfo != null) {
            height = this.civInfo.getExploredRegion().getHeight();
            width = this.civInfo.getExploredRegion().getWidth();
        } else if (!Intrinsics.areEqual(mapParameters.getShape(), "Rectangular")) {
            float diameter;
            height = diameter = (float)mapParameters.getMapSize().getRadius() * 2.0f + 1.0f;
            width = diameter;
        } else {
            height = mapParameters.getMapSize().getHeight();
            width = mapParameters.getMapSize().getWidth();
        }
        float result2 = Math.min(minimapSize.y / (height + 1.5f) / (float)Math.sqrt(3.0f) * 4.0f, minimapSize.x / (width + 0.5f) / 0.75f);
        return result2;
    }

    private final float calcMinTileSize(int minimapSize) {
        MapParameters $this$calcMinTileSize_u24lambda_u241 = this.mapHolder.getTileMap$core().getMapParameters();
        boolean bl = false;
        int effectiveRadius = !Intrinsics.areEqual($this$calcMinTileSize_u24lambda_u241.getShape(), "Rectangular") ? $this$calcMinTileSize_u24lambda_u241.getMapSize().getRadius() : Math.max($this$calcMinTileSize_u24lambda_u241.getMapSize().getHeight(), $this$calcMinTileSize_u24lambda_u241.getMapSize().getWidth() * 3 / 4) * MapSize.Companion.getHuge().getRadius() / MapSize.Companion.getHuge().getHeight();
        int mapSizePercent = minimapSize < 22 ? minimapSize + 9 : minimapSize * 5 - 75;
        Stage it = this.mapHolder.getWorldScreen$core().getStage();
        boolean bl2 = false;
        float smallerWorldDimension = Math.min(it.getWidth(), it.getHeight());
        return smallerWorldDimension * (float)mapSizePercent / (float)100 / (float)effectiveRadius;
    }

    public final int getClosestMinimapSize(@NotNull Vector2 targetSize, boolean touchInside) {
        Intrinsics.checkNotNullParameter(targetSize, "targetSize");
        int max = 30;
        int size = 0;
        while (true) {
            Vector2 calculatedSize = this.calcMinimapSize(size);
            if (touchInside && (calculatedSize.x > targetSize.x || calculatedSize.y > targetSize.y)) {
                return RangesKt.coerceIn(size - 1, 0, max);
            }
            if (!touchInside && calculatedSize.x > targetSize.x && calculatedSize.y > targetSize.y) {
                return size;
            }
            if (size == max) break;
            ++size;
        }
        return max;
    }

    public static /* synthetic */ int getClosestMinimapSize$default(Minimap minimap, Vector2 vector2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return minimap.getClosestMinimapSize(vector2, bl);
    }

    private final Vector2 calcMinimapSize(int minimapSize) {
        float minimapTileSize = this.calcMinTileSize(minimapSize);
        float height = 0.0f;
        float width = 0.0f;
        MapParameters mapParameters = this.mapHolder.getTileMap$core().getMapParameters();
        if (!Intrinsics.areEqual(mapParameters.getShape(), "Rectangular")) {
            float diameter;
            height = diameter = (float)mapParameters.getMapSize().getRadius() * 2.0f + 1.0f;
            width = diameter;
        } else {
            height = mapParameters.getMapSize().getHeight();
            width = mapParameters.getMapSize().getWidth();
        }
        width = mapParameters.getWorldWrap() ? (width - 1.0f) * minimapTileSize * 0.75f : width * minimapTileSize * 0.75f;
        return new Vector2(width, height *= minimapTileSize * (float)Math.sqrt(3.0f) * 0.5f);
    }

    private final List<ClippingImage> createScrollPositionIndicators() {
        int indicatorAmount = this.mapHolder.getContinuousScrollingX() ? 3 : 1;
        ArrayList<ClippingImage> arrayList = new ArrayList<ClippingImage>(indicatorAmount);
        int n = 0;
        while (n < indicatorAmount) {
            int n2;
            int n3 = n2 = n++;
            ArrayList<ClippingImage> arrayList2 = arrayList;
            boolean bl = false;
            ClippingImage indicator = new ClippingImage(ImageGetter.INSTANCE.getDrawable("OtherIcons/Camera"));
            indicator.setTouchable(Touchable.disabled);
            arrayList2.add(indicator);
        }
        return arrayList;
    }

    private final List<MinimapTile> createMinimapTiles(float tileSize) {
        ArrayList<MinimapTile> tiles = new ArrayList<MinimapTile>();
        float pad = !Intrinsics.areEqual(this.mapHolder.getTileMap$core().getMapParameters().getShape(), "Rectangular") ? (float)this.mapHolder.getTileMap$core().getMapParameters().getMapSize().getRadius() * tileSize * 1.5f : ((float)this.mapHolder.getTileMap$core().getMapParameters().getMapSize().getWidth() - 1.0f) * tileSize * 0.75f;
        float leftSide = this.civInfo != null ? this.civInfo.getExploredRegion().getMinimapLeft(tileSize) : -3.4028235E38f;
        for (Tile tileInfo : this.mapHolder.getTileMap$core().getValues()) {
            IsPartOfGameInfoSerialization isPartOfGameInfoSerialization = this.civInfo;
            if (isPartOfGameInfoSerialization != null && (isPartOfGameInfoSerialization = ((Civilization)isPartOfGameInfoSerialization).getExploredRegion()) != null ? !((ExploredRegion)isPartOfGameInfoSerialization).isPositionInRegion(tileInfo.getPosition()) : false) continue;
            MinimapTile minimapTile = new MinimapTile(tileInfo, tileSize, () -> Minimap.createMinimapTiles$lambda$4(this, tileInfo));
            if (minimapTile.getImage().getX() < leftSide) {
                Image image = minimapTile.getImage();
                image.setX(image.getX() + pad);
            }
            tiles.add(minimapTile);
        }
        return tiles;
    }

    private final void updateScrollPosition(float worldWidth, float worldHeight, Rectangle worldViewport) {
        Rectangle rectangle;
        Rectangle exploredRectangle;
        Vector2 worldToMiniFactor = null;
        Rectangle miniViewport = worldViewport;
        if (this.civInfo != null) {
            if (this.civInfo.getExploredRegion().shouldRecalculateCoords()) {
                this.civInfo.getExploredRegion().calculateStageCoords(worldWidth, worldHeight);
            }
            exploredRectangle = this.civInfo.getExploredRegion().getRectangle();
            worldToMiniFactor = new Vector2(this.tileMapWidth / exploredRectangle.width, this.tileMapHeight / exploredRectangle.height);
            rectangle = miniViewport;
            rectangle.x -= exploredRectangle.x;
            rectangle = miniViewport;
            rectangle.y -= exploredRectangle.y;
        } else {
            worldToMiniFactor = new Vector2(this.tileLayer.getWidth() / worldWidth, this.tileLayer.getHeight() / worldHeight);
        }
        exploredRectangle = miniViewport = Minimap.updateScrollPosition$times(miniViewport, worldToMiniFactor);
        exploredRectangle.x += (this.tileLayer.getWidth() - this.tileMapWidth) * 0.5f;
        exploredRectangle = miniViewport;
        exploredRectangle.y += (this.tileLayer.getHeight() - this.tileMapHeight) * 0.5f;
        Minimap.updateScrollPosition$setViewport(this.scrollPositionIndicators.get(0), miniViewport);
        if (this.scrollPositionIndicators.size() != 1) {
            float offset = worldWidth * worldToMiniFactor.x;
            rectangle = miniViewport;
            rectangle.x -= offset;
            Minimap.updateScrollPosition$setViewport(this.scrollPositionIndicators.get(1), miniViewport);
            rectangle = miniViewport;
            rectangle.x += offset * 2.0f;
            Minimap.updateScrollPosition$setViewport(this.scrollPositionIndicators.get(2), miniViewport);
        }
    }

    public final void update(@NotNull Civilization viewingCiv) {
        Intrinsics.checkNotNullParameter(viewingCiv, "viewingCiv");
        for (MinimapTile minimapTile : this.minimapTiles) {
            boolean revealStatusChanged;
            boolean ownerChanged;
            Tile tileInfo = minimapTile.getTile();
            boolean bl = ownerChanged = !Intrinsics.areEqual(minimapTile.getOwningCiv(), tileInfo.getOwner());
            if (ownerChanged) {
                minimapTile.setOwningCiv(tileInfo.getOwner());
            }
            boolean shouldBeUnrevealed = !viewingCiv.hasExplored(tileInfo) && !viewingCiv.isSpectator();
            boolean bl2 = revealStatusChanged = minimapTile.isUnrevealed() != shouldBeUnrevealed;
            if (revealStatusChanged || ownerChanged) {
                MinimapTile.updateColor$default(minimapTile, shouldBeUnrevealed, null, 2, null);
            }
            if (shouldBeUnrevealed || !ownerChanged) continue;
            if (tileInfo.isCityCenter()) {
                MinimapTile.updateCityCircle$default(minimapTile, null, 1, null).updateActorsIn(this.cityLayer);
            }
            MinimapTile.updateBorders$default(minimapTile, null, 1, null).updateActorsIn(this.borderLayer);
        }
        this.lastViewingCiv = viewingCiv;
    }

    @Override
    public void draw(@Nullable Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
    }

    private static final Unit createMinimapTiles$lambda$4(Minimap this$0, Tile $tileInfo) {
        WorldMapHolder.setCenterPosition$default(this$0.mapHolder, $tileInfo.getPosition(), false, false, null, 14, null);
        return Unit.INSTANCE;
    }

    @Pure
    private static final Rectangle updateScrollPosition$times(Rectangle $this$updateScrollPosition_u24times, Vector2 other) {
        Intrinsics.checkNotNullParameter($this$updateScrollPosition_u24times, "<this>");
        return new Rectangle($this$updateScrollPosition_u24times.x * other.x, $this$updateScrollPosition_u24times.y * other.y, $this$updateScrollPosition_u24times.width * other.x, $this$updateScrollPosition_u24times.height * other.y);
    }

    private static final void updateScrollPosition$setViewport(Actor $this$updateScrollPosition_u24setViewport, Rectangle rect) {
        $this$updateScrollPosition_u24setViewport.setX(rect.x);
        $this$updateScrollPosition_u24setViewport.setY(rect.y);
        $this$updateScrollPosition_u24setViewport.setWidth(rect.width);
        $this$updateScrollPosition_u24setViewport.setHeight(rect.height);
    }
}

