/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.mainmenu;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.unciv.UncivGame;
import com.unciv.models.metadata.GameSettings;
import com.unciv.models.skins.SkinStrings;
import com.unciv.ui.audio.MusicController;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.fonts.Fonts;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.ExpanderTab;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.options.SoundTabKt;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0013\u001a\u00020\u0014*\u00020\u000e2\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u000bH\u0002J\u001e\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000e2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002J\u001a\u0010!\u001a\u00020\u0018*\u00020\"2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\u0011j\b\u0012\u0004\u0012\u00020\u000e`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/unciv/ui/screens/worldscreen/mainmenu/WorldScreenMusicPopup;", "Lcom/unciv/ui/popups/Popup;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "<init>", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;)V", "musicController", "Lcom/unciv/ui/audio/MusicController;", "trackStyle", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton$TextButtonStyle;", "historyExpander", "Lcom/unciv/ui/components/widgets/ExpanderTab;", "visualMods", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "mods", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "toSmallUntranslatedButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "rightSide", "", "addMusicMods", "", "settings", "Lcom/unciv/models/metadata/GameSettings;", "addHistory", "addTrackList", "title", "tracks", "Lkotlin/sequences/Sequence;", "Lcom/unciv/ui/audio/MusicController$MusicTrackInfo;", "updateTrackList", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nWorldScreenMusicPopup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldScreenMusicPopup.kt\ncom/unciv/ui/screens/worldscreen/mainmenu/WorldScreenMusicPopup\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n996#2:125\n1025#2,3:126\n1028#2,3:136\n382#3,7:129\n1#4:139\n*S KotlinDebug\n*F\n+ 1 WorldScreenMusicPopup.kt\ncom/unciv/ui/screens/worldscreen/mainmenu/WorldScreenMusicPopup\n*L\n80#1:125\n80#1:126,3\n80#1:136,3\n80#1:129,7\n*E\n"})
public final class WorldScreenMusicPopup
extends Popup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MusicController musicController;
    @NotNull
    private final TextButton.TextButtonStyle trackStyle;
    @NotNull
    private final ExpanderTab historyExpander;
    @NotNull
    private final HashSet<String> visualMods;
    @NotNull
    private final LinkedHashSet<String> mods;

    public WorldScreenMusicPopup(@NotNull WorldScreen worldScreen) {
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        super(worldScreen, null, WorldScreenMusicPopup.Companion.calcSize(worldScreen), 2, null);
        this.musicController = UncivGame.Companion.getCurrent().getMusicController();
        this.visualMods = worldScreen.getGame().getSettings().getVisualMods();
        this.mods = worldScreen.getGameInfo().getGameParameters().getMods();
        GameSettings settings = UncivGame.Companion.getCurrent().getSettings();
        ScrollPane scrollPane = this.getScrollPane();
        Intrinsics.checkNotNull(scrollPane);
        scrollPane.setScrollingDisabled(true, false);
        this.defaults().fillX();
        SkinStrings sk = BaseScreen.Companion.getSkinStrings();
        NinePatchDrawable up = SkinStrings.getUiBackground$default(sk, "WorldScreenMusicPopup/TrackList/Up", null, this.getSkin().getColor("color"), 2, null);
        NinePatchDrawable down = SkinStrings.getUiBackground$default(sk, "WorldScreenMusicPopup/TrackList/Down", null, this.getSkin().getColor("positive"), 2, null);
        NinePatchDrawable over = SkinStrings.getUiBackground$default(sk, "WorldScreenMusicPopup/TrackList/Over", null, this.getSkin().getColor("highlight"), 2, null);
        this.trackStyle = new TextButton.TextButtonStyle(up, down, null, Fonts.INSTANCE.getFont());
        this.trackStyle.over = over;
        this.trackStyle.disabled = up;
        this.trackStyle.disabledFontColor = Color.LIGHT_GRAY;
        this.addMusicMods(settings);
        this.historyExpander = this.addHistory();
        SoundTabKt.addMusicControls(this.getBottomTable(), settings, this.musicController);
        Popup.addCloseButton$default(this, null, null, null, null, 15, null).colspan(2);
        this.musicController.onChange(arg_0 -> WorldScreenMusicPopup._init_$lambda$0(this, arg_0));
    }

    private final TextButton toSmallUntranslatedButton(String $this$toSmallUntranslatedButton, boolean rightSide2) {
        TextButton textButton;
        TextButton $this$toSmallUntranslatedButton_u24lambda_u241 = textButton = new TextButton($this$toSmallUntranslatedButton, this.trackStyle);
        boolean bl = false;
        $this$toSmallUntranslatedButton_u24lambda_u241.getLabel().setFontScale(0.14f);
        $this$toSmallUntranslatedButton_u24lambda_u241.getLabel().setAlignment(rightSide2 ? 16 : 8);
        $this$toSmallUntranslatedButton_u24lambda_u241.getLabelCell().pad(5.0f);
        $this$toSmallUntranslatedButton_u24lambda_u241.setDisabled(rightSide2);
        return textButton;
    }

    static /* synthetic */ TextButton toSmallUntranslatedButton$default(WorldScreenMusicPopup worldScreenMusicPopup, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return worldScreenMusicPopup.toSmallUntranslatedButton(string, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void addMusicMods(GameSettings settings) {
        void $this$groupByTo$iv$iv;
        Sequence<MusicController.MusicTrackInfo> $this$groupBy$iv = this.musicController.getAllMusicFileInfo();
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            MusicController.MusicTrackInfo it = (MusicController.MusicTrackInfo)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getMod();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map modsToTracks = destination$iv$iv;
        Collator collator = settings.getCollatorFromLocale();
        Sequence modsSorted = SequencesKt.sortedWith(CollectionsKt.asSequence(modsToTracks.entrySet()), new Comparator(collator){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                Map.Entry entry = (Map.Entry)a;
                Comparator comparator = this.$comparator;
                boolean bl = false;
                Map.Entry it = (Map.Entry)b;
                String string = (String)it.getKey();
                bl = false;
                String string2 = (String)it.getKey();
                return comparator.compare(string, string2);
            }
        });
        object = modsSorted.iterator();
        while (object.hasNext()) {
            CharSequence charSequence;
            Map.Entry entry = (Map.Entry)object.next();
            String modLabel = (String)entry.getKey();
            List trackList = (List)entry.getValue();
            Sequence<MusicController.MusicTrackInfo> tracksSorted = SequencesKt.sortedWith(CollectionsKt.asSequence(trackList), new Comparator(collator){
                final /* synthetic */ Comparator $comparator;
                {
                    this.$comparator = $comparator;
                }

                public final int compare(T a, T b) {
                    MusicController.MusicTrackInfo musicTrackInfo = (MusicController.MusicTrackInfo)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    MusicController.MusicTrackInfo it = (MusicController.MusicTrackInfo)b;
                    String string = it.getTrack();
                    bl = false;
                    String string2 = it.getTrack();
                    return comparator.compare(string, string2);
                }
            });
            WorldScreenMusicPopup worldScreenMusicPopup = this;
            CharSequence charSequence2 = modLabel;
            if (charSequence2.length() == 0) {
                WorldScreenMusicPopup worldScreenMusicPopup2 = worldScreenMusicPopup;
                boolean bl = false;
                charSequence = "\u2014Default\u2014";
                worldScreenMusicPopup = worldScreenMusicPopup2;
            } else {
                charSequence = charSequence2;
            }
            worldScreenMusicPopup.addTrackList((String)charSequence, tracksSorted);
        }
    }

    private final ExpanderTab addHistory() {
        return this.addTrackList("\u2014History\u2014", this.musicController.getHistory());
    }

    private final ExpanderTab addTrackList(String title, Sequence<MusicController.MusicTrackInfo> tracks) {
        Image image;
        String string;
        String string2 = title;
        String string3 = this.mods.contains(string2) ? "OtherIcons/Mods" : (string = this.visualMods.contains(string2) ? "UnitPromotionIcons/Scouting" : null);
        if (string != null) {
            Image image2;
            String it = string;
            boolean bl = false;
            Image $this$addTrackList_u24lambda_u247_u24lambda_u246 = image2 = ImageGetter.getImage$default(ImageGetter.INSTANCE, it, null, 2, null);
            boolean bl2 = false;
            Scene2dExtensionsKt.setSize($this$addTrackList_u24lambda_u247_u24lambda_u246, 18.0f);
            image = image2;
        } else {
            image = null;
        }
        Image icon = image;
        ExpanderTab expander = new ExpanderTab(title, 18, (Actor)icon, false, 0.0f, 0.0f, 5.0f, 0.0f, 0.0f, "MusicPopup." + title, null, null, arg_0 -> WorldScreenMusicPopup.addTrackList$lambda$8(this, tracks, arg_0), 3488, null);
        this.add((Actor)expander).colspan(2).growX().row();
        return expander;
    }

    private final void updateTrackList(Table $this$updateTrackList, Sequence<MusicController.MusicTrackInfo> tracks) {
        Iterator<MusicController.MusicTrackInfo> iterator2 = tracks.iterator();
        while (iterator2.hasNext()) {
            MusicController.MusicTrackInfo entry = iterator2.next();
            TextButton trackLabel = WorldScreenMusicPopup.toSmallUntranslatedButton$default(this, entry.getTrack(), false, 1, null);
            ActivationExtensionsKt.onClick(trackLabel, () -> WorldScreenMusicPopup.updateTrackList$lambda$9(this, entry));
            $this$updateTrackList.add((Actor)trackLabel).fillX();
            $this$updateTrackList.add((Actor)this.toSmallUntranslatedButton(entry.getType(), true)).right().row();
        }
    }

    private static final Unit _init_$lambda$0(WorldScreenMusicPopup this$0, MusicController.MusicTrackInfo it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.historyExpander.getInnerTable().clear();
        this$0.updateTrackList(this$0.historyExpander.getInnerTable(), this$0.musicController.getHistory());
        return Unit.INSTANCE;
    }

    private static final Unit addTrackList$lambda$8(WorldScreenMusicPopup this$0, Sequence $tracks, Table it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.updateTrackList(it, $tracks);
        return Unit.INSTANCE;
    }

    private static final Unit updateTrackList$lambda$9(WorldScreenMusicPopup this$0, MusicController.MusicTrackInfo $entry) {
        this$0.musicController.startTrack($entry);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/screens/worldscreen/mainmenu/WorldScreenMusicPopup$Companion;", "", "<init>", "()V", "calcSize", "", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final float calcSize(WorldScreen worldScreen) {
            float f;
            switch (WhenMappings.$EnumSwitchMapping$0[worldScreen.getGame().getSettings().getScreenSize().ordinal()]) {
                case 1: {
                    f = 0.95f;
                    break;
                }
                case 2: {
                    f = 0.85f;
                    break;
                }
                default: {
                    f = 0.75f;
                }
            }
            return f;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[GameSettings.ScreenSize.values().length];
                try {
                    nArray[GameSettings.ScreenSize.Tiny.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GameSettings.ScreenSize.Small.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

