/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.victoryscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.logic.GameInfo;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.ruleset.Milestone;
import com.unciv.models.ruleset.Victory;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.widgets.TabbedPager;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0001H\u0016R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/unciv/ui/screens/victoryscreen/VictoryScreenOurVictory;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "Lcom/unciv/ui/components/widgets/TabbedPager$IPageExtensions;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "<init>", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;)V", "header", "stageWidth", "", "getColumn", "victory", "Lcom/unciv/models/ruleset/Victory;", "playerCiv", "Lcom/unciv/logic/civilization/Civilization;", "activated", "", "index", "", "caption", "", "pager", "Lcom/unciv/ui/components/widgets/TabbedPager;", "getFixedContent", "core"})
public final class VictoryScreenOurVictory
extends Table
implements TabbedPager.IPageExtensions {
    @NotNull
    private final Table header;
    private final float stageWidth;

    public VictoryScreenOurVictory(@NotNull WorldScreen worldScreen) {
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        super(BaseScreen.Companion.getSkin());
        this.header = new Table();
        this.stageWidth = worldScreen.getStage().getWidth();
        this.align(2);
        GameInfo gameInfo = worldScreen.getGameInfo();
        Map<String, Victory> victoriesToShow = gameInfo.getEnabledVictories();
        this.defaults().pad(10.0f);
        for (Map.Entry<String, Victory> entry : victoriesToShow.entrySet()) {
            String victoryName = entry.getKey();
            Victory victory = entry.getValue();
            this.header.add((Actor)Scene2dExtensionsKt.toLabel('[' + victoryName + "] Victory")).pad(10.0f);
            this.add((Actor)this.getColumn(victory, worldScreen.getViewingCiv())).top();
        }
        this.row();
        for (Victory victory : victoriesToShow.values()) {
            this.add((Actor)Scene2dExtensionsKt.toLabel(victory.getVictoryScreenHeader()));
        }
        Color color = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color, "GRAY");
        Scene2dExtensionsKt.addSeparator$default(this.header, color, 0, 0.0f, 6, null);
    }

    private final Table getColumn(Victory victory, Civilization playerCiv) {
        Table table2 = new Table();
        table2.defaults().space(10.0f);
        boolean firstIncomplete = true;
        for (Milestone milestone : victory.getMilestoneObjects()) {
            Victory.CompletionStatus completionStatus;
            if (milestone.hasBeenCompletedBy(playerCiv)) {
                completionStatus = Victory.CompletionStatus.Completed;
            } else if (firstIncomplete) {
                firstIncomplete = false;
                completionStatus = Victory.CompletionStatus.Partially;
            } else {
                completionStatus = Victory.CompletionStatus.Incomplete;
            }
            Victory.CompletionStatus completionStatus2 = completionStatus;
            for (TextButton button : milestone.getVictoryScreenButtons(completionStatus2, playerCiv)) {
                table2.add((Actor)button).row();
            }
        }
        return table2;
    }

    @Override
    public void activated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        Table[] tableArray = new Table[]{this.header, this};
        Scene2dExtensionsKt.equalizeColumns(tableArray);
    }

    @Override
    @NotNull
    public Table getFixedContent() {
        return this.header;
    }

    @Override
    public void deactivated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        TabbedPager.IPageExtensions.super.deactivated(index, caption, pager);
    }
}

