/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.pickerscreens;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.GUI;
import com.unciv.logic.city.City;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.UnitPromotions;
import com.unciv.models.TutorialTrigger;
import com.unciv.models.UncivSound;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.unit.Promotion;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.audio.SoundPlayer;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.ActorKeyShortcutDispatcher;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.basescreen.RecreateOnResize;
import com.unciv.ui.screens.pickerscreens.PickerScreen;
import com.unciv.ui.screens.pickerscreens.PromotionButton;
import com.unciv.ui.screens.pickerscreens.PromotionScreenColors;
import com.unciv.ui.screens.pickerscreens.PromotionTree;
import com.unciv.ui.screens.pickerscreens.UnitRenamePopup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B3\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\u0004\b\f\u0010\rB-\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\u0004\b\f\u0010\u000eJ\b\u0010)\u001a\u00020*H\u0016J\u0012\u0010+\u001a\u00020\u000b2\b\u0010,\u001a\u0004\u0018\u00010\u001dH\u0002J\b\u0010-\u001a\u00020\u000bH\u0002J\b\u0010.\u001a\u00020\u000bH\u0002J\b\u0010/\u001a\u00020\u000bH\u0002J\u0018\u00100\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'2\u0006\u00101\u001a\u000202H\u0002J\b\u00103\u001a\u00020\u000bH\u0002J\u0016\u00104\u001a\u00020\u000b2\f\u00105\u001a\b\u0012\u0004\u0012\u00020706H\u0002J\u0010\u00108\u001a\u00020\u000b2\u0006\u00109\u001a\u00020\u0017H\u0002J\b\u0010:\u001a\u00020\u000bH\u0002J.\u0010:\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020\u00062\u0006\u0010&\u001a\u00020'2\u0006\u00101\u001a\u0002022\f\u00105\u001a\b\u0012\u0004\u0012\u0002070<H\u0002J\b\u0010=\u001a\u00020>H\u0016J\u000e\u0010=\u001a\u00020>2\u0006\u0010\u0005\u001a\u00020\u0006R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u001b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001d0\u001cj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001d`\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\"0!j\b\u0012\u0004\u0012\u00020\"`#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/unciv/ui/screens/pickerscreens/PromotionPickerScreen;", "Lcom/unciv/ui/screens/pickerscreens/PickerScreen;", "Lcom/unciv/ui/screens/basescreen/RecreateOnResize;", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "closeOnPick", "", "originalName", "", "onChange", "Lkotlin/Function0;", "", "<init>", "(Lcom/unciv/logic/map/mapunit/MapUnit;ZLjava/lang/String;Lkotlin/jvm/functions/Function0;)V", "(Lcom/unciv/logic/map/mapunit/MapUnit;ZLkotlin/jvm/functions/Function0;)V", "getUnit", "()Lcom/unciv/logic/map/mapunit/MapUnit;", "colors", "Lcom/unciv/ui/screens/pickerscreens/PromotionScreenColors;", "kotlin.jvm.PlatformType", "promotedLabelStyle", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label$LabelStyle;", "buttonCellMaxWidth", "", "buttonCellMinWidth", "promotionsTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "promotionToButton", "Ljava/util/LinkedHashMap;", "Lcom/unciv/ui/screens/pickerscreens/PromotionButton;", "Lkotlin/collections/LinkedHashMap;", "selectedPromotion", "lines", "Ljava/util/ArrayList;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "Lkotlin/collections/ArrayList;", "canChangeState", "canPromoteNow", "tree", "Lcom/unciv/ui/screens/pickerscreens/PromotionTree;", "saveUnitPromotion", "getCivilopediaRuleset", "Lcom/unciv/models/ruleset/Ruleset;", "acceptPromotion", "button", "fillTable", "saveUnitPromotionForCity", "checkSaveUnitPromotion", "getButton", "node", "Lcom/unciv/ui/screens/pickerscreens/PromotionTree$PromotionNode;", "addStatuses", "addConnectingLines", "path", "", "Lcom/unciv/models/ruleset/unit/Promotion;", "setScrollY", "scrollY", "updateDescriptionLabel", "isPickable", "", "recreate", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "core"})
@SourceDebugExtension(value={"SMAP\nPromotionPickerScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PromotionPickerScreen.kt\ncom/unciv/ui/screens/pickerscreens/PromotionPickerScreen\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,401:1\n1#2:402\n1056#3:403\n774#3:404\n865#3,2:405\n1056#3:407\n*S KotlinDebug\n*F\n+ 1 PromotionPickerScreen.kt\ncom/unciv/ui/screens/pickerscreens/PromotionPickerScreen\n*L\n259#1:403\n180#1:404\n180#1:405,2\n181#1:407\n*E\n"})
public final class PromotionPickerScreen
extends PickerScreen
implements RecreateOnResize {
    @NotNull
    private final MapUnit unit;
    private final boolean closeOnPick;
    @Nullable
    private final String originalName;
    @Nullable
    private final Function0<Unit> onChange;
    private final PromotionScreenColors colors;
    @NotNull
    private final Label.LabelStyle promotedLabelStyle;
    private final float buttonCellMaxWidth;
    private final float buttonCellMinWidth;
    @NotNull
    private final Table promotionsTable;
    @NotNull
    private final LinkedHashMap<String, PromotionButton> promotionToButton;
    @Nullable
    private PromotionButton selectedPromotion;
    @NotNull
    private ArrayList<Image> lines;
    private final boolean canChangeState;
    private final boolean canPromoteNow;
    @NotNull
    private final PromotionTree tree;
    private boolean saveUnitPromotion;

    private PromotionPickerScreen(MapUnit unit, boolean closeOnPick, String originalName, Function0<Unit> onChange) {
        super(false, 1, null);
        Float f;
        Object object;
        this.unit = unit;
        this.closeOnPick = closeOnPick;
        this.originalName = originalName;
        this.onChange = onChange;
        this.colors = BaseScreen.Companion.getSkin().get(PromotionScreenColors.class);
        Object object2 = object = new Label.LabelStyle(BaseScreen.Companion.getSkin().get(Label.LabelStyle.class));
        PromotionPickerScreen promotionPickerScreen = this;
        boolean bl = false;
        $this$promotedLabelStyle_u24lambda_u240.fontColor = this.colors.getPromotedText();
        promotionPickerScreen.promotedLabelStyle = object;
        this.promotionsTable = new Table();
        this.promotionToButton = new LinkedHashMap();
        this.lines = new ArrayList();
        this.canChangeState = GUI.INSTANCE.isAllowedChangeState();
        this.canPromoteNow = this.canChangeState && this.unit.getPromotions().canBePromoted() && this.unit.hasMovement() && this.unit.getAttacksThisTurn() == 0;
        this.tree = new PromotionTree(this.unit);
        ActivationExtensionsKt.onActivation(this.getCloseButton(), () -> PromotionPickerScreen._init_$lambda$1(this));
        ActivationExtensionsKt.getKeyShortcuts(this.getCloseButton()).add(KeyCharAndCode.Companion.getBACK());
        if (this.canPromoteNow) {
            this.getRightSideButton().setText(TranslationsKt.tr$default("Pick promotion", false, false, 3, null));
            ActivationExtensionsKt.onClick(this.getRightSideButton(), UncivSound.Companion.getSilent(), () -> PromotionPickerScreen._init_$lambda$2(this));
        } else {
            this.getRightSideButton().setVisible(false);
        }
        this.updateDescriptionLabel();
        if (this.canChangeState) {
            TextButton renameButton = Scene2dExtensionsKt.toTextButton$default("Choose name for [" + this.unit.getName() + ']', null, false, 3, null);
            ActivationExtensionsKt.onClick(renameButton, () -> PromotionPickerScreen._init_$lambda$4(this));
            this.getTopTable().add((Actor)renameButton).pad(5.0f).row();
        }
        this.buttonCellMaxWidth = RangesKt.coerceIn((this.getStage().getWidth() - 80.0f) / (float)this.tree.getMaxColumns(), 190.0f, 300.0f);
        object = this.tree.allNodes().iterator();
        while (object.hasNext()) {
            Object e = object.next();
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            PromotionTree.PromotionNode node = (PromotionTree.PromotionNode)e;
            ((Map)this.promotionToButton).put(node.getPromotion().getName(), this.getButton(this.tree, node));
        }
        Collection<PromotionButton> collection = this.promotionToButton.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        object2 = collection;
        promotionPickerScreen = this;
        Iterator iterator2 = object2.iterator();
        if (!iterator2.hasNext()) {
            f = null;
        } else {
            PromotionButton it = (PromotionButton)iterator2.next();
            boolean bl2 = false;
            float f2 = it.getPrefWidth() + 10.0f;
            while (iterator2.hasNext()) {
                PromotionButton it2 = (PromotionButton)iterator2.next();
                $i$a$-maxOfOrNull-PromotionPickerScreen$4 = false;
                float f3 = it2.getPrefWidth() + 10.0f;
                f2 = Math.max(f2, f3);
            }
            f = Float.valueOf(f2);
        }
        promotionPickerScreen.buttonCellMinWidth = RangesKt.coerceIn(f != null ? f.floatValue() : 0.0f, 190.0f, this.buttonCellMaxWidth);
        this.fillTable();
        BaseScreen.displayTutorial$default(this, TutorialTrigger.Experience, null, 2, null);
    }

    @NotNull
    public final MapUnit getUnit() {
        return this.unit;
    }

    public PromotionPickerScreen(@NotNull MapUnit unit, boolean closeOnPick, @Nullable Function0<Unit> onChange) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        this(unit, closeOnPick, unit.getInstanceName(), onChange);
    }

    public /* synthetic */ PromotionPickerScreen(MapUnit mapUnit, boolean bl, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            function0 = null;
        }
        this(mapUnit, bl, function0);
    }

    @Override
    @NotNull
    public Ruleset getCivilopediaRuleset() {
        return this.unit.getCiv().getGameInfo().getRuleset();
    }

    private final void acceptPromotion(PromotionButton button) {
        if (button == null || !button.isPickable()) {
            return;
        }
        List<Promotion> path = this.tree.getPathTo(button.getNode().getPromotion());
        SoundPlayer.playRepeated$default(SoundPlayer.INSTANCE, UncivSound.Companion.getPromote(), RangesKt.coerceAtMost(path.size(), 2), 0L, 4, null);
        for (Promotion promotion : path) {
            UnitPromotions.addPromotion$default(this.unit.getPromotions(), promotion.getName(), false, 2, null);
        }
        Function0<Unit> function0 = this.onChange;
        if (function0 != null) {
            function0.invoke();
        }
        if (!this.closeOnPick || this.unit.getPromotions().canBePromoted()) {
            this.getGame().replaceCurrentScreen(this.recreate(false));
        } else {
            this.getGame().popScreen();
        }
    }

    private final void fillTable() {
        Set placedButtons = new LinkedHashSet();
        int maxColumns = this.tree.getMaxColumns();
        int maxRows = this.tree.getMaxRows();
        int n = maxRows + 1;
        Cell[][] cellArrayArray = new Cell[n][];
        for (int i = 0; i < n; ++i) {
            Cell[] cellArray;
            int n2 = i;
            int n3 = 0;
            int n4 = maxColumns + 1;
            Cell[] cellArray2 = new Cell[n4];
            int n5 = n2;
            Cell[][] cellArrayArray2 = cellArrayArray;
            while (n3 < n4) {
                int n6 = n3++;
                Intrinsics.checkNotNull(this.promotionsTable.add(), "null cannot be cast to non-null type com.badlogic.gdx.scenes.scene2d.ui.Cell<com.badlogic.gdx.scenes.scene2d.Actor?>");
            }
            Cell[] cellArray3 = cellArray = cellArray2;
            boolean bl = false;
            this.promotionsTable.row();
            Unit unit = Unit.INSTANCE;
            cellArrayArray2[n5] = cellArray;
        }
        Cell[][] cellMatrix = cellArrayArray;
        int row = 0;
        Iterator<PromotionTree.PromotionNode> iterator2 = this.tree.allRoots().iterator();
        while (iterator2.hasNext()) {
            PromotionTree.PromotionNode node;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            row = PromotionPickerScreen.fillTable$placeButton(placedButtons, cellMatrix, this, 0, row, node);
            ++row;
        }
        this.getTopTable().add((Actor)this.promotionsTable).row();
        this.saveUnitPromotionForCity();
        if (!((Map)this.unit.getStatusMap()).isEmpty()) {
            this.addStatuses();
        }
        this.addConnectingLines(SetsKt.emptySet());
    }

    private final void saveUnitPromotionForCity() {
        City city = this.unit.getCurrentTile().getCity();
        if (city == null) {
            return;
        }
        City currentCity = city;
        if (!Intrinsics.areEqual(currentCity.getCiv().getCivName(), this.unit.getCiv().getCivName())) {
            return;
        }
        if (currentCity.isPuppet()) {
            return;
        }
        CheckBox checkBoxSaveUnitPromotion = Scene2dExtensionsKt.toCheckBox("Default promotions for [" + this.unit.getBaseUnit().getName() + ']', this.saveUnitPromotion, arg_0 -> PromotionPickerScreen.saveUnitPromotionForCity$lambda$10(this, arg_0));
        this.getTopTable().add((Actor)checkBoxSaveUnitPromotion).left().padTop(10.0f);
    }

    private final void checkSaveUnitPromotion() {
        if (!this.saveUnitPromotion) {
            return;
        }
        City unitCurrentCity = this.unit.getCurrentTile().getCity();
        if (unitCurrentCity != null) {
            ((Map)unitCurrentCity.getUnitShouldUseSavedPromotion()).put(this.unit.getBaseUnit().getName(), true);
            ((Map)unitCurrentCity.getUnitToPromotions()).put(this.unit.getBaseUnit().getName(), this.unit.getPromotions());
        }
    }

    private final PromotionButton getButton(PromotionTree tree, PromotionTree.PromotionNode node) {
        boolean isPickable = this.canPromoteNow && (!node.getPathIsAmbiguous() || node.getDistanceToAdopted() == 1) && tree.canBuyUpTo(node.getPromotion());
        PromotionButton button = new PromotionButton(node, isPickable, this.promotedLabelStyle, this.buttonCellMaxWidth - 60.0f);
        ActivationExtensionsKt.onClick(button, () -> PromotionPickerScreen.getButton$lambda$11(this, button, tree, isPickable, node));
        if (isPickable) {
            ActivationExtensionsKt.onDoubleClick(button, UncivSound.Companion.getSilent(), () -> PromotionPickerScreen.getButton$lambda$12(this, button));
        }
        return button;
    }

    private final void addStatuses() {
        Table table2 = new Table();
        Table $this$addStatuses_u24lambda_u2413 = table2;
        boolean bl = false;
        $this$addStatuses_u24lambda_u2413.defaults().pad(5.0f);
        Table statusTable = table2;
        Collection<MapUnit.UnitStatus> collection = this.unit.getStatusMap().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$sortedBy$iv = collection;
        boolean $i$f$sortedBy = false;
        for (Object e : CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                MapUnit.UnitStatus it = (MapUnit.UnitStatus)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getTurnsLeft());
                it = (MapUnit.UnitStatus)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getTurnsLeft());
            }
        })) {
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            MapUnit.UnitStatus status = (MapUnit.UnitStatus)e;
            TextButton statusButton = Scene2dExtensionsKt.toTextButton$default('{' + status.getName() + "}: " + status.getTurnsLeft() + '\u23f3', null, false, 3, null);
            Promotion promotion = this.unit.getCiv().getGameInfo().getRuleset().getUnitPromotions().get(status.getName());
            String description = TranslationsKt.tr$default('{' + status.getName() + "}: " + status.getTurnsLeft() + "\u23f3\n", false, false, 3, null) + (promotion != null ? promotion.getDescription(SetsKt.emptySet()) : null);
            ActivationExtensionsKt.onClick(statusButton, () -> PromotionPickerScreen.addStatuses$lambda$15(this, description));
            statusTable.add((Actor)statusButton).left().row();
        }
        this.getTopTable().add((Actor)statusTable).row();
    }

    private final void addConnectingLines(Set<Promotion> path) {
        Image line;
        this.promotionsTable.pack();
        this.getScrollPane().updateVisualScroll();
        Iterator<Image> iterator2 = this.lines.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Actor> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            line.remove();
        }
        this.lines.clear();
        for (Actor actor : this.promotionToButton.values()) {
            Intrinsics.checkNotNullExpressionValue(actor, "next(...)");
            PromotionButton button = (PromotionButton)actor;
            PromotionTree.PromotionNode currentNode = button.getNode();
            for (String prerequisite : currentNode.getPromotion().getPrerequisites()) {
                float lineSize;
                PromotionButton prerequisiteButton;
                if (this.promotionToButton.get(prerequisite) == null) continue;
                PromotionTree.PromotionNode prerequisiteNode = prerequisiteButton.getNode();
                Vector2 buttonCoords = new Vector2(0.0f, button.getHeight() / (float)2);
                button.localToStageCoordinates(buttonCoords);
                this.promotionsTable.stageToLocalCoordinates(buttonCoords);
                Vector2 prerequisiteCoords = new Vector2(prerequisiteButton.getWidth(), prerequisiteButton.getHeight() / (float)2);
                prerequisiteButton.localToStageCoordinates(prerequisiteCoords);
                this.promotionsTable.stageToLocalCoordinates(prerequisiteCoords);
                boolean isNodeInPath = path.contains(currentNode.getPromotion());
                boolean isSelectionPath = isNodeInPath && (prerequisiteNode.isAdopted() || path.contains(prerequisiteNode.getPromotion()));
                Color lineColor = isSelectionPath ? this.colors.getSelected() : (isNodeInPath ? this.colors.getPathToSelection() : (Intrinsics.areEqual(prerequisiteNode.getBaseName(), currentNode.getBaseName()) ? this.colors.getGroupLines() : this.colors.getOtherLines()));
                float f = lineSize = isSelectionPath ? 4.0f : 2.0f;
                if (buttonCoords.x < prerequisiteCoords.x) {
                    Vector2 temp = buttonCoords.cpy();
                    buttonCoords = prerequisiteCoords;
                    Intrinsics.checkNotNull(temp);
                    prerequisiteCoords = temp;
                }
                float halfLineSize = lineSize / (float)2;
                if (!(buttonCoords.y == prerequisiteCoords.y)) {
                    float deltaX = buttonCoords.x - prerequisiteCoords.x;
                    float deltaY = buttonCoords.y - prerequisiteCoords.y;
                    float halfLength = deltaX / 2.0f + halfLineSize;
                    float f2 = prerequisiteCoords.x;
                    float f3 = prerequisiteCoords.y - halfLineSize;
                    PromotionPickerScreen.addConnectingLines$addLine(this, f2, f3, halfLength, lineSize, lineColor);
                    f2 = buttonCoords.x - halfLength;
                    f3 = buttonCoords.y - halfLineSize;
                    PromotionPickerScreen.addConnectingLines$addLine(this, f2, f3, halfLength, lineSize, lineColor);
                    f2 = Math.abs(deltaY);
                    f3 = buttonCoords.x - halfLength;
                    float f4 = buttonCoords.y + (deltaY > 0.0f ? -deltaY - halfLineSize : halfLineSize);
                    PromotionPickerScreen.addConnectingLines$addLine(this, f3, f4, lineSize, f2, lineColor);
                    continue;
                }
                float f5 = buttonCoords.x - prerequisiteCoords.x;
                float f6 = prerequisiteCoords.x;
                float f7 = prerequisiteCoords.y - halfLineSize;
                PromotionPickerScreen.addConnectingLines$addLine(this, f6, f7, f5, lineSize, lineColor);
            }
        }
        Iterator<Image> iterator4 = this.lines.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator4, "iterator(...)");
        iterator3 = iterator4;
        while (iterator3.hasNext()) {
            Actor actor = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(actor, "next(...)");
            line = (Image)actor;
            if (!Intrinsics.areEqual(line.getColor(), this.colors.getSelected()) && !Intrinsics.areEqual(line.getColor(), this.colors.getPathToSelection())) continue;
            line.setZIndex(this.lines.size());
        }
    }

    private final void setScrollY(float scrollY) {
        this.getSplitPane().pack();
        this.getScrollPane().setScrollY(scrollY);
        this.getScrollPane().updateVisualScroll();
    }

    private final void updateDescriptionLabel() {
        this.getDescriptionLabel().setText(TranslationsKt.tr$default(this.unit.displayName(), false, false, 3, null));
    }

    private final void updateDescriptionLabel(boolean isPickable, PromotionTree tree, PromotionTree.PromotionNode node, List<Promotion> path) {
        boolean isAmbiguous = node.getPathIsAmbiguous() && node.getDistanceToAdopted() > 1 && tree.canBuyUpTo(node.getPromotion());
        String topLine = TranslationsKt.tr$default(this.unit.displayName(), false, false, 3, null) + (node.isAdopted() ? "" : (isAmbiguous ? TranslationsKt.tr$default(" - {Path to [" + node.getPromotion().getName() + "] is ambiguous}", false, false, 3, null) : (!isPickable ? "" : CollectionsKt.joinToString$default(path, " \u2192 ", ": ", null, 0, null, PromotionPickerScreen::updateDescriptionLabel$lambda$16, 28, null))));
        String promotionText = node.getPromotion().getDescription((Collection<Promotion>)tree.getPossiblePromotions());
        this.getDescriptionLabel().setText(topLine + '\n' + promotionText);
        this.getDescriptionLabel().clearListeners();
        ActivationExtensionsKt.onActivation(this.getDescriptionLabel(), () -> PromotionPickerScreen.updateDescriptionLabel$lambda$17(this, node));
        ActorKeyShortcutDispatcher.add$default(ActivationExtensionsKt.getKeyShortcuts(this.getDescriptionLabel()), KeyboardBinding.Civilopedia, 0, 2, null);
    }

    @Override
    @NotNull
    public BaseScreen recreate() {
        return this.recreate(this.closeOnPick);
    }

    @NotNull
    public final BaseScreen recreate(boolean closeOnPick) {
        PromotionPickerScreen newScreen = new PromotionPickerScreen(this.unit, closeOnPick, this.originalName, this.onChange);
        newScreen.setScrollY(this.getScrollPane().getScrollY());
        return newScreen;
    }

    private static final Unit _init_$lambda$1(PromotionPickerScreen this$0) {
        if (!Intrinsics.areEqual(this$0.unit.getInstanceName(), this$0.originalName)) {
            Function0<Unit> function0 = this$0.onChange;
            if (function0 != null) {
                function0.invoke();
            }
        }
        this$0.getGame().popScreen();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(PromotionPickerScreen this$0) {
        this$0.acceptPromotion(this$0.selectedPromotion);
        this$0.checkSaveUnitPromotion();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$4$lambda$3(PromotionPickerScreen this$0) {
        this$0.getGame().replaceCurrentScreen(this$0.recreate());
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(PromotionPickerScreen this$0) {
        new UnitRenamePopup(this$0, this$0.unit, () -> PromotionPickerScreen.lambda$4$lambda$3(this$0));
        return Unit.INSTANCE;
    }

    private static final boolean fillTable$isTherePlace(Cell<Actor>[][] cellMatrix, int row, int col, int levels) {
        for (int i = 0; i < levels; ++i) {
            if (cellMatrix[row][col + i].getActor() == null) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final int fillTable$placeButton(Set<String> placedButtons, Cell<Actor>[][] cellMatrix, PromotionPickerScreen this$0, int col, int row, PromotionTree.PromotionNode node) {
        Comparable comparable;
        void $this$sortedBy$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        String name = node.getPromotion().getName();
        if (!placedButtons.contains(name)) {
            if (PromotionPickerScreen.fillTable$isTherePlace(cellMatrix, row, col, node.getLevels())) {
                cellMatrix[row][col].setActor((Actor)this$0.promotionToButton.get(name)).pad(5.0f).padRight(20.0f).minWidth(this$0.buttonCellMinWidth).maxWidth(this$0.buttonCellMaxWidth);
                ((Collection)placedButtons).add(name);
            } else {
                return PromotionPickerScreen.fillTable$placeButton(placedButtons, cellMatrix, this$0, col, row + 1, node);
            }
        }
        Iterable iterable = node.getChildren();
        boolean $i$f$filter = false;
        Comparable comparable2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PromotionTree.PromotionNode it = (PromotionTree.PromotionNode)element$iv$iv;
            boolean bl = false;
            if (!(!placedButtons.contains(it.getPromotion().getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        Iterator iterator2 = ((Iterable)CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(node){
            final /* synthetic */ PromotionTree.PromotionNode $node$inlined;
            {
                this.$node$inlined = promotionNode;
            }

            public final int compare(T a, T b) {
                PromotionTree.PromotionNode it = (PromotionTree.PromotionNode)a;
                boolean bl = false;
                boolean bl2 = !Intrinsics.areEqual(it.getBaseName(), this.$node$inlined.getBaseName());
                it = (PromotionTree.PromotionNode)b;
                Comparable comparable = Boolean.valueOf(bl2);
                bl = false;
                return ComparisonsKt.compareValues(comparable, !Intrinsics.areEqual(it.getBaseName(), this.$node$inlined.getBaseName()));
            }
        })).iterator();
        if (!iterator2.hasNext()) {
            comparable = null;
        } else {
            PromotionTree.PromotionNode it = (PromotionTree.PromotionNode)iterator2.next();
            boolean bl = false;
            comparable2 = Integer.valueOf(PromotionPickerScreen.fillTable$placeButton(placedButtons, cellMatrix, this$0, col + 1, row, it));
            while (iterator2.hasNext()) {
                PromotionTree.PromotionNode it2 = (PromotionTree.PromotionNode)iterator2.next();
                $i$a$-maxOfOrNull-PromotionPickerScreen$fillTable$placeButton$3 = false;
                Comparable comparable3 = Integer.valueOf(PromotionPickerScreen.fillTable$placeButton(placedButtons, cellMatrix, this$0, col + 1, row, it2));
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Integer n = (Integer)comparable;
        return n != null ? n : row;
    }

    private static final Unit saveUnitPromotionForCity$lambda$10(PromotionPickerScreen this$0, boolean it) {
        this$0.saveUnitPromotion = it;
        return Unit.INSTANCE;
    }

    private static final Unit getButton$lambda$11(PromotionPickerScreen this$0, PromotionButton $button, PromotionTree $tree, boolean $isPickable, PromotionTree.PromotionNode $node) {
        this$0.selectedPromotion = $button;
        List<Promotion> path = $tree.getPathTo($button.getNode().getPromotion());
        Set<Promotion> pathAsSet = CollectionsKt.toSet((Iterable)path);
        Set<PromotionTree.PromotionNode> prerequisites = $button.getNode().getParents();
        Iterator<PromotionButton> iterator2 = this$0.promotionToButton.values().iterator();
        while (iterator2.hasNext()) {
            PromotionButton btn;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            btn.updateColor(Intrinsics.areEqual(btn, this$0.selectedPromotion), pathAsSet, prerequisites);
        }
        Scene2dExtensionsKt.setEnabled(this$0.getRightSideButton(), $isPickable);
        this$0.getRightSideButton().setText(TranslationsKt.tr$default($node.getPromotion().getName(), false, false, 3, null));
        this$0.updateDescriptionLabel($isPickable, $tree, $node, path);
        this$0.addConnectingLines(pathAsSet);
        return Unit.INSTANCE;
    }

    private static final Unit getButton$lambda$12(PromotionPickerScreen this$0, PromotionButton $button) {
        this$0.acceptPromotion($button);
        this$0.checkSaveUnitPromotion();
        return Unit.INSTANCE;
    }

    private static final Unit addStatuses$lambda$15(PromotionPickerScreen this$0, String $description) {
        this$0.getDescriptionLabel().setText($description);
        return Unit.INSTANCE;
    }

    private static final void addConnectingLines$addLine(PromotionPickerScreen this$0, float x, float y, float width, float height, Color color) {
        if (color.a == 0.0f) {
            return;
        }
        Image line = ImageGetter.INSTANCE.getWhiteDot();
        line.setBounds(x, y, width, height);
        line.setColor(color);
        this$0.promotionsTable.addActorAt(0, line);
        this$0.lines.add(line);
    }

    private static final CharSequence updateDescriptionLabel$lambda$16(Promotion it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return TranslationsKt.tr$default(it.getName(), false, false, 3, null);
    }

    private static final Unit updateDescriptionLabel$lambda$17(PromotionPickerScreen this$0, PromotionTree.PromotionNode $node) {
        this$0.openCivilopedia($node.getPromotion().makeLink());
        return Unit.INSTANCE;
    }
}

